/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.internal.lifecycle.IUIThreadHolder;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.swt.widgets.Display;

public class LifeCycleUtil {
    private static final String ATTR_SESSION_DISPLAY = String.valueOf(LifeCycleUtil.class.getName()) + "#sessionDisplay";
    private static final String ATTR_UI_THREAD = String.valueOf(LifeCycleUtil.class.getName()) + "#uiThread";

    public static void setSessionDisplay(Display display) {
        ContextProvider.getSession().setAttribute(ATTR_SESSION_DISPLAY, display);
    }

    public static Display getSessionDisplay() {
        Display result = null;
        if (ContextProvider.hasContext()) {
            ISessionStore sessionStore = ContextProvider.getSession();
            result = LifeCycleUtil.getSessionDisplay(sessionStore);
        }
        return result;
    }

    public static Display getSessionDisplay(ISessionStore sessionStore) {
        return (Display)sessionStore.getAttribute(ATTR_SESSION_DISPLAY);
    }

    public static void setUIThread(ISessionStore sessionStore, IUIThreadHolder threadHolder) {
        sessionStore.setAttribute(ATTR_UI_THREAD, threadHolder);
    }

    public static IUIThreadHolder getUIThread(ISessionStore sessionStore) {
        return (IUIThreadHolder)sessionStore.getAttribute(ATTR_UI_THREAD);
    }

    static String getEntryPoint() {
        String result = null;
        HttpServletRequest request = ContextProvider.getRequest();
        String startup = request.getParameter("startup");
        if (startup != null) {
            result = startup;
        } else if (LifeCycleUtil.getSessionDisplay() == null) {
            result = "default";
        }
        return result;
    }

    private LifeCycleUtil() {
    }
}

