/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.protocol;

import java.util.Map;
import org.eclipse.rwt.internal.lifecycle.RWTRequestVersionControl;
import org.eclipse.rwt.internal.protocol.JsonUtil;
import org.eclipse.rwt.internal.protocol.Operation;
import org.eclipse.rwt.internal.theme.JsonArray;
import org.eclipse.rwt.internal.theme.JsonObject;
import org.eclipse.rwt.internal.theme.JsonValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProtocolMessageWriter {
    private final JsonArray operations = new JsonArray();
    private Operation pendingOperation;
    private boolean alreadyCreated;

    public boolean hasOperations() {
        return this.pendingOperation != null;
    }

    public void appendCreate(String target, String type) {
        this.prepareOperation(target, "create");
        this.pendingOperation.appendDetail("type", JsonValue.valueOf(type));
    }

    public void appendSet(String target, String property, int value) {
        this.appendSet(target, property, JsonValue.valueOf(value));
    }

    public void appendSet(String target, String property, double value) {
        this.appendSet(target, property, JsonValue.valueOf(value));
    }

    public void appendSet(String target, String property, boolean value) {
        this.appendSet(target, property, JsonValue.valueOf(value));
    }

    public void appendSet(String target, String property, String value) {
        this.appendSet(target, property, JsonValue.valueOf(value));
    }

    public void appendSet(String target, String property, Object value) {
        this.appendSet(target, property, JsonUtil.createJsonValue(value));
    }

    private void appendSet(String target, String property, JsonValue value) {
        this.prepareOperation(target, "set");
        this.pendingOperation.appendProperty(property, value);
    }

    public void appendListen(String target, String eventType, boolean listen) {
        this.prepareOperation(target, "listen");
        this.pendingOperation.appendProperty(eventType, JsonValue.valueOf(listen));
    }

    public void appendCall(String target, String methodName, Map<String, Object> properties) {
        this.prepareOperation(target, "call");
        this.pendingOperation.appendDetail("method", JsonValue.valueOf(methodName));
        this.pendingOperation.appendProperties(properties);
    }

    public void appendExecuteScript(String target, String scriptType, String code) {
        this.prepareOperation(target, "executeScript");
        this.pendingOperation.appendDetail("scriptType", JsonValue.valueOf(scriptType));
        this.pendingOperation.appendDetail("content", JsonValue.valueOf(code));
    }

    public void appendDestroy(String target) {
        this.prepareOperation(target, "destroy");
    }

    private void prepareOperation(String target, String type) {
        this.ensureMessagePending();
        if (!this.canAppendToCurrentOperation(target, type)) {
            this.appendPendingOperation();
            this.pendingOperation = new Operation(target, type);
        }
    }

    public String createMessage() {
        this.ensureMessagePending();
        this.alreadyCreated = true;
        JsonObject message = this.createMessageObject();
        return message.toString();
    }

    private void ensureMessagePending() {
        if (this.alreadyCreated) {
            throw new IllegalStateException("Message already created");
        }
    }

    private JsonObject createMessageObject() {
        JsonObject message = new JsonObject();
        JsonObject meta = new JsonObject();
        int requestCount = RWTRequestVersionControl.getInstance().getCurrentRequestId();
        meta.append("requestCounter", requestCount);
        message.append("meta", meta);
        this.appendPendingOperation();
        message.append("operations", this.operations);
        return message;
    }

    private boolean canAppendToCurrentOperation(String target, String action) {
        boolean result = false;
        if (this.pendingOperation != null && this.pendingOperation.getTarget().equals(target)) {
            String pendingAction = this.pendingOperation.getAction();
            if ("listen".equals(action)) {
                result = pendingAction.equals("listen");
            } else if ("set".equals(action)) {
                result = pendingAction.equals("create") || pendingAction.equals("set");
            }
        }
        return result;
    }

    private void appendPendingOperation() {
        if (this.pendingOperation != null) {
            this.operations.append(this.pendingOperation.toJson());
        }
    }
}

