/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.resources;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.rwt.internal.engine.RWTConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContextURLs {
    private final RWTConfiguration configuration;
    private final URL[] contextURLs;

    ContextURLs(RWTConfiguration configuration) {
        this.configuration = configuration;
        this.contextURLs = this.getContextURLs();
    }

    URL[] get() {
        return this.contextURLs;
    }

    private URL[] getContextURLs() {
        LinkedList<URL> buffer = new LinkedList<URL>();
        buffer.add(this.getClassDirectoryURL());
        buffer.addAll(this.getLibraryPaths());
        URL[] result = new URL[buffer.size()];
        buffer.toArray(result);
        return result;
    }

    private Collection<URL> getLibraryPaths() {
        LinkedList<URL> result = new LinkedList<URL>();
        List<File> pathList = this.getLibraryPath();
        int i = 0;
        while (i < pathList.size()) {
            File libraryFile = pathList.get(i);
            URL library = ContextURLs.getLibraryURL(libraryFile);
            result.add(library);
            ++i;
        }
        return result;
    }

    private static URL getLibraryURL(File libraryFile) {
        URL result;
        try {
            result = libraryFile.toURI().toURL();
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception shouldNotHappen) {
            throw new RuntimeException(shouldNotHappen);
        }
        return result;
    }

    private URL getClassDirectoryURL() {
        File classDirectory = this.configuration.getClassDirectory();
        return ContextURLs.getLibraryURL(classDirectory);
    }

    private List<File> getLibraryPath() {
        LinkedList<File> result = new LinkedList<File>();
        File libDir = this.configuration.getLibraryDirectory();
        String[] libraryNames = libDir.list();
        if (libraryNames != null) {
            int i = 0;
            while (i < libraryNames.length) {
                if (libraryNames[i].endsWith(".jar")) {
                    result.add(new File(String.valueOf(libDir.toString()) + File.separator + libraryNames[i]));
                }
                ++i;
            }
        }
        return result;
    }
}

