/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.resources;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPOutputStream;
import org.eclipse.rwt.internal.resources.JSLibraryServiceHandler;
import org.eclipse.rwt.internal.util.StreamUtil;

public class JSLibraryConcatenator {
    private ByteArrayOutputStream jsConcatenator;
    private String hashCode;
    private byte[] compressed;
    private byte[] uncompressed;
    private String content = "";

    public String getHashCode() {
        return this.hashCode;
    }

    public byte[] getCompressed() {
        return this.compressed;
    }

    public byte[] getUncompressed() {
        return this.uncompressed;
    }

    public String getContent() {
        if (this.jsConcatenator != null) {
            try {
                this.content = this.jsConcatenator.toString("UTF-8");
            }
            catch (UnsupportedEncodingException shouldNotHappen) {
                throw new RuntimeException(shouldNotHappen);
            }
            this.jsConcatenator = null;
        }
        return this.content;
    }

    public void startJSConcatenation() {
        this.jsConcatenator = new ByteArrayOutputStream();
    }

    public void appendJSLibrary(byte[] content) {
        if (this.jsConcatenator != null) {
            int i = 0;
            while (i < content.length) {
                this.jsConcatenator.write(content[i]);
                if (JSLibraryConcatenator.isLastCharacter(content, i)) {
                    this.writeNewLine();
                }
                ++i;
            }
        }
    }

    public void activate() {
        try {
            this.initialize();
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception shouldNotHappen) {
            throw new RuntimeException(shouldNotHappen);
        }
    }

    public void deactivate() {
        this.jsConcatenator = null;
        this.hashCode = null;
        this.compressed = null;
        this.uncompressed = null;
        this.content = null;
    }

    private void writeNewLine() {
        this.jsConcatenator.write(10);
    }

    private static boolean isLastCharacter(byte[] content, int position) {
        return position == content.length - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws UnsupportedEncodingException, IOException {
        Class<JSLibraryServiceHandler> clazz = JSLibraryServiceHandler.class;
        synchronized (JSLibraryServiceHandler.class) {
            if (!this.isInitialized()) {
                this.initializeUncompressed();
                this.initializeCompressed();
                this.initializeHashCode();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private boolean isInitialized() {
        return this.uncompressed != null;
    }

    private void initializeCompressed() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzipStream = new GZIPOutputStream(baos);
        StreamUtil.write(this.uncompressed, gzipStream);
        gzipStream.close();
        this.compressed = baos.toByteArray();
    }

    private void initializeHashCode() {
        this.hashCode = "H" + this.getContent().hashCode();
    }

    private void initializeUncompressed() throws UnsupportedEncodingException {
        this.uncompressed = this.getContent().getBytes("UTF-8");
    }
}

