/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.ServiceContext;
import org.eclipse.rwt.internal.service.WrappedRequest;
import org.eclipse.rwt.service.ISessionStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RequestParameterBuffer {
    private static final String BUFFER = String.valueOf(RequestParameterBuffer.class.getName()) + "#buffer:-)";

    static void store(Map<String, String[]> parameters) {
        if (RequestParameterBuffer.getBufferedParameters() == null) {
            HashMap<String, String[]> buffer = new HashMap<String, String[]>(parameters);
            ISessionStore sessionStore = ContextProvider.getSession();
            sessionStore.setAttribute(BUFFER, buffer);
        }
    }

    static void merge() {
        HttpServletRequest request = ContextProvider.getRequest();
        Map<String, String[]> bufferedParams = RequestParameterBuffer.getBufferedParameters();
        if (bufferedParams != null) {
            WrappedRequest wrappedRequest = new WrappedRequest(request, bufferedParams);
            ServiceContext context = ContextProvider.getContext();
            context.setRequest((HttpServletRequest)wrappedRequest);
        }
        ContextProvider.getSession().removeAttribute(BUFFER);
    }

    static Map<String, String[]> getBufferedParameters() {
        return (Map)ContextProvider.getSession().getAttribute(BUFFER);
    }

    private RequestParameterBuffer() {
    }
}

