/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.internal.RWTMessages;
import org.eclipse.rwt.internal.branding.BrandingUtil;
import org.eclipse.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rwt.internal.resources.JSLibraryServiceHandler;
import org.eclipse.rwt.internal.resources.ResourceRegistry;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.StartupPage;
import org.eclipse.rwt.internal.service.StartupPageTemplateHolder;
import org.eclipse.rwt.internal.textsize.MeasurementUtil;
import org.eclipse.rwt.internal.theme.ThemeUtil;
import org.eclipse.rwt.resources.IResource;
import org.eclipse.rwt.resources.IResourceManager;

final class StartupPageConfigurer
implements StartupPage.IStartupPageConfigurer {
    private static final String PACKAGE_NAME = StartupPageConfigurer.class.getPackage().getName();
    private static final String FOLDER = PACKAGE_NAME.replace('.', '/');
    private static final String INDEX_TEMPLATE = String.valueOf(FOLDER) + "/rwt-index.html";
    private static final String DISPLAY_TYPE = "rwt.Display";
    private static final String PROPERTY_FONTS = "fonts";
    private static final String METHOD_PROBE = "probe";
    private static final String PROPERTY_URL = "url";
    private static final String PROPERTY_ROOT_ID = "rootId";
    private static final String METHOD_INIT = "init";
    private static final String PROPERTY_ENTRYPOINT = "entrypoint";
    private final List<AbstractBranding> registeredBrandings;
    private final ResourceRegistry resourceRegistry;
    private int probeCount;
    private long lastModified;
    private StartupPageTemplateHolder template;

    StartupPageConfigurer(ResourceRegistry resourceRegistry) {
        this.resourceRegistry = resourceRegistry;
        this.lastModified = System.currentTimeMillis();
        this.registeredBrandings = new LinkedList<AbstractBranding>();
    }

    public StartupPageTemplateHolder getTemplate() throws IOException {
        this.readContent();
        this.template.reset();
        this.template.replace(StartupPageTemplateHolder.VAR_LIBRARIES, this.getJsLibraries());
        this.template.replace(StartupPageTemplateHolder.VAR_APPSCRIPT, StartupPageConfigurer.getAppScript());
        this.applyBranding();
        return this.template;
    }

    public synchronized boolean isModifiedSince() {
        boolean result;
        int currentProbeCount = MeasurementUtil.getProbeCount();
        if (this.probeCount != currentProbeCount) {
            this.lastModified = System.currentTimeMillis();
            this.probeCount = currentProbeCount;
        }
        HttpServletRequest request = ContextProvider.getRequest();
        HttpServletResponse response = ContextProvider.getResponse();
        response.addHeader("Cache-Control", "max-age=0, no-cache, must-revalidate, no-store");
        long dateHeader = request.getDateHeader("If-Modified-Since");
        if (dateHeader + 1000L < this.lastModified) {
            result = true;
            response.addDateHeader("Last-Modified", this.lastModified);
        } else {
            result = false;
            response.setStatus(304);
        }
        return result;
    }

    private void readContent() throws IOException {
        if (this.template == null) {
            InputStream stream = StartupPageConfigurer.loadTemplateFile();
            InputStreamReader streamReader = new InputStreamReader(stream, "UTF-8");
            BufferedReader reader = new BufferedReader(streamReader);
            try {
                String line = reader.readLine();
                StringBuilder buffer = new StringBuilder();
                while (line != null) {
                    buffer.append(line);
                    buffer.append('\n');
                    line = reader.readLine();
                }
                this.template = new StartupPageTemplateHolder(buffer.toString());
            }
            finally {
                reader.close();
            }
        }
    }

    private static InputStream loadTemplateFile() throws IOException {
        InputStream result = null;
        IResourceManager resourceManager = RWT.getResourceManager();
        ClassLoader buffer = resourceManager.getContextLoader();
        resourceManager.setContextLoader(StartupPageConfigurer.class.getClassLoader());
        try {
            result = resourceManager.getResourceAsStream(INDEX_TEMPLATE);
            if (result == null) {
                String text = "Failed to load Browser Survey HTML Page. Resource {0} could not be found.";
                Object[] param = new Object[]{INDEX_TEMPLATE};
                String msg = MessageFormat.format(text, param);
                throw new IOException(msg);
            }
        }
        finally {
            resourceManager.setContextLoader(buffer);
        }
        return result;
    }

    private static String getAppScript() {
        StringBuilder code = new StringBuilder();
        code.append("org.eclipse.rwt.protocol.Processor.processMessage");
        code.append("( ");
        code.append(StartupPageConfigurer.getStartupProtocolMessage("w1"));
        code.append(" );/*EOM*/");
        return code.toString();
    }

    private static String getStartupProtocolMessage(String id) {
        ProtocolMessageWriter writer = new ProtocolMessageWriter();
        StartupPageConfigurer.appendCreateDisplay(id, writer);
        StartupPageConfigurer.appendStartupTextSizeProbe(id, writer);
        StartupPageConfigurer.appendInitDisplay(id, writer);
        return writer.createMessage();
    }

    private static void appendCreateDisplay(String id, ProtocolMessageWriter writer) {
        writer.appendCreate(id, DISPLAY_TYPE);
    }

    private static void appendStartupTextSizeProbe(String id, ProtocolMessageWriter writer) {
        Object startupTextSizeProbeObject = StartupPageConfigurer.getStartupTextSizeProbeObject();
        if (startupTextSizeProbeObject != null) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put(PROPERTY_FONTS, startupTextSizeProbeObject);
            writer.appendCall(id, METHOD_PROBE, args);
        }
    }

    private static void appendInitDisplay(String id, ProtocolMessageWriter writer) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put(PROPERTY_URL, StartupPageConfigurer.getUrl());
        args.put(PROPERTY_ENTRYPOINT, StartupPageConfigurer.getEntryPoint());
        args.put(PROPERTY_ROOT_ID, id);
        writer.appendCall(id, METHOD_INIT, args);
    }

    private static Object getStartupTextSizeProbeObject() {
        return MeasurementUtil.getStartupProbeObject();
    }

    private static String getUrl() {
        HttpServletRequest request = ContextProvider.getRequest();
        String url = request.getServletPath().substring(1);
        return ContextProvider.getResponse().encodeURL(url);
    }

    private void applyBranding() throws IOException {
        AbstractBranding branding = BrandingUtil.determineBranding();
        this.registerBrandingResources(branding);
        this.registerBrandingResources(branding);
        if (branding.getThemeId() != null) {
            ThemeUtil.setCurrentThemeId(branding.getThemeId());
        }
        BrandingUtil.replacePlaceholder(this.template, StartupPageTemplateHolder.VAR_BODY, branding.getBody());
        BrandingUtil.replacePlaceholder(this.template, StartupPageTemplateHolder.VAR_TITLE, branding.getTitle());
        String headers = BrandingUtil.headerMarkup(branding);
        BrandingUtil.replacePlaceholder(this.template, StartupPageTemplateHolder.VAR_HEADERS, headers);
        String noScriptWarning = RWTMessages.getMessage("RWT_NoScriptWarning");
        BrandingUtil.replacePlaceholder(this.template, StartupPageTemplateHolder.VAR_NO_SCRIPT_MESSAGE, noScriptWarning);
    }

    private static String getEntryPoint() {
        AbstractBranding branding = BrandingUtil.determineBranding();
        HttpServletRequest request = ContextProvider.getRequest();
        String entryPoint = request.getParameter("startup");
        if (entryPoint == null && ((entryPoint = branding.getDefaultEntryPoint()) == null || "".equals(entryPoint))) {
            entryPoint = "default";
        }
        return entryPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerBrandingResources(AbstractBranding branding) throws IOException {
        List<AbstractBranding> list = this.registeredBrandings;
        synchronized (list) {
            if (!this.registeredBrandings.contains(branding)) {
                branding.registerResources();
                this.registeredBrandings.add(branding);
            }
        }
    }

    private String getJsLibraries() {
        StringBuilder buffer = new StringBuilder();
        IResource[] resources = this.resourceRegistry.get();
        int i = 0;
        while (i < resources.length) {
            if (resources[i].isExternal() && resources[i].isJSLibrary()) {
                StartupPageConfigurer.writeScriptTag(buffer, resources[i].getLocation());
            }
            ++i;
        }
        StartupPageConfigurer.writeScriptTag(buffer, JSLibraryServiceHandler.getRequestURL());
        return buffer.toString();
    }

    private static void writeScriptTag(StringBuilder buffer, String library) {
        buffer.append("<script type=\"text/javascript\" src=\"");
        buffer.append(library);
        buffer.append("\" charset=\"");
        buffer.append("UTF-8");
        buffer.append("\"></script>");
    }
}

