/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.textsize;

import java.math.BigDecimal;
import org.eclipse.rwt.internal.textsize.MeasurementOperator;
import org.eclipse.rwt.internal.textsize.MeasurementUtil;
import org.eclipse.rwt.internal.textsize.ProbeResult;
import org.eclipse.rwt.internal.textsize.ProbeResultStore;
import org.eclipse.rwt.internal.textsize.TextSizeEstimation;
import org.eclipse.rwt.internal.textsize.TextSizeStorageUtil;
import org.eclipse.rwt.internal.textsize.TextSizeUtilFacade;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.graphics.FontUtil;

public class TextSizeUtil {
    private static final int STRING_EXTENT = 0;
    private static final int TEXT_EXTENT = 1;

    public static Point stringExtent(Font font, String string) {
        Point result = TextSizeUtil.isEmptyString(string) ? TextSizeUtil.createSizeForEmptyString(font) : TextSizeUtil.determineTextSize(font, string, -1, 0);
        return result;
    }

    public static Point textExtent(Font font, String text, int wrapWidth) {
        Point result = TextSizeUtil.determineTextSize(font, text, wrapWidth, 1);
        if (wrapWidth > 0 && result.x > wrapWidth) {
            result = TextSizeUtil.adjustWrapDetermination(font, text, wrapWidth);
        }
        return result;
    }

    public static int getCharHeight(Font font) {
        int result;
        if (TextSizeUtil.containsProbeResult(font)) {
            result = TextSizeUtil.lookupCharHeight(font);
        } else {
            result = TextSizeUtil.estimateCharHeight(font);
            TextSizeUtil.addProbeToMeasure(font);
        }
        return result;
    }

    public static float getAvgCharWidth(Font font) {
        float result;
        if (TextSizeUtil.containsProbeResult(font)) {
            result = TextSizeUtil.lookupAvgCharWidth(font);
        } else {
            result = TextSizeUtil.estimateAvgCharWidth(font);
            TextSizeUtil.addProbeToMeasure(font);
        }
        return result;
    }

    private static Point createSizeForEmptyString(Font font) {
        return new Point(0, TextSizeUtil.getCharHeight(font));
    }

    private static boolean isEmptyString(String string) {
        return string.length() == 0;
    }

    private static Point determineTextSize(Font font, String string, int wrapWidth, int mode) {
        Point result = TextSizeUtil.lookup(font, string, wrapWidth, mode);
        if (result == null) {
            result = TextSizeUtil.estimate(font, string, wrapWidth, mode);
            TextSizeUtil.addItemToMeasure(font, string, wrapWidth, mode);
        }
        if (TextSizeUtil.isHeightZero(result)) {
            result = TextSizeUtil.adjustHeightForWhitespaceTexts(font, result);
        }
        return result;
    }

    private static boolean isHeightZero(Point result) {
        return result.y == 0;
    }

    private static Point lookup(Font font, String string, int wrapWidth, int mode) {
        String measurementString = TextSizeUtil.createMeasurementString(string, mode);
        FontData fontData = FontUtil.getData(font);
        return TextSizeStorageUtil.lookup(fontData, measurementString, wrapWidth);
    }

    private static Point estimate(Font font, String string, int wrapWidth, int mode) {
        Point result;
        switch (mode) {
            case 0: {
                result = TextSizeEstimation.stringExtent(font, string);
                break;
            }
            case 1: {
                result = TextSizeEstimation.textExtent(font, string, wrapWidth);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown estimation mode.");
            }
        }
        return result;
    }

    private static void addItemToMeasure(Font font, String string, int wrapWidth, int mode) {
        String measurementString = TextSizeUtil.createMeasurementString(string, mode);
        MeasurementUtil.addItemToMeasure(measurementString, font, wrapWidth);
    }

    private static String createMeasurementString(String string, int mode) {
        boolean expandNewLines = mode == 1;
        return TextSizeUtilFacade.createMeasurementString(string, expandNewLines);
    }

    private static Point adjustWrapDetermination(Font font, String text, int wrapWidth) {
        Point result = TextSizeEstimation.textExtent(font, text, wrapWidth);
        BigDecimal height = new BigDecimal(result.y);
        BigDecimal charHeight = new BigDecimal(TextSizeEstimation.getCharHeight(font));
        int rows = height.divide(charHeight, 0, 4).intValue();
        result.y = TextSizeUtil.getCharHeight(font) * rows;
        return result;
    }

    private static Point adjustHeightForWhitespaceTexts(Font font, Point result) {
        return new Point(result.x, TextSizeUtil.getCharHeight(font));
    }

    private static void addProbeToMeasure(Font font) {
        MeasurementOperator.getInstance().addProbeToMeasure(FontUtil.getData(font));
    }

    private static int estimateCharHeight(Font font) {
        return TextSizeEstimation.getCharHeight(font);
    }

    private static int lookupCharHeight(Font font) {
        return TextSizeUtil.getProbeResult((Font)font).getSize().y;
    }

    private static boolean containsProbeResult(Font font) {
        return ProbeResultStore.getInstance().containsProbeResult(FontUtil.getData(font));
    }

    private static float estimateAvgCharWidth(Font font) {
        return TextSizeEstimation.getAvgCharWidth(font);
    }

    private static float lookupAvgCharWidth(Font font) {
        return TextSizeUtil.getProbeResult(font).getAvgCharWidth();
    }

    private static ProbeResult getProbeResult(Font font) {
        FontData data = FontUtil.getData(font);
        return ProbeResultStore.getInstance().getProbeResult(data);
    }

    private TextSizeUtil() {
    }
}

