/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

public abstract class JsonValue {
    public static final JsonValue NULL = new JsonPrimitive("null");
    public static final JsonValue TRUE = new JsonPrimitive("true");
    public static final JsonValue FALSE = new JsonPrimitive("false");

    JsonValue() {
    }

    public static JsonValue valueOf(int value) {
        return new JsonPrimitive(String.valueOf(value));
    }

    public static JsonValue valueOf(float value) {
        return new JsonPrimitive(String.valueOf(value));
    }

    public static JsonValue valueOf(double value) {
        return new JsonPrimitive(String.valueOf(value));
    }

    public static JsonValue valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static JsonValue valueOf(String value) {
        JsonValue result = value == null ? NULL : new JsonPrimitive(JsonValue.quoteAndEscapeString(value));
        return result;
    }

    static String quoteAndEscapeString(String string) {
        StringBuilder resultBuffer = new StringBuilder();
        resultBuffer.append('\"');
        resultBuffer.append(JsonValue.escapeString(string));
        resultBuffer.append('\"');
        return resultBuffer.toString();
    }

    static String escapeString(String string) {
        StringBuilder resultBuffer = new StringBuilder();
        int length = string.length();
        int i = 0;
        while (i < length) {
            char ch = string.charAt(i);
            if (ch == '\"' || ch == '\\') {
                resultBuffer.append('\\');
                resultBuffer.append(ch);
            } else if (ch == '\n') {
                resultBuffer.append("\\n");
            } else if (ch == '\r') {
                resultBuffer.append("\\r");
            } else if (ch == '\t') {
                resultBuffer.append("\\t");
            } else if (ch == '\u2028') {
                resultBuffer.append("\\u2028");
            } else if (ch == '\u2029') {
                resultBuffer.append("\\u2029");
            } else if (ch == '\u0000') {
                resultBuffer.append("\\u0000");
            } else {
                resultBuffer.append(ch);
            }
            ++i;
        }
        return resultBuffer.toString();
    }

    private static class JsonPrimitive
    extends JsonValue {
        private final String value;

        JsonPrimitive(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

