/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.lifecycle;

import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.internal.util.ParamCheck;

public final class JSVar {
    private static final String UNIQUE_NUMBER = String.valueOf(JSVar.class.getName()) + "#uniqueNumber";
    private final String name;

    public JSVar() {
        this.name = JSVar.uniqueVarName();
    }

    public JSVar(String name) {
        ParamCheck.notNull(name, "name");
        if (name.length() == 0) {
            String msg = "The argument 'name' must not be empty.";
            throw new IllegalArgumentException(msg);
        }
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    private static String uniqueVarName() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        Object attribute = stateInfo.getAttribute(UNIQUE_NUMBER);
        Integer lastUniqueNumber = (Integer)attribute;
        if (lastUniqueNumber == null) {
            lastUniqueNumber = new Integer(-1);
        }
        int uniqueNumber = lastUniqueNumber + 1;
        stateInfo.setAttribute(UNIQUE_NUMBER, new Integer(uniqueNumber));
        return "v" + uniqueNumber;
    }
}

