/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.lifecycle;

import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rwt.internal.protocol.IClientObject;
import org.eclipse.rwt.internal.protocol.RWTStylesUtil;
import org.eclipse.rwt.internal.protocol.StylesUtil;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.util.EncodingUtil;
import org.eclipse.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rwt.internal.util.SharedInstanceBuffer;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.FontUtil;
import org.eclipse.swt.internal.graphics.ImageFactory;
import org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public final class WidgetLCAUtil {
    private static final String JS_PROP_HEIGHT = "height";
    private static final String JS_PROP_WIDTH = "width";
    private static final String PARAM_X = "bounds.x";
    private static final String PARAM_Y = "bounds.y";
    private static final String PARAM_WIDTH = "bounds.width";
    private static final String PARAM_HEIGHT = "bounds.height";
    private static final String PROP_TOOL_TIP_TEXT = "toolTipText";
    private static final String PROP_FONT = "font";
    private static final String PROP_FOREGROUND = "foreground";
    private static final String PROP_BACKGROUND = "background";
    private static final String PROP_BACKGROUND_TRANSPARENCY = "backgroundTrans";
    private static final String PROP_BACKGROUND_GRADIENT_COLORS = "backgroundGradientColors";
    private static final String PROP_BACKGROUND_GRADIENT_PERCENTS = "backgroundGradientPercents";
    private static final String PROP_BACKGROUND_GRADIENT_VERTICAL = "backgroundGradientVertical";
    private static final String PROP_ROUNDED_BORDER_WIDTH = "roundedBorderWidth";
    private static final String PROP_ROUNDED_BORDER_COLOR = "roundedBorderColor";
    private static final String PROP_ROUNDED_BORDER_RADIUS = "roundedBorderRadius";
    private static final String PROP_ENABLED = "enabled";
    private static final String PROP_VARIANT = "variant";
    private static final String PROP_HELP_LISTENER = "helpListener";
    private static final String LISTENER_PREFIX = "listener_";
    private static final String JS_PROP_SPACE = "space";
    private static final String JS_FUNC_SET_TOOL_TIP = "setToolTip";
    private static final String JS_FUNC_SET_ROUNDED_BORDER = "setRoundedBorder";
    private static final String JS_FUNC_SET_HAS_LISTENER = "setHasListener";
    private static final String JS_EVENT_TYPE_HELP = "help";
    private static final Pattern FONT_NAME_FILTER_PATTERN = Pattern.compile("\"|\\\\");
    private static final Rectangle DEF_ROUNDED_BORDER_RADIUS = new Rectangle(0, 0, 0, 0);
    private static final SharedInstanceBuffer<String, String[]> parsedFonts = new SharedInstanceBuffer();

    private WidgetLCAUtil() {
    }

    public static void preserveProperty(Widget widget, String property, Object value) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(property, value);
    }

    public static void preserveProperty(Widget widget, String property, int value) {
        WidgetLCAUtil.preserveProperty(widget, property, (Object)value);
    }

    public static void preserveProperty(Widget widget, String property, boolean value) {
        WidgetLCAUtil.preserveProperty(widget, property, (Object)value);
    }

    public static void preserveListener(Widget widget, String listener, boolean value) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(LISTENER_PREFIX + listener, new Boolean(value));
    }

    public static void preserveBounds(Widget widget, Rectangle bounds) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve("bounds", bounds);
    }

    public static void preserveToolTipText(Widget widget, String toolTip) {
        String text = toolTip == null ? "" : toolTip;
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(PROP_TOOL_TIP_TEXT, text);
    }

    public static void preserveFont(Widget widget, Font font) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(PROP_FONT, font);
    }

    public static void preserveForeground(Widget widget, Color foreground) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(PROP_FOREGROUND, foreground);
    }

    public static void preserveBackground(Widget widget, Color background) {
        WidgetLCAUtil.preserveBackground(widget, background, false);
    }

    public static void preserveBackground(Widget widget, Color background, boolean transparency) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(PROP_BACKGROUND, background);
        adapter.preserve(PROP_BACKGROUND_TRANSPARENCY, transparency);
    }

    public static void preserveBackgroundGradient(Widget widget) {
        IWidgetGraphicsAdapter adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
        if (adapter != null) {
            IWidgetGraphicsAdapter gfxAdapter = adapter;
            Color[] bgGradientColors = gfxAdapter.getBackgroundGradientColors();
            int[] bgGradientPercents = gfxAdapter.getBackgroundGradientPercents();
            boolean bgGradientVertical = gfxAdapter.isBackgroundGradientVertical();
            IWidgetAdapter widgetAdapter = WidgetUtil.getAdapter(widget);
            widgetAdapter.preserve(PROP_BACKGROUND_GRADIENT_COLORS, bgGradientColors);
            widgetAdapter.preserve(PROP_BACKGROUND_GRADIENT_PERCENTS, bgGradientPercents);
            widgetAdapter.preserve(PROP_BACKGROUND_GRADIENT_VERTICAL, bgGradientVertical);
        }
    }

    public static void preserveRoundedBorder(Widget widget) {
        IWidgetGraphicsAdapter adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
        if (adapter != null) {
            IWidgetGraphicsAdapter gfxAdapter = adapter;
            int width = gfxAdapter.getRoundedBorderWidth();
            Color color = gfxAdapter.getRoundedBorderColor();
            Rectangle radius = gfxAdapter.getRoundedBorderRadius();
            IWidgetAdapter widgetAdapter = WidgetUtil.getAdapter(widget);
            widgetAdapter.preserve(PROP_ROUNDED_BORDER_WIDTH, width);
            widgetAdapter.preserve(PROP_ROUNDED_BORDER_COLOR, color);
            widgetAdapter.preserve(PROP_ROUNDED_BORDER_RADIUS, radius);
        }
    }

    public static void preserveEnabled(Widget widget, boolean enabled) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(PROP_ENABLED, enabled);
    }

    public static void preserveCustomVariant(Widget widget) {
        String variant = WidgetUtil.getVariant(widget);
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(PROP_VARIANT, variant);
    }

    public static boolean hasChanged(Widget widget, String property, Object newValue) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        Object oldValue = adapter.getPreserved(property);
        return !WidgetLCAUtil.equals(oldValue, newValue);
    }

    public static boolean hasChanged(Widget widget, String property, Object newValue, Object defaultValue) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        boolean result = adapter.isInitialized() ? WidgetLCAUtil.hasChanged(widget, property, newValue) : !WidgetLCAUtil.equals(newValue, defaultValue);
        return result;
    }

    public static String readPropertyValue(Widget widget, String propertyName) {
        HttpServletRequest request = ContextProvider.getRequest();
        StringBuffer key = new StringBuffer();
        key.append(WidgetUtil.getId(widget));
        key.append(".");
        key.append(propertyName);
        return request.getParameter(key.toString());
    }

    public static boolean wasEventSent(Widget widget, String eventName) {
        HttpServletRequest request = ContextProvider.getRequest();
        String widgetId = request.getParameter(eventName);
        return WidgetUtil.getId(widget).equals(widgetId);
    }

    public static Rectangle readBounds(Widget widget, Rectangle defValue) {
        return WidgetLCAUtil.readBounds(WidgetUtil.getId(widget), defValue);
    }

    public static Rectangle readBounds(String widgetId, Rectangle defValue) {
        int x = WidgetLCAUtil.readBoundsX(widgetId, defValue.x);
        int y = WidgetLCAUtil.readBoundsY(widgetId, defValue.y);
        int width = WidgetLCAUtil.readBoundsWidth(widgetId, defValue.width);
        int height = WidgetLCAUtil.readBoundsHeight(widgetId, defValue.height);
        return new Rectangle(x, y, width, height);
    }

    public static void renderProperty(Widget widget, String property, Object newValue, Object defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.setProperty(property, newValue);
        }
    }

    public static void renderProperty(Widget widget, String property, int newValue, int defaultValue) {
        Integer defValue = defaultValue;
        WidgetLCAUtil.renderProperty(widget, property, (Object)newValue, defValue);
    }

    public static void renderProperty(Widget widget, String property, boolean newValue, boolean defaultValue) {
        Boolean defValue = defaultValue;
        WidgetLCAUtil.renderProperty(widget, property, (Object)newValue, defValue);
    }

    public static void renderProperty(Widget widget, String property, Image newValue, Image defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.setProperty(property, WidgetLCAUtil.getImageAsArray(newValue));
        }
    }

    public static void renderProperty(Widget widget, String property, Image[] newValue, Image[] defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            Object[] images = new Object[newValue.length];
            int i = 0;
            while (i < images.length) {
                images[i] = WidgetLCAUtil.getImageAsArray(newValue[i]);
                ++i;
            }
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.setProperty(property, images);
        }
    }

    private static Object[] getImageAsArray(Image image) {
        Object[] result = null;
        if (image != null) {
            String imagePath = ImageFactory.getImagePath(image);
            Rectangle bounds = image.getBounds();
            result = new Object[]{imagePath, bounds.width, bounds.height};
        }
        return result;
    }

    public static void renderProperty(Widget widget, String property, Color[] newValue, Color[] defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            Object[] colors = new Object[newValue.length];
            int i = 0;
            while (i < colors.length) {
                int[] colorProperties = null;
                if (newValue[i] != null) {
                    colorProperties = WidgetLCAUtil.getColorValueAsArray(newValue[i], false);
                }
                colors[i] = colorProperties;
                ++i;
            }
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.setProperty(property, colors);
        }
    }

    public static void renderProperty(Widget widget, String property, Font[] newValue, Font[] defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            Object[] fonts = new Object[newValue.length];
            int i = 0;
            while (i < fonts.length) {
                fonts[i] = WidgetLCAUtil.getFontAsArray(newValue[i]);
                ++i;
            }
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.setProperty(property, fonts);
        }
    }

    public static void renderProperty(Widget widget, String property, Point newValue, Point defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            int[] args = null;
            if (newValue != null) {
                args = new int[]{newValue.x, newValue.y};
            }
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.setProperty(property, args);
        }
    }

    public static void renderProperty(Widget widget, String property, Widget newValue, Widget defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            String widgetId = newValue == null ? null : WidgetUtil.getId(newValue);
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.setProperty(property, widgetId);
        }
    }

    public static void renderListener(Widget widget, String listener, boolean newValue, boolean defaultValue) {
        Boolean defValue;
        Boolean value;
        String property = LISTENER_PREFIX + listener;
        if (WidgetLCAUtil.hasChanged(widget, property, value = new Boolean(newValue), defValue = new Boolean(defaultValue))) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            if (newValue) {
                clientObject.addListener(listener);
            } else {
                clientObject.removeListener(listener);
            }
        }
    }

    public static void writeBounds(Widget widget, Control parent, Rectangle bounds) throws IOException {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        Rectangle oldBounds = (Rectangle)adapter.getPreserved("bounds");
        Rectangle newBounds = bounds;
        if (!adapter.isInitialized() || !newBounds.equals(oldBounds)) {
            if (parent != null) {
                AbstractWidgetLCA parentLCA = WidgetUtil.getLCA(parent);
                newBounds = parentLCA.adjustCoordinates(widget, newBounds);
            }
            JSWriter writer = JSWriter.getWriterFor(widget);
            if (parent instanceof ScrolledComposite) {
                writer.set(JS_PROP_WIDTH, newBounds.width);
                writer.set(JS_PROP_HEIGHT, newBounds.height);
            } else {
                Object[] args = new Integer[]{new Integer(newBounds.x), new Integer(newBounds.width), new Integer(newBounds.y), new Integer(newBounds.height)};
                writer.set(JS_PROP_SPACE, args);
            }
        }
    }

    public static void renderBounds(Widget widget, Control parent, Rectangle bounds) throws IOException {
        if (WidgetLCAUtil.hasChanged(widget, "bounds", bounds)) {
            Rectangle newBounds = bounds;
            if (parent != null) {
                AbstractWidgetLCA parentLCA = WidgetUtil.getLCA(parent);
                newBounds = parentLCA.adjustCoordinates(widget, newBounds);
            }
            int[] args = new int[]{newBounds.x, newBounds.y, newBounds.width, newBounds.height};
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.setProperty("bounds", args);
        }
    }

    public static void writeMenu(Widget widget, Menu menu) throws IOException {
        if (WidgetLCAUtil.hasChanged(widget, "menu", menu, null)) {
            JSWriter writer = JSWriter.getWriterFor(widget);
            writer.call(JSWriter.WIDGET_MANAGER_REF, "setContextMenu", new Object[]{widget, menu});
        }
    }

    public static void renderMenu(Widget widget, Menu menu) throws IOException {
        WidgetLCAUtil.renderProperty(widget, "menu", menu, null);
    }

    public static void writeToolTip(Widget widget, String toolTip) throws IOException {
        String text;
        String string = text = toolTip == null ? "" : toolTip;
        if (WidgetLCAUtil.hasChanged(widget, PROP_TOOL_TIP_TEXT, text, "")) {
            JSWriter writer = JSWriter.getWriterFor(widget);
            text = WidgetLCAUtil.escapeText(text, false);
            text = WidgetLCAUtil.replaceNewLines(text, "<br/>");
            Object[] args = new Object[]{widget, text};
            writer.call(JSWriter.WIDGET_MANAGER_REF, JS_FUNC_SET_TOOL_TIP, args);
        }
    }

    public static void renderToolTip(Widget widget, String toolTip) throws IOException {
        String text;
        String string = text = toolTip == null ? "" : toolTip;
        if (WidgetLCAUtil.hasChanged(widget, PROP_TOOL_TIP_TEXT, text, "")) {
            text = WidgetLCAUtil.escapeText(text, false);
            text = WidgetLCAUtil.replaceNewLines(text, "<br/>");
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.setProperty("toolTip", text);
        }
    }

    public static void writeImage(Widget widget, Image image) throws IOException {
        WidgetLCAUtil.writeImage(widget, "image", "icon", image);
    }

    public static void writeImage(Widget widget, String javaProperty, String jsProperty, Image image) throws IOException {
        if (WidgetLCAUtil.hasChanged(widget, javaProperty, image, null)) {
            WidgetLCAUtil.writeImage(widget, jsProperty, image);
        }
    }

    public static void writeImage(Widget widget, String jsProperty, Image image) throws IOException {
        String path = image == null ? null : ImageFactory.getImagePath(image);
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.set(jsProperty, path);
    }

    public static void writeFont(Widget widget, Font font) throws IOException {
        if (WidgetLCAUtil.hasChanged(widget, PROP_FONT, font, null)) {
            JSWriter writer = JSWriter.getWriterFor(widget);
            if (font != null) {
                FontData fontData = FontUtil.getData(font);
                String[] names = WidgetLCAUtil.parseFontName(fontData.getName());
                Object[] args = new Object[]{widget, names, new Integer(fontData.getHeight()), (fontData.getStyle() & 1) != 0, (fontData.getStyle() & 2) != 0};
                writer.call(JSWriter.WIDGET_MANAGER_REF, "setFont", args);
            } else {
                writer.reset(PROP_FONT);
            }
        }
    }

    public static void renderFont(Widget widget, Font font) throws IOException {
        if (WidgetLCAUtil.hasChanged(widget, PROP_FONT, font, null)) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.setProperty(PROP_FONT, WidgetLCAUtil.getFontAsArray(font));
        }
    }

    private static Object[] getFontAsArray(Font font) {
        Object[] result = null;
        if (font != null) {
            FontData fontData = FontUtil.getData(font);
            result = new Object[]{WidgetLCAUtil.parseFontName(fontData.getName()), fontData.getHeight(), (fontData.getStyle() & 1) != 0, (fontData.getStyle() & 2) != 0};
        }
        return result;
    }

    public static String[] parseFontName(final String name) {
        return parsedFonts.get(name, new SharedInstanceBuffer.IInstanceCreator<String[]>(){

            @Override
            public String[] createInstance() {
                return WidgetLCAUtil.parseFontNameInternal(name);
            }
        });
    }

    private static String[] parseFontNameInternal(String name) {
        String[] result = name.split(",");
        int i = 0;
        while (i < result.length) {
            result[i] = result[i].trim();
            Matcher matcher = FONT_NAME_FILTER_PATTERN.matcher(result[i]);
            result[i] = matcher.replaceAll("");
            ++i;
        }
        return result;
    }

    public static void writeForeground(Widget widget, Color newColor) throws IOException {
        if (WidgetLCAUtil.hasChanged(widget, PROP_FOREGROUND, newColor, null)) {
            JSWriter writer = JSWriter.getWriterFor(widget);
            if (newColor != null) {
                writer.set("textColor", newColor);
            } else {
                writer.reset("textColor");
            }
        }
    }

    public static void renderForeground(Widget widget, Color newColor) throws IOException {
        if (WidgetLCAUtil.hasChanged(widget, PROP_FOREGROUND, newColor, null)) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.setProperty(PROP_FOREGROUND, WidgetLCAUtil.getColorValueAsArray(newColor, false));
        }
    }

    private static String getColorValue(RGB rgb) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("#");
        String red = Integer.toHexString(rgb.red);
        if (red.length() == 1) {
            buffer.append("0");
        }
        buffer.append(red);
        String green = Integer.toHexString(rgb.green);
        if (green.length() == 1) {
            buffer.append("0");
        }
        buffer.append(green);
        String blue = Integer.toHexString(rgb.blue);
        if (blue.length() == 1) {
            buffer.append("0");
        }
        buffer.append(blue);
        return buffer.toString();
    }

    private static int[] getColorValueAsArray(Color color, boolean transparent) {
        int[] result = new int[4];
        RGB rgb = color == null ? new RGB(0, 0, 0) : color.getRGB();
        result[0] = rgb.red;
        result[1] = rgb.green;
        result[2] = rgb.blue;
        result[3] = transparent ? 0 : 255;
        return result;
    }

    public static void writeBackground(Widget widget, Color newColor) throws IOException {
        WidgetLCAUtil.writeBackground(widget, newColor, false);
    }

    public static void writeBackground(Widget widget, Color background, boolean transparency) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        boolean changed = WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND_TRANSPARENCY, transparency, Boolean.FALSE);
        if (!changed && !transparency) {
            changed = WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND, background, null);
        }
        if (changed) {
            if (transparency) {
                writer.set("backgroundGradient", (Object)null);
                writer.set("backgroundColor", (Object)null);
            } else if (background != null) {
                writer.set("backgroundGradient", (Object)null);
                writer.set("backgroundColor", background);
            } else {
                writer.reset("backgroundGradient");
                writer.reset("backgroundColor");
            }
        }
    }

    public static void renderBackground(Widget widget, Color newColor) throws IOException {
        WidgetLCAUtil.renderBackground(widget, newColor, false);
    }

    public static void renderBackground(Widget widget, Color background, boolean transparency) throws IOException {
        boolean transparencyChanged = WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND_TRANSPARENCY, transparency, Boolean.FALSE);
        boolean colorChanged = WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND, background, null);
        if (transparencyChanged || colorChanged) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            int[] color = null;
            if (transparency || background != null) {
                color = WidgetLCAUtil.getColorValueAsArray(background, transparency);
            }
            clientObject.setProperty(PROP_BACKGROUND, color);
        }
    }

    public static void writeBackgroundGradient(Widget widget) throws IOException {
        if (WidgetLCAUtil.hasBackgroundGradientChanged(widget)) {
            IWidgetGraphicsAdapter adapter;
            IWidgetGraphicsAdapter graphicsAdapter = adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
            Color[] bgGradientColors = graphicsAdapter.getBackgroundGradientColors();
            int[] bgGradientPercents = graphicsAdapter.getBackgroundGradientPercents();
            boolean bgGradientVertical = graphicsAdapter.isBackgroundGradientVertical();
            JSWriter writer = JSWriter.getWriterFor(widget);
            Integer[] percents = null;
            if (bgGradientPercents != null) {
                percents = new Integer[bgGradientPercents.length];
                int i = 0;
                while (i < bgGradientPercents.length) {
                    percents[i] = new Integer(bgGradientPercents[i]);
                    ++i;
                }
            }
            Object[] args = new Object[]{widget, bgGradientColors, percents, new Boolean(bgGradientVertical)};
            writer.call(JSWriter.WIDGET_MANAGER_REF, "setBackgroundGradient", args);
        }
    }

    public static void renderBackgroundGradient(Widget widget) throws IOException {
        if (WidgetLCAUtil.hasBackgroundGradientChanged(widget)) {
            IWidgetGraphicsAdapter adapter;
            IWidgetGraphicsAdapter graphicsAdapter = adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
            Color[] bgGradientColors = graphicsAdapter.getBackgroundGradientColors();
            Object[] args = null;
            if (bgGradientColors != null) {
                String[] colorStrings = new String[bgGradientColors.length];
                int[] bgGradientPercents = graphicsAdapter.getBackgroundGradientPercents();
                Integer[] percents = new Integer[bgGradientPercents.length];
                int i = 0;
                while (i < colorStrings.length) {
                    colorStrings[i] = WidgetLCAUtil.getColorValue(bgGradientColors[i].getRGB());
                    ++i;
                }
                i = 0;
                while (i < bgGradientPercents.length) {
                    percents[i] = new Integer(bgGradientPercents[i]);
                    ++i;
                }
                boolean bgGradientVertical = graphicsAdapter.isBackgroundGradientVertical();
                args = new Object[]{colorStrings, percents, new Boolean(bgGradientVertical)};
            }
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.setProperty("backgroundGradient", args);
        }
    }

    private static boolean hasBackgroundGradientChanged(Widget widget) {
        IWidgetGraphicsAdapter adapter;
        IWidgetGraphicsAdapter graphicsAdapter = adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
        Color[] bgGradientColors = graphicsAdapter.getBackgroundGradientColors();
        int[] bgGradientPercents = graphicsAdapter.getBackgroundGradientPercents();
        boolean bgGradientVertical = graphicsAdapter.isBackgroundGradientVertical();
        return WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND_GRADIENT_COLORS, bgGradientColors, null) || WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND_GRADIENT_PERCENTS, bgGradientPercents, null) || WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND_GRADIENT_VERTICAL, new Boolean(bgGradientVertical), Boolean.FALSE);
    }

    public static void writeRoundedBorder(Widget widget) throws IOException {
        if (WidgetLCAUtil.hasRoundedBorderChanged(widget)) {
            IWidgetGraphicsAdapter adapter;
            IWidgetGraphicsAdapter graphicAdapter = adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
            int width = graphicAdapter.getRoundedBorderWidth();
            Rectangle radius = graphicAdapter.getRoundedBorderRadius();
            Color color = graphicAdapter.getRoundedBorderColor();
            Object[] args = new Object[]{widget, new Integer(width), color, new Integer(radius.x), new Integer(radius.y), new Integer(radius.width), new Integer(radius.height)};
            JSWriter writer = JSWriter.getWriterFor(widget);
            writer.call(JSWriter.WIDGET_MANAGER_REF, JS_FUNC_SET_ROUNDED_BORDER, args);
        }
    }

    public static void renderRoundedBorder(Widget widget) throws IOException {
        if (WidgetLCAUtil.hasRoundedBorderChanged(widget)) {
            IWidgetGraphicsAdapter adapter;
            IWidgetGraphicsAdapter graphicAdapter = adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
            Object[] args = null;
            int width = graphicAdapter.getRoundedBorderWidth();
            Color color = graphicAdapter.getRoundedBorderColor();
            if (width > 0 && color != null) {
                Rectangle radius = graphicAdapter.getRoundedBorderRadius();
                args = new Object[]{new Integer(width), WidgetLCAUtil.getColorValue(color.getRGB()), new Integer(radius.x), new Integer(radius.y), new Integer(radius.width), new Integer(radius.height)};
            }
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.setProperty("roundedBorder", args);
        }
    }

    private static boolean hasRoundedBorderChanged(Widget widget) {
        IWidgetGraphicsAdapter adapter;
        IWidgetGraphicsAdapter graphicsAdapter = adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
        int width = graphicsAdapter.getRoundedBorderWidth();
        Color color = graphicsAdapter.getRoundedBorderColor();
        Rectangle radius = graphicsAdapter.getRoundedBorderRadius();
        return WidgetLCAUtil.hasChanged(widget, PROP_ROUNDED_BORDER_WIDTH, new Integer(width), new Integer(0)) || WidgetLCAUtil.hasChanged(widget, PROP_ROUNDED_BORDER_COLOR, color, null) || WidgetLCAUtil.hasChanged(widget, PROP_ROUNDED_BORDER_RADIUS, radius, DEF_ROUNDED_BORDER_RADIUS);
    }

    public static void writeEnabled(Widget widget, boolean enabled) throws IOException {
        Boolean newValue = enabled;
        JSWriter writer = JSWriter.getWriterFor(widget);
        Boolean defValue = Boolean.TRUE;
        writer.set(PROP_ENABLED, PROP_ENABLED, newValue, defValue);
    }

    public static void renderEnabled(Widget widget, boolean enabled) throws IOException {
        Boolean defValue;
        Boolean newValue = enabled;
        if (WidgetLCAUtil.hasChanged(widget, PROP_ENABLED, newValue, defValue = Boolean.TRUE)) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.setProperty(PROP_ENABLED, newValue);
        }
    }

    public static String replaceNewLines(String input, String replacement) {
        return EncodingUtil.replaceNewLines(input, replacement);
    }

    public static void writeCustomVariant(Widget widget) throws IOException {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        String oldValue = (String)adapter.getPreserved(PROP_VARIANT);
        String newValue = WidgetUtil.getVariant(widget);
        if (WidgetLCAUtil.hasChanged(widget, PROP_VARIANT, newValue, null)) {
            JSWriter writer = JSWriter.getWriterFor(widget);
            Object[] args = new Object[]{"variant_" + oldValue};
            if (oldValue != null) {
                writer.call("removeState", args);
            }
            if (newValue != null) {
                args = new Object[]{"variant_" + newValue};
                writer.call("addState", args);
            }
        }
    }

    public static void renderCustomVariant(Widget widget) throws IOException {
        String newValue = WidgetUtil.getVariant(widget);
        if (WidgetLCAUtil.hasChanged(widget, PROP_VARIANT, newValue, null)) {
            String value = null;
            if (newValue != null) {
                value = "variant_" + newValue;
            }
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.setProperty("customVariant", value);
        }
    }

    public static void writeStyleFlag(Widget widget, int style, String styleName) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        if ((widget.getStyle() & style) != 0) {
            writer.call("addState", new Object[]{"rwt_" + styleName});
        }
    }

    public static void preserveHelpListener(Widget widget) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(PROP_HELP_LISTENER, HelpEvent.hasListener(widget));
    }

    public static void writeHelpListener(Widget widget) throws IOException {
        Boolean hasListener = HelpEvent.hasListener(widget);
        if (WidgetLCAUtil.hasChanged(widget, PROP_HELP_LISTENER, hasListener, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor(widget);
            Object[] args = new Object[]{widget, JS_EVENT_TYPE_HELP, hasListener};
            writer.call(JSWriter.WIDGET_MANAGER_REF, JS_FUNC_SET_HAS_LISTENER, args);
        }
    }

    public static void renderListenHelp(Widget widget) {
        Boolean hasListener = HelpEvent.hasListener(widget);
        if (WidgetLCAUtil.hasChanged(widget, PROP_HELP_LISTENER, hasListener, Boolean.FALSE)) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            if (hasListener.booleanValue()) {
                clientObject.addListener(JS_EVENT_TYPE_HELP);
            } else {
                clientObject.removeListener(JS_EVENT_TYPE_HELP);
            }
        }
    }

    public static void processHelp(Widget widget) {
        if (WidgetLCAUtil.wasEventSent(widget, "org.eclipse.swt.events.help")) {
            HelpEvent event = new HelpEvent(widget);
            event.processEvent();
        }
    }

    public static String[] getStyles(Widget widget) {
        String[] allowedStyles = RWTStylesUtil.getAllowedStylesForWidget(widget);
        return StylesUtil.filterStyles(widget, allowedStyles);
    }

    private static String readPropertyValue(String widgetId, String propertyName) {
        HttpServletRequest request = ContextProvider.getRequest();
        StringBuffer key = new StringBuffer();
        key.append(widgetId);
        key.append(".");
        key.append(propertyName);
        return request.getParameter(key.toString());
    }

    private static int readBoundsY(String widgetId, int defValue) {
        String value = WidgetLCAUtil.readPropertyValue(widgetId, PARAM_Y);
        return WidgetLCAUtil.readBoundsValue(value, defValue);
    }

    private static int readBoundsX(String widgetId, int defValue) {
        String value = WidgetLCAUtil.readPropertyValue(widgetId, PARAM_X);
        return WidgetLCAUtil.readBoundsValue(value, defValue);
    }

    private static int readBoundsWidth(String widgetId, int defValue) {
        String value = WidgetLCAUtil.readPropertyValue(widgetId, PARAM_WIDTH);
        return WidgetLCAUtil.readBoundsValue(value, defValue);
    }

    private static int readBoundsHeight(String widgetId, int defValue) {
        String value = WidgetLCAUtil.readPropertyValue(widgetId, PARAM_HEIGHT);
        return WidgetLCAUtil.readBoundsValue(value, defValue);
    }

    private static int readBoundsValue(String value, int current) {
        int result = value != null && !"null".equals(value) ? NumberFormatUtil.parseInt(value) : current;
        return result;
    }

    static boolean equals(Object object1, Object object2) {
        boolean result = object1 == object2 ? true : (object1 == null ? false : (object1 instanceof boolean[] && object2 instanceof boolean[] ? Arrays.equals((boolean[])object1, (boolean[])object2) : (object1 instanceof int[] && object2 instanceof int[] ? Arrays.equals((int[])object1, (int[])object2) : (object1 instanceof long[] && object2 instanceof long[] ? Arrays.equals((long[])object1, (long[])object2) : (object1 instanceof float[] && object2 instanceof float[] ? Arrays.equals((float[])object1, (float[])object2) : (object1 instanceof double[] && object2 instanceof double[] ? Arrays.equals((double[])object1, (double[])object2) : (object1 instanceof Object[] && object2 instanceof Object[] ? Arrays.equals((Object[])object1, (Object[])object2) : object1.equals(object2))))))));
        return result;
    }

    public static String escapeText(String text, boolean mnemonics) {
        boolean insertAmp = false;
        StringBuffer buffer = new StringBuffer();
        int textLength = text.length();
        int i = 0;
        while (i < textLength) {
            char ch = text.charAt(i);
            if (ch == '&') {
                if (!mnemonics || insertAmp) {
                    insertAmp = false;
                    buffer.append("&amp;");
                } else if (i + 1 < textLength && text.charAt(i + 1) == '&') {
                    insertAmp = true;
                }
            } else if (ch == '<') {
                buffer.append("&lt;");
            } else if (ch == '>') {
                buffer.append("&gt;");
            } else if (ch == '\"') {
                buffer.append("&quot;");
            } else if (EncodingUtil.isNonDisplayableChar(ch)) {
                buffer.append("&#");
                buffer.append((int)ch);
                buffer.append(";");
            } else {
                buffer.append(ch);
            }
            ++i;
        }
        return EncodingUtil.truncateAtZero(buffer.toString());
    }
}

