/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.rwt.internal.application.RWTFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Resource;

public final class Font
extends Resource {
    private final FontData internalFontData;

    private Font(FontData fontData) {
        super(null);
        this.internalFontData = Font.findFontData(fontData);
    }

    public Font(Device device, FontData fontData) {
        super(Font.checkDevice(device));
        if (fontData == null) {
            SWT.error(4);
        }
        this.internalFontData = Font.findFontData(fontData);
    }

    public Font(Device device, FontData[] fontData) {
        super(Font.checkDevice(device));
        if (fontData == null) {
            SWT.error(4);
        }
        if (fontData.length == 0) {
            SWT.error(5);
        }
        int i = 0;
        while (i < fontData.length) {
            if (fontData[i] == null) {
                SWT.error(5);
            }
            ++i;
        }
        this.internalFontData = Font.findFontData(fontData[0]);
    }

    public Font(Device device, String name, int height, int style) {
        super(Font.checkDevice(device));
        if (name == null) {
            SWT.error(4);
        }
        if (height < 0) {
            SWT.error(5);
        }
        FontData fontData = new FontData(name, height, style);
        this.internalFontData = Font.findFontData(fontData);
    }

    public FontData[] getFontData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        FontData fontData = new FontData(this.internalFontData.getName(), this.internalFontData.getHeight(), this.internalFontData.getStyle());
        return new FontData[]{fontData};
    }

    public boolean equals(Object object) {
        boolean result;
        if (object == this) {
            result = true;
        } else if (object instanceof Font) {
            Font font = (Font)object;
            result = font.internalFontData.equals(this.internalFontData);
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return this.internalFontData.hashCode() * 7;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Font {");
        buffer.append(this.internalFontData.getName());
        buffer.append(",");
        buffer.append(this.internalFontData.getHeight());
        buffer.append(",");
        int style = this.internalFontData.getStyle();
        String styleName = (style & 1) != 0 && (style & 2) != 0 ? "BOLD|ITALIC" : ((style & 1) != 0 ? "BOLD" : ((style & 2) != 0 ? "ITALIC" : "NORMAL"));
        buffer.append(styleName);
        buffer.append("}");
        return buffer.toString();
    }

    private static FontData findFontData(FontData fontData) {
        return RWTFactory.getFontDataFactory().findFontData(fontData);
    }
}

