/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.dnd.dragsourcekit;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.dnd.IDNDAdapter;
import org.eclipse.swt.internal.dnd.dragsourcekit.DNDLCAUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public final class DragSourceLCA
extends AbstractWidgetLCA {
    private static final String JSFUNC_REGISTER = "org.eclipse.rwt.DNDSupport.getInstance().registerDragSource";
    private static final String JSFUNC_DEREGISTER = "org.eclipse.rwt.DNDSupport.getInstance().deregisterDragSource";
    private static final String JSFUNC_SET_TRANSFER_TYPES = "org.eclipse.rwt.DNDSupport.getInstance().setDragSourceTransferTypes";
    private static final String JSFUNC_SET_OPERATION_OVERWRITE = "org.eclipse.rwt.DNDSupport.getInstance().setOperationOverwrite";
    private static final String JSFUNC_SET_FEEDBACK = "org.eclipse.rwt.DNDSupport.getInstance().setFeedback";
    private static final String JSFUNC_SET_DATATYPE = "org.eclipse.rwt.DNDSupport.getInstance().setDataType";
    private static final String JSFUNC_CANCEL = "org.eclipse.rwt.DNDSupport.getInstance().cancel";
    private static final Transfer[] DEFAULT_TRANSFER = new Transfer[0];
    private static final String PROP_CONTROL = "control";
    private static final String PROP_TRANSFER = "transfer";

    public void preserveValues(Widget widget) {
        DragSource dragSource = (DragSource)widget;
        IWidgetAdapter adapter = WidgetUtil.getAdapter(dragSource);
        adapter.preserve(PROP_CONTROL, dragSource.getControl());
        adapter.preserve(PROP_TRANSFER, dragSource.getTransfer());
    }

    public void readData(Widget widget) {
    }

    public void renderInitialization(Widget widget) throws IOException {
        DragSource dragSource = (DragSource)widget;
        JSWriter writer = JSWriter.getWriterFor(dragSource);
        String[] operations = DNDLCAUtil.convertOperations(dragSource.getStyle());
        Object[] args = new Object[]{dragSource.getControl(), operations};
        writer.callStatic(JSFUNC_REGISTER, args);
    }

    public void renderChanges(Widget widget) throws IOException {
        DragSource dragSource = (DragSource)widget;
        DragSourceLCA.writeTransfer(dragSource);
        this.writeDetail(dragSource);
        this.writeFeedback(dragSource);
        this.writeDataType(dragSource);
        DragSourceLCA.writeCancel(dragSource);
    }

    public void renderDispose(Widget widget) throws IOException {
        DragSource dragSource = (DragSource)widget;
        IWidgetAdapter adapter = WidgetUtil.getAdapter(dragSource);
        Control control = (Control)adapter.getPreserved(PROP_CONTROL);
        JSWriter writer = JSWriter.getWriterFor(dragSource);
        writer.callStatic(JSFUNC_DEREGISTER, new Object[]{control});
    }

    private static void writeTransfer(DragSource dragSource) throws IOException {
        Transfer[] newValue = dragSource.getTransfer();
        if (WidgetLCAUtil.hasChanged(dragSource, PROP_TRANSFER, newValue, DEFAULT_TRANSFER)) {
            JSWriter writer = JSWriter.getWriterFor(dragSource);
            Object[] args = new Object[]{dragSource.getControl(), DNDLCAUtil.convertTransferTypes(newValue)};
            writer.callStatic(JSFUNC_SET_TRANSFER_TYPES, args);
        }
    }

    private void writeDetail(DragSource dragSource) throws IOException {
        IDNDAdapter dndAdapter = dragSource.getAdapter(IDNDAdapter.class);
        if (dndAdapter.hasDetailChanged()) {
            JSWriter writer = JSWriter.getWriterFor(dragSource);
            Object[] args = new Object[]{dndAdapter.getDetailChangedControl(), DragSourceLCA.convertOperation(dndAdapter.getDetailChangedValue())};
            writer.callStatic(JSFUNC_SET_OPERATION_OVERWRITE, args);
        }
    }

    private void writeFeedback(DragSource dragSource) throws IOException {
        IDNDAdapter dndAdapter = dragSource.getAdapter(IDNDAdapter.class);
        if (dndAdapter.hasFeedbackChanged()) {
            JSWriter writer = JSWriter.getWriterFor(dragSource);
            int value = dndAdapter.getFeedbackChangedValue();
            Object[] args = new Object[]{dndAdapter.getFeedbackChangedControl(), DragSourceLCA.convertFeedback(value), new Integer(value)};
            writer.callStatic(JSFUNC_SET_FEEDBACK, args);
        }
    }

    private void writeDataType(DragSource dragSource) throws IOException {
        IDNDAdapter dndAdapter = dragSource.getAdapter(IDNDAdapter.class);
        if (dndAdapter.hasDataTypeChanged()) {
            JSWriter writer = JSWriter.getWriterFor(dragSource);
            TransferData value = dndAdapter.getDataTypeChangedValue();
            Object[] args = new Object[]{dndAdapter.getDataTypeChangedControl(), new Integer(value.type)};
            writer.callStatic(JSFUNC_SET_DATATYPE, args);
        }
    }

    private static void writeCancel(DragSource dragSource) throws IOException {
        IDNDAdapter dndAdapter = dragSource.getAdapter(IDNDAdapter.class);
        if (dndAdapter.isCanceled()) {
            JSWriter writer = JSWriter.getWriterFor(dragSource);
            writer.callStatic(JSFUNC_CANCEL, null);
        }
    }

    private static String convertOperation(int operation) {
        String result = "none";
        switch (operation) {
            case 1: {
                result = "copy";
                break;
            }
            case 2: {
                result = "move";
                break;
            }
            case 4: {
                result = "link";
            }
        }
        return result;
    }

    private static String[] convertFeedback(int feedback) {
        ArrayList<String> feedbackNames = new ArrayList<String>();
        if ((feedback & 0x10) != 0) {
            feedbackNames.add("expand");
        }
        if ((feedback & 4) != 0) {
            feedbackNames.add("after");
        }
        if ((feedback & 2) != 0) {
            feedbackNames.add("before");
        }
        if ((feedback & 8) != 0) {
            feedbackNames.add("scroll");
        }
        if ((feedback & 1) != 0) {
            feedbackNames.add("select");
        }
        return feedbackNames.toArray(new String[feedbackNames.size()]);
    }
}

