/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.internal.widgets.controldecoratorkit;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.ControlDecorator;
import org.eclipse.swt.widgets.Widget;

public class ControlDecoratorLCA
extends AbstractWidgetLCA {
    private static final String PROP_IMAGE = "image";
    private static final String PROP_VISIBLE = "visible";
    static final String PROP_TEXT = "text";
    static final String PROP_SHOW_HOVER = "showHover";
    static final String PROP_SELECTION_LISTENERS = "selectionListeners";

    public void preserveValues(Widget widget) {
        ControlDecorator decorator = (ControlDecorator)widget;
        WidgetLCAUtil.preserveBounds(decorator, decorator.getBounds());
        IWidgetAdapter adapter = WidgetUtil.getAdapter(decorator);
        adapter.preserve(PROP_IMAGE, decorator.getImage());
        adapter.preserve(PROP_TEXT, decorator.getText());
        Boolean showHover = decorator.getShowHover();
        adapter.preserve(PROP_SHOW_HOVER, showHover);
        adapter.preserve(PROP_VISIBLE, decorator.isVisible());
        Boolean hasListener = SelectionEvent.hasListener(decorator);
        adapter.preserve(PROP_SELECTION_LISTENERS, hasListener);
    }

    public void readData(Widget widget) {
        ControlDecoratorLCA.readSelectionEvent((ControlDecorator)widget);
    }

    public void renderInitialization(Widget widget) throws IOException {
        ControlDecorator decorator = (ControlDecorator)widget;
        JSWriter writer = JSWriter.getWriterFor(decorator);
        Object[] args = new Object[]{decorator.getParent()};
        writer.newWidget("org.eclipse.rwt.widgets.ControlDecorator", args);
    }

    public void renderChanges(Widget widget) throws IOException {
        ControlDecorator decorator = (ControlDecorator)widget;
        WidgetLCAUtil.writeBounds(decorator, decorator.getParent(), decorator.getBounds());
        WidgetLCAUtil.writeImage(decorator, PROP_IMAGE, "source", decorator.getImage());
        ControlDecoratorLCA.writeText(decorator);
        ControlDecoratorLCA.writeShowHover(decorator);
        ControlDecoratorLCA.writeVisible(decorator);
        ControlDecoratorLCA.writeSelectionListener(decorator);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    private static void writeText(ControlDecorator decorator) throws IOException {
        String newValue = decorator.getText();
        JSWriter writer = JSWriter.getWriterFor(decorator);
        writer.set(PROP_TEXT, PROP_TEXT, newValue, "");
    }

    private static void writeShowHover(ControlDecorator decorator) throws IOException {
        Boolean newValue = decorator.getShowHover();
        JSWriter writer = JSWriter.getWriterFor(decorator);
        writer.set(PROP_SHOW_HOVER, PROP_SHOW_HOVER, newValue, Boolean.TRUE);
    }

    private static void writeVisible(ControlDecorator decorator) throws IOException {
        Boolean newValue = decorator.isVisible();
        Boolean defValue = Boolean.TRUE;
        JSWriter writer = JSWriter.getWriterFor(decorator);
        writer.set(PROP_VISIBLE, "visibility", newValue, defValue);
    }

    private static void writeSelectionListener(ControlDecorator decorator) throws IOException {
        Boolean newValue = SelectionEvent.hasListener(decorator);
        JSWriter writer = JSWriter.getWriterFor(decorator);
        writer.set(PROP_SELECTION_LISTENERS, "hasSelectionListener", newValue, Boolean.FALSE);
    }

    private static void readSelectionEvent(ControlDecorator decorator) {
        String eventName = "org.eclipse.swt.events.widgetSelected";
        int eventId = 13;
        if (WidgetLCAUtil.wasEventSent(decorator, eventName)) {
            ControlDecoratorLCA.processSelectionEvent(decorator, eventId);
        }
        eventName = "org.eclipse.swt.events.widgetDefaultSelected";
        eventId = 14;
        if (WidgetLCAUtil.wasEventSent(decorator, eventName)) {
            ControlDecoratorLCA.processSelectionEvent(decorator, eventId);
        }
    }

    private static void processSelectionEvent(ControlDecorator decorator, int id) {
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        int stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
        SelectionEvent event = new SelectionEvent(decorator, null, id, bounds, stateMask, "", true, 0);
        event.processEvent();
    }
}

