/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.menuitemkit;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.ImageFactory;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

final class MenuItemLCAUtil {
    static final String PROP_ENABLED = "enabled";
    static final String PROP_SELECTION_LISTENERS = "selectionListeners";
    static final String PROP_SELECTION = "selection";
    static final String JS_PROP_SELECTION = "selection";

    MenuItemLCAUtil() {
    }

    static void newItem(MenuItem menuItem, String jsClass, String type) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(menuItem);
        writer.newWidget(jsClass, new String[]{type});
        int index = menuItem.getParent().indexOf(menuItem);
        writer.call(menuItem.getParent(), "addMenuItemAt", new Object[]{menuItem, new Integer(index)});
    }

    static void preserveEnabled(MenuItem menuItem) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(menuItem);
        adapter.preserve(PROP_ENABLED, menuItem.getEnabled());
    }

    static void writeEnabled(MenuItem menuItem) throws IOException {
        Boolean newValue = menuItem.getEnabled();
        JSWriter writer = JSWriter.getWriterFor(menuItem);
        writer.set(PROP_ENABLED, PROP_ENABLED, newValue, Boolean.TRUE);
    }

    static void writeImageAndText(MenuItem menuItem) throws IOException {
        String text = menuItem.getText();
        if (WidgetLCAUtil.hasChanged(menuItem, "text", text)) {
            JSWriter writer = JSWriter.getWriterFor(menuItem);
            int index = text.indexOf("\t");
            if (index != -1) {
                text = text.substring(0, index);
            }
            writer.set("text", (text = WidgetLCAUtil.escapeText(text, true)).equals("") ? null : text);
        }
        MenuItemLCAUtil.writeImage(menuItem);
    }

    static void writeImage(MenuItem item) throws IOException {
        Image image = item.getImage();
        if (WidgetLCAUtil.hasChanged(item, "image", image, null)) {
            String imagePath = ImageFactory.getImagePath(image);
            JSWriter writer = JSWriter.getWriterFor(item);
            Rectangle bounds = image != null ? image.getBounds() : null;
            Object[] args = new Object[]{imagePath, new Integer(bounds != null ? bounds.width : 0), new Integer(bounds != null ? bounds.height : 0)};
            writer.set("image", args);
        }
    }

    static void writeSelectionListener(MenuItem menuItem) throws IOException {
        boolean hasListener = SelectionEvent.hasListener(menuItem);
        Boolean newValue = hasListener;
        JSWriter writer = JSWriter.getWriterFor(menuItem);
        writer.set(PROP_SELECTION_LISTENERS, "hasSelectionListener", newValue, Boolean.FALSE);
    }

    static void writeSelection(MenuItem menuItem) throws IOException {
        Boolean newValue = menuItem.getSelection();
        JSWriter writer = JSWriter.getWriterFor(menuItem);
        writer.set("selection", "selection", newValue, Boolean.FALSE);
    }

    static void processArmEvent(MenuItem menuItem) {
        String eventId;
        Menu menu = menuItem.getParent();
        if (WidgetLCAUtil.wasEventSent(menu, eventId = "org.eclipse.swt.events.menuShown") && ArmEvent.hasListener(menuItem)) {
            ArmEvent event = new ArmEvent(menuItem);
            event.processEvent();
        }
    }
}

