/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.menuitemkit;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.internal.events.DeselectionEvent;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.internal.widgets.menuitemkit.MenuItemDelegateLCA;
import org.eclipse.swt.internal.widgets.menuitemkit.MenuItemLCAUtil;
import org.eclipse.swt.widgets.MenuItem;

final class RadioMenuItemLCA
extends MenuItemDelegateLCA {
    private static final String ITEM_TYPE_RADIO = "radio";

    RadioMenuItemLCA() {
    }

    void preserveValues(MenuItem menuItem) {
        ItemLCAUtil.preserve(menuItem);
        IWidgetAdapter adapter = WidgetUtil.getAdapter(menuItem);
        boolean hasListener = SelectionEvent.hasListener(menuItem);
        adapter.preserve("selectionListeners", hasListener);
        adapter.preserve("selection", menuItem.getSelection());
        MenuItemLCAUtil.preserveEnabled(menuItem);
        WidgetLCAUtil.preserveCustomVariant(menuItem);
        WidgetLCAUtil.preserveHelpListener(menuItem);
    }

    void readData(MenuItem menuItem) {
        if (this.readSelection(menuItem)) {
            RadioMenuItemLCA.processSelectionEvent(menuItem);
        }
        ControlLCAUtil.processSelection(menuItem, null, false);
        WidgetLCAUtil.processHelp(menuItem);
        MenuItemLCAUtil.processArmEvent(menuItem);
    }

    void renderInitialization(MenuItem menuItem) throws IOException {
        MenuItemLCAUtil.newItem(menuItem, "org.eclipse.rwt.widgets.MenuItem", ITEM_TYPE_RADIO);
        if ((menuItem.getParent().getStyle() & 0x400000) != 0) {
            JSWriter writer = JSWriter.getWriterFor(menuItem);
            writer.set("noRadioGroup", true);
        }
    }

    void renderChanges(MenuItem menuItem) throws IOException {
        MenuItemLCAUtil.writeImageAndText(menuItem);
        MenuItemLCAUtil.writeSelectionListener(menuItem);
        MenuItemLCAUtil.writeSelection(menuItem);
        MenuItemLCAUtil.writeEnabled(menuItem);
        WidgetLCAUtil.writeCustomVariant(menuItem);
        WidgetLCAUtil.writeHelpListener(menuItem);
    }

    private boolean readSelection(MenuItem item) {
        String value = WidgetLCAUtil.readPropertyValue(item, "selection");
        if (value != null) {
            item.setSelection(Boolean.valueOf(value));
        }
        return value != null;
    }

    private static void processSelectionEvent(MenuItem item) {
        if (SelectionEvent.hasListener(item)) {
            int type = 13;
            SelectionEvent event = item.getSelection() ? new SelectionEvent(item, null, type) : new DeselectionEvent(item, null, type);
            event.stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
            event.processEvent();
        }
    }
}

