/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.menukit;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.IShellAdapter;
import org.eclipse.swt.internal.widgets.menukit.MenuDelegateLCA;
import org.eclipse.swt.internal.widgets.menukit.MenuLCAUtil;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;

final class MenuBarLCA
extends MenuDelegateLCA {
    static final String PROP_SHELL = "menuBarShell";
    private static final String PROP_SHELL_MENU = "menuBar";
    private static final String PROP_SHELL_MENU_BOUNDS = "menuBarShellClientArea";

    MenuBarLCA() {
    }

    void preserveValues(Menu menu) {
        Decorations parent = MenuBarLCA.getParent(menu);
        IWidgetAdapter adapter = WidgetUtil.getAdapter(menu);
        adapter.preserve(PROP_SHELL, parent);
        MenuLCAUtil.preserveEnabled(menu);
        MenuLCAUtil.preserveMenuListener(menu);
        WidgetLCAUtil.preserveCustomVariant(menu);
        WidgetLCAUtil.preserveHelpListener(menu);
    }

    void readData(Menu menu) {
        MenuLCAUtil.readMenuEvent(menu);
        WidgetLCAUtil.processHelp(menu);
    }

    void renderInitialization(Menu menu) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(menu);
        writer.newWidget("org.eclipse.rwt.widgets.MenuBar");
    }

    void renderChanges(Menu menu) throws IOException {
        MenuBarLCA.writeParent(menu);
        MenuBarLCA.writeBounds(menu);
        MenuLCAUtil.writeEnabled(menu);
        MenuLCAUtil.writeMenuListener(menu);
        MenuLCAUtil.writeUnhideMenu(menu);
        WidgetLCAUtil.writeCustomVariant(menu);
        WidgetLCAUtil.writeHelpListener(menu);
    }

    private static Decorations getParent(Menu menu) {
        Decorations result = null;
        if (menu.getParent().getMenuBar() == menu) {
            result = menu.getParent();
        }
        return result;
    }

    private static void writeParent(Menu menu) throws IOException {
        Decorations parent = MenuBarLCA.getParent(menu);
        if (WidgetLCAUtil.hasChanged(menu, PROP_SHELL, parent, null)) {
            JSWriter writer = JSWriter.getWriterFor(menu);
            writer.set("parent", parent);
        }
    }

    private static void writeBounds(Menu menu) throws IOException {
        IShellAdapter shellAdapter;
        Rectangle menuBounds;
        String prop;
        JSWriter writer = JSWriter.getWriterFor(menu);
        Decorations parent = MenuBarLCA.getParent(menu);
        if (parent != null && (WidgetLCAUtil.hasChanged(parent, prop = PROP_SHELL_MENU_BOUNDS, menuBounds = (shellAdapter = parent.getAdapter(IShellAdapter.class)).getMenuBounds(), null) || WidgetLCAUtil.hasChanged(parent, PROP_SHELL_MENU, menu, null))) {
            Object[] args = new Object[]{new Integer(menuBounds.x), new Integer(menuBounds.width), new Integer(menuBounds.y), new Integer(menuBounds.height)};
            writer.set("space", args);
        }
    }
}

