/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tableitemkit;

import java.io.IOException;
import org.eclipse.rwt.internal.util.EncodingUtil;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.graphics.FontUtil;
import org.eclipse.swt.internal.graphics.ImageFactory;
import org.eclipse.swt.internal.widgets.ITableAdapter;
import org.eclipse.swt.internal.widgets.ITableItemAdapter;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.internal.widgets.RichTextParser;
import org.eclipse.swt.internal.widgets.RichTextToHtmlTransformer;
import org.eclipse.swt.internal.widgets.WidgetAdapter;
import org.eclipse.swt.internal.widgets.tablekit.TableLCAUtil;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public final class TableItemLCA
extends AbstractWidgetLCA {
    static final String PROP_TEXTS = "texts";
    static final String PROP_IMAGES = "images";
    static final String PROP_CHECKED = "checked";
    static final String PROP_GRAYED = "grayed";
    static final String PROP_INDEX = "index";
    static final String PROP_SELECTED = "selected";
    static final String PROP_BACKGROUND = "background";
    static final String PROP_FOREGROUND = "foreground";
    static final String PROP_FONT = "font";
    static final String PROP_CELL_BACKGROUNDS = "cellBackgrounds";
    static final String PROP_CELL_FOREGROUNDS = "cellForegrounds";
    static final String PROP_CELL_FONTS = "cellFonts";
    static final String PROP_CACHED = "cached";
    static final String PROP_VARIANT = "variant";

    public void preserveValues(Widget widget) {
        TableItem item = (TableItem)widget;
        Table table = item.getParent();
        int index = item.getParent().indexOf(item);
        IWidgetAdapter adapter = WidgetUtil.getAdapter(item);
        if (TableItemLCA.isCached(table, index)) {
            ITableItemAdapter itemAdapter;
            ItemLCAUtil.preserve(item);
            if ((table.getStyle() & 0x20) != 0) {
                adapter.preserve(PROP_CHECKED, item.getChecked());
                adapter.preserve(PROP_GRAYED, item.getGrayed());
            }
            adapter.preserve(PROP_TEXTS, TableItemLCA.getTexts(item));
            adapter.preserve(PROP_IMAGES, TableItemLCA.getImages(item));
            adapter.preserve(PROP_INDEX, new Integer(index));
            adapter.preserve(PROP_SELECTED, TableItemLCA.isSelected(table, index));
            ITableItemAdapter tableItemAdapter = itemAdapter = item.getAdapter(ITableItemAdapter.class);
            adapter.preserve(PROP_BACKGROUND, tableItemAdapter.getUserBackground());
            adapter.preserve(PROP_FOREGROUND, tableItemAdapter.getUserForeground());
            adapter.preserve(PROP_FONT, tableItemAdapter.getUserFont());
            adapter.preserve(PROP_CELL_BACKGROUNDS, tableItemAdapter.getCellBackgrounds());
            adapter.preserve(PROP_CELL_FOREGROUNDS, tableItemAdapter.getCellForegrounds());
            adapter.preserve(PROP_CELL_FONTS, tableItemAdapter.getCellFonts());
            adapter.preserve(PROP_VARIANT, WidgetUtil.getVariant(widget));
        }
        adapter.preserve(PROP_CACHED, TableItemLCA.isCached(table, index));
    }

    public void readData(Widget widget) {
        TableItem item = (TableItem)widget;
        this.readChecked(item);
    }

    public void renderInitialization(Widget widget) throws IOException {
        TableItem tableItem = (TableItem)widget;
        JSWriter writer = JSWriter.getWriterFor(widget);
        Table parent = tableItem.getParent();
        Integer index = new Integer(tableItem.getParent().indexOf(tableItem));
        Object[] args = new Object[]{parent, index, WidgetUtil.getId(widget)};
        writer.callStatic("org.eclipse.rwt.widgets.TreeItem.createItem", args);
    }

    public void renderChanges(Widget widget) throws IOException {
        final TableItem item = (TableItem)widget;
        if (TableItemLCA.wasCleared(item)) {
            TableItemLCA.writeClear(item);
            TableItemLCA.writeSelection(item);
        } else {
            Table table = item.getParent();
            if (TableItemLCA.isCached(table, table.indexOf(item))) {
                TableItemLCA.preservingInitialized(item, new IRenderRunnable(){

                    public void run() throws IOException {
                        if (!TableItemLCA.wasCached(item)) {
                            TableItemLCA.setInitialized(item, false);
                        }
                        TableItemLCA.writeChanges(item);
                    }
                });
            }
        }
    }

    public void renderDispose(Widget widget) throws IOException {
        TableItem item = (TableItem)widget;
        if (!this.isParentDisposed(item)) {
            JSWriter writer = JSWriter.getWriterFor(item);
            writer.call("dispose", null);
        }
    }

    private void readChecked(TableItem item) {
        String value = WidgetLCAUtil.readPropertyValue(item, PROP_CHECKED);
        if (value != null) {
            item.setChecked(Boolean.valueOf(value));
        }
    }

    private static void writeChanges(TableItem item) throws IOException {
        TableItemLCA.writeTexts(item);
        TableItemLCA.writeImages(item);
        TableItemLCA.writeBackground(item);
        TableItemLCA.writeForeground(item);
        TableItemLCA.writeFont(item);
        TableItemLCA.writeCellBackgrounds(item);
        TableItemLCA.writeCellForegrounds(item);
        TableItemLCA.writeCellFonts(item);
        TableItemLCA.writeChecked(item);
        TableItemLCA.writeGrayed(item);
        TableItemLCA.writeSelection(item);
        TableItemLCA.writeVariant(item);
        if (TableItemLCA.isVisible(item)) {
            Table table = item.getParent();
            TableLCAUtil.hasAlignmentChanged(table);
            TableItemLCA.hasIndexChanged(item);
        }
        TableItemLCA.writeFocused(item);
    }

    private static void writeClear(TableItem item) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(item);
        writer.call("clear", null);
    }

    private static boolean writeTexts(TableItem item) throws IOException {
        String[] texts = TableItemLCA.getTexts(item);
        boolean result = WidgetLCAUtil.hasChanged(item, PROP_TEXTS, texts);
        if (result) {
            TableItemLCA.transformTexts(item, texts);
            JSWriter writer = JSWriter.getWriterFor(item);
            writer.set(PROP_TEXTS, new Object[]{texts});
        }
        return result;
    }

    private static void transformTexts(TableItem item, String[] texts) {
        int i = 0;
        while (i < texts.length) {
            if (TableItemLCA.isRichTextEnabled(item) && RichTextParser.isRichText(texts[i])) {
                RichTextToHtmlTransformer transformer = new RichTextToHtmlTransformer(item);
                RichTextParser richTextParser = new RichTextParser(transformer);
                richTextParser.parse(texts[i]);
                texts[i] = transformer.getHtml();
            } else {
                texts[i] = WidgetLCAUtil.escapeText(item.getText(i), false);
                texts[i] = EncodingUtil.replaceWhiteSpaces(texts[i]);
            }
            ++i;
        }
    }

    private static boolean writeImages(TableItem item) throws IOException {
        Image[] defValue;
        Image[] images = TableItemLCA.getImages(item);
        boolean result = WidgetLCAUtil.hasChanged(item, PROP_IMAGES, images, defValue = new Image[images.length]);
        if (result) {
            JSWriter writer = JSWriter.getWriterFor(item);
            String[] imagePaths = new String[images.length];
            int i = 0;
            while (i < imagePaths.length) {
                imagePaths[i] = ImageFactory.getImagePath(images[i]);
                ++i;
            }
            writer.set(PROP_IMAGES, new Object[]{imagePaths});
        }
        return result;
    }

    private static boolean writeBackground(TableItem item) throws IOException {
        ITableItemAdapter adapter = item.getAdapter(ITableItemAdapter.class);
        Color background = adapter.getUserBackground();
        JSWriter writer = JSWriter.getWriterFor(item);
        return writer.set(PROP_BACKGROUND, PROP_BACKGROUND, background, null);
    }

    private static boolean writeForeground(TableItem item) throws IOException {
        ITableItemAdapter adapter;
        ITableItemAdapter tableItemAdapter = adapter = item.getAdapter(ITableItemAdapter.class);
        Color foreground = tableItemAdapter.getUserForeground();
        JSWriter writer = JSWriter.getWriterFor(item);
        return writer.set(PROP_FOREGROUND, PROP_FOREGROUND, foreground, null);
    }

    private static boolean writeFont(TableItem item) throws IOException {
        ITableItemAdapter adapter = item.getAdapter(ITableItemAdapter.class);
        ITableItemAdapter tableItemAdapter = adapter;
        Font font = tableItemAdapter.getUserFont();
        boolean result = WidgetLCAUtil.hasChanged(item, PROP_FONT, font, null);
        if (result) {
            JSWriter writer = JSWriter.getWriterFor(item);
            String fontCss = font != null ? TableItemLCA.toCss(font) : null;
            writer.set(PROP_FONT, fontCss);
        }
        return result;
    }

    private static boolean writeCellBackgrounds(TableItem item) throws IOException {
        ITableItemAdapter adapter = item.getAdapter(ITableItemAdapter.class);
        Color[] backgrounds = adapter.getCellBackgrounds();
        Color[] defValue = new Color[TableItemLCA.getColumnCount(item)];
        JSWriter writer = JSWriter.getWriterFor(item);
        return writer.set(PROP_CELL_BACKGROUNDS, PROP_CELL_BACKGROUNDS, backgrounds, defValue);
    }

    private static boolean writeCellForegrounds(TableItem item) throws IOException {
        ITableItemAdapter adapter = item.getAdapter(ITableItemAdapter.class);
        Color[] foregrounds = adapter.getCellForegrounds();
        Color[] defValue = new Color[TableItemLCA.getColumnCount(item)];
        JSWriter writer = JSWriter.getWriterFor(item);
        return writer.set(PROP_CELL_FOREGROUNDS, PROP_CELL_FOREGROUNDS, foregrounds, defValue);
    }

    private static boolean writeCellFonts(TableItem item) throws IOException {
        Font[] defValue;
        ITableItemAdapter adapter = item.getAdapter(ITableItemAdapter.class);
        ITableItemAdapter tableItemAdapter = adapter;
        Font[] fonts = tableItemAdapter.getCellFonts();
        boolean result = WidgetLCAUtil.hasChanged(item, PROP_CELL_FONTS, fonts, defValue = new Font[fonts.length]);
        if (result) {
            String[] css = new String[fonts.length];
            int i = 0;
            while (i < fonts.length) {
                css[i] = fonts[i] != null ? TableItemLCA.toCss(fonts[i]) : null;
                ++i;
            }
            JSWriter writer = JSWriter.getWriterFor(item);
            writer.set(PROP_CELL_FONTS, new Object[]{css});
        }
        return result;
    }

    private static boolean writeChecked(TableItem item) throws IOException {
        boolean result;
        if ((item.getParent().getStyle() & 0x20) != 0) {
            JSWriter writer = JSWriter.getWriterFor(item);
            Boolean newValue = item.getChecked();
            result = writer.set(PROP_CHECKED, PROP_CHECKED, newValue, Boolean.FALSE);
        } else {
            result = false;
        }
        return result;
    }

    private static boolean writeGrayed(TableItem item) throws IOException {
        boolean result;
        if ((item.getParent().getStyle() & 0x20) != 0) {
            JSWriter writer = JSWriter.getWriterFor(item);
            Boolean newValue = item.getGrayed();
            result = writer.set(PROP_GRAYED, PROP_GRAYED, newValue, Boolean.FALSE);
        } else {
            result = false;
        }
        return result;
    }

    private static boolean writeSelection(TableItem item) throws IOException {
        Boolean defValue;
        Boolean newValue = TableItemLCA.isSelected(item);
        boolean result = WidgetLCAUtil.hasChanged(item, PROP_SELECTED, newValue, defValue = Boolean.FALSE);
        if (result) {
            JSWriter writer = JSWriter.getWriterFor(item.getParent());
            String jsFunction = TableItemLCA.isSelected(item) ? "selectItem" : "deselectItem";
            writer.call(jsFunction, new Object[]{item});
        }
        return result;
    }

    private static void writeFocused(TableItem item) throws IOException {
        if (TableLCAUtil.hasFocusIndexChanged(item.getParent()) && TableItemLCA.isFocused(item)) {
            JSWriter writer = JSWriter.getWriterFor(item.getParent());
            writer.set("focusItem", new Object[]{item});
        }
    }

    private static boolean writeVariant(TableItem item) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(item);
        String variant = WidgetUtil.getVariant(item);
        boolean result = WidgetLCAUtil.hasChanged(item, PROP_VARIANT, variant, null);
        if (result) {
            Object[] args = new Object[]{"variant_" + variant};
            writer.set(PROP_VARIANT, args);
        }
        return result;
    }

    private static String toCss(Font font) {
        StringBuffer result = new StringBuffer();
        FontData fontData = FontUtil.getData(font);
        if ((fontData.getStyle() & 2) != 0) {
            result.append("italic ");
        }
        if ((fontData.getStyle() & 1) != 0) {
            result.append("bold ");
        }
        result.append(fontData.getHeight());
        result.append("px ");
        String escapedName = fontData.getName().replaceAll("\"", "");
        result.append(escapedName);
        return result.toString();
    }

    private static boolean hasIndexChanged(TableItem item) {
        int index = item.getParent().indexOf(item);
        return WidgetLCAUtil.hasChanged(item, PROP_INDEX, new Integer(index));
    }

    static String[] getTexts(TableItem item) {
        int columnCount = TableItemLCA.getColumnCount(item);
        String[] result = new String[columnCount];
        int i = 0;
        while (i < columnCount) {
            result[i] = item.getText(i);
            ++i;
        }
        return result;
    }

    static Image[] getImages(TableItem item) {
        int columnCount = TableItemLCA.getColumnCount(item);
        Image[] result = new Image[columnCount];
        int i = 0;
        while (i < columnCount) {
            result[i] = item.getImage(i);
            ++i;
        }
        return result;
    }

    private static int getColumnCount(TableItem item) {
        return Math.max(1, item.getParent().getColumnCount());
    }

    private static boolean isSelected(TableItem item) {
        Table table = item.getParent();
        int index = table.indexOf(item);
        return TableItemLCA.isSelected(table, index);
    }

    private static boolean isSelected(Table table, int itemIndex) {
        return itemIndex != -1 && table.isSelected(itemIndex);
    }

    private static boolean isFocused(TableItem item) {
        int focusIndex = TableItemLCA.getTableAdapter(item).getFocusIndex();
        return focusIndex != -1 && item == item.getParent().getItem(focusIndex);
    }

    private static boolean isVisible(TableItem item) {
        return TableItemLCA.getTableAdapter(item).isItemVisible(item);
    }

    private static boolean wasCleared(TableItem item) {
        Table table = item.getParent();
        boolean cached = TableItemLCA.isCached(table, table.indexOf(item));
        boolean wasCached = TableItemLCA.wasCached(item);
        return !cached && wasCached;
    }

    private static boolean isCached(Table table, int index) {
        ITableAdapter adapter = table.getAdapter(ITableAdapter.class);
        return !adapter.isItemVirtual(index);
    }

    private static boolean wasCached(TableItem item) {
        boolean wasCached;
        IWidgetAdapter adapter = WidgetUtil.getAdapter(item);
        if (adapter.isInitialized()) {
            Boolean preserved = (Boolean)adapter.getPreserved(PROP_CACHED);
            wasCached = Boolean.TRUE.equals(preserved);
        } else {
            wasCached = true;
        }
        return wasCached;
    }

    private static ITableAdapter getTableAdapter(TableItem item) {
        return item.getParent().getAdapter(ITableAdapter.class);
    }

    private static void preservingInitialized(TableItem item, IRenderRunnable runnable) throws IOException {
        boolean initialized = WidgetUtil.getAdapter(item).isInitialized();
        runnable.run();
        TableItemLCA.setInitialized(item, initialized);
    }

    private static void setInitialized(TableItem item, boolean initialized) {
        WidgetAdapter adapter = (WidgetAdapter)item.getAdapter(IWidgetAdapter.class);
        adapter.setInitialized(initialized);
    }

    private static boolean isRichTextEnabled(TableItem item) {
        ITableItemAdapter adapter = item.getAdapter(ITableItemAdapter.class);
        return adapter.isRichTextEnabled();
    }

    private boolean isParentDisposed(TableItem item) {
        ITableItemAdapter adapter = item.getAdapter(ITableItemAdapter.class);
        return adapter.isParentDisposed();
    }

    private static interface IRenderRunnable {
        public void run() throws IOException;
    }
}

