/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tablekit;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.ITableAdapter;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public final class TableLCAUtil {
    public static final String PROP_ALIGNMENT = "alignment";
    static final String PROP_ITEM_METRICS = "itemMetrics";
    static final String PROP_FOCUS_INDEX = "focusIndex";
    private static final Integer DEFAULT_ALIGNMENT = new Integer(16384);
    private static final Integer DEFAULT_FOCUS_INDEX = new Integer(-1);

    public static void preserveAlignment(TableColumn column) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(column);
        adapter.preserve(PROP_ALIGNMENT, new Integer(column.getAlignment()));
    }

    public static boolean hasAlignmentChanged(Table table) {
        boolean result = false;
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (!result && i < columns.length) {
            if (TableLCAUtil.hasAlignmentChanged(columns[i])) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public static boolean hasAlignmentChanged(TableColumn column) {
        return WidgetLCAUtil.hasChanged(column, PROP_ALIGNMENT, new Integer(column.getAlignment()), DEFAULT_ALIGNMENT);
    }

    public static void preserveItemMetrics(Table table) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(table);
        adapter.preserve(PROP_ITEM_METRICS, TableLCAUtil.getItemMetrics(table));
    }

    public static boolean hasItemMetricsChanged(Table table) {
        ItemMetrics[] itemMetrics = TableLCAUtil.getItemMetrics(table);
        return TableLCAUtil.hasItemMetricsChanged(table, itemMetrics);
    }

    public static void writeItemMetrics(Table table) throws IOException {
        ItemMetrics[] itemMetrics = TableLCAUtil.getItemMetrics(table);
        if (TableLCAUtil.hasItemMetricsChanged(table, itemMetrics)) {
            JSWriter writer = JSWriter.getWriterFor(table);
            int i = 0;
            while (i < itemMetrics.length) {
                Object[] args = new Object[]{new Integer(i), new Integer(itemMetrics[i].left), new Integer(itemMetrics[i].width), new Integer(itemMetrics[i].imageLeft), new Integer(itemMetrics[i].imageWidth), new Integer(itemMetrics[i].textLeft), new Integer(itemMetrics[i].textWidth)};
                writer.set(PROP_ITEM_METRICS, args);
                ++i;
            }
        }
    }

    public static void preserveFocusIndex(Table table) {
        ITableAdapter tableAdapter = table.getAdapter(ITableAdapter.class);
        int focusIndex = tableAdapter.getFocusIndex();
        IWidgetAdapter adapter = WidgetUtil.getAdapter(table);
        adapter.preserve(PROP_FOCUS_INDEX, new Integer(focusIndex));
    }

    public static boolean hasFocusIndexChanged(Table table) {
        ITableAdapter tableAdapter = table.getAdapter(ITableAdapter.class);
        Integer focusIndex = new Integer(tableAdapter.getFocusIndex());
        return WidgetLCAUtil.hasChanged(table, PROP_FOCUS_INDEX, focusIndex, DEFAULT_FOCUS_INDEX);
    }

    private static boolean hasItemMetricsChanged(Table table, ItemMetrics[] metrics) {
        return WidgetLCAUtil.hasChanged(table, PROP_ITEM_METRICS, metrics);
    }

    static ItemMetrics[] getItemMetrics(Table table) {
        ItemMetrics[] result;
        block6: {
            ITableAdapter tableAdapter;
            int columnCount;
            block5: {
                columnCount = Math.max(1, table.getColumnCount());
                result = new ItemMetrics[columnCount];
                int i = 0;
                while (i < columnCount) {
                    result[i] = new ItemMetrics();
                    ++i;
                }
                tableAdapter = table.getAdapter(ITableAdapter.class);
                TableItem measureItem = tableAdapter.getMeasureItem();
                if (measureItem == null) break block5;
                int i2 = 0;
                while (i2 < columnCount) {
                    int leftOffset = tableAdapter.getColumnLeftOffset(i2);
                    Rectangle bounds = measureItem.getBounds(i2);
                    Rectangle imageBounds = measureItem.getImageBounds(i2);
                    Rectangle textBounds = measureItem.getTextBounds(i2);
                    int imageWidth = tableAdapter.getItemImageWidth(i2);
                    if (table.getColumnCount() > 0) {
                        TableColumn column = table.getColumn(i2);
                        int columnLeft = tableAdapter.getColumnLeft(column);
                        int columnWidth = column.getWidth();
                        int maxImageWidth = columnWidth - (imageBounds.x - columnLeft + leftOffset);
                        if (imageWidth > maxImageWidth) {
                            imageWidth = Math.max(0, maxImageWidth);
                        }
                    }
                    result[i2].left = bounds.x + leftOffset;
                    result[i2].width = bounds.width;
                    result[i2].imageLeft = imageBounds.x + leftOffset;
                    result[i2].imageWidth = imageWidth;
                    result[i2].textLeft = textBounds.x + leftOffset;
                    result[i2].textWidth = textBounds.width;
                    ++i2;
                }
                break block6;
            }
            if (table.getColumnCount() <= 0) break block6;
            int i = 0;
            while (i < columnCount) {
                TableColumn column = table.getColumn(i);
                int columnLeft = tableAdapter.getColumnLeft(column);
                int columnWidth = column.getWidth();
                result[i].left = columnLeft;
                result[i].width = columnWidth;
                ++i;
            }
        }
        return result;
    }

    private TableLCAUtil() {
    }

    static final class ItemMetrics {
        int left;
        int width;
        int imageLeft;
        int imageWidth;
        int textLeft;
        int textWidth;

        ItemMetrics() {
        }

        public boolean equals(Object obj) {
            boolean result;
            if (obj == this) {
                result = true;
            } else if (obj instanceof ItemMetrics) {
                ItemMetrics other = (ItemMetrics)obj;
                result = other.left == this.left && other.width == this.width && other.imageLeft == this.imageLeft && other.imageWidth == this.imageWidth && other.textLeft == this.textLeft && other.textWidth == this.textWidth;
            } else {
                result = false;
            }
            return result;
        }

        public int hashCode() {
            String msg = "ItemMetrics#hashCode() not implemented";
            throw new UnsupportedOperationException(msg);
        }
    }
}

