/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.protocol;

import java.util.Map;
import org.eclipse.rwt.internal.protocol.IClientObject;
import org.eclipse.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rwt.internal.service.ContextProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClientObject
implements IClientObject {
    private final String targetId;

    public ClientObject(String targetId) {
        this.targetId = targetId;
    }

    @Override
    public void create(String type) {
        ClientObject.getWriter().appendCreate(this.targetId, type);
    }

    @Override
    public void destroy() {
        ClientObject.getWriter().appendDestroy(this.targetId);
    }

    @Override
    public void setProperty(String name, int value) {
        ClientObject.getWriter().appendSet(this.targetId, name, value);
    }

    @Override
    public void setProperty(String name, double value) {
        ClientObject.getWriter().appendSet(this.targetId, name, value);
    }

    @Override
    public void setProperty(String name, boolean value) {
        ClientObject.getWriter().appendSet(this.targetId, name, value);
    }

    @Override
    public void setProperty(String name, String value) {
        ClientObject.getWriter().appendSet(this.targetId, name, value);
    }

    public void setProperty(String name, int[] value) {
        ClientObject.getWriter().appendSet(this.targetId, name, value);
    }

    @Override
    public void setProperty(String name, Object value) {
        ClientObject.getWriter().appendSet(this.targetId, name, value);
    }

    @Override
    public void addListener(String eventName) {
        ClientObject.getWriter().appendListen(this.targetId, eventName, true);
    }

    @Override
    public void removeListener(String eventName) {
        ClientObject.getWriter().appendListen(this.targetId, eventName, false);
    }

    @Override
    public void call(String method, Map<String, Object> properties) {
        ClientObject.getWriter().appendCall(this.targetId, method, properties);
    }

    @Override
    public void executeScript(String type, String script) {
        ClientObject.getWriter().appendExecuteScript(this.targetId, type, script);
    }

    private static ProtocolMessageWriter getWriter() {
        return ContextProvider.getStateInfo().getResponseWriter().getProtocolWriter();
    }
}

