/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rwt.internal.application.ApplicationContext;
import org.eclipse.rwt.internal.application.ApplicationContextUtil;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.internal.service.SessionStoreImpl;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.service.ISessionStore;

public final class ServiceContext {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private IServiceStateInfo stateInfo;
    private boolean disposed;
    private ISessionStore sessionStore;
    private ApplicationContext applicationContext;

    public ServiceContext(HttpServletRequest request, HttpServletResponse response) {
        ParamCheck.notNull(request, "request");
        ParamCheck.notNull(response, "response");
        this.request = request;
        this.response = response;
    }

    public ServiceContext(HttpServletRequest request, HttpServletResponse response, ISessionStore sessionStore) {
        this(request, response);
        this.sessionStore = sessionStore;
    }

    public HttpServletRequest getRequest() {
        this.checkState();
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        this.checkState();
        return this.response;
    }

    public IServiceStateInfo getStateInfo() {
        this.checkState();
        return this.stateInfo;
    }

    public void setStateInfo(IServiceStateInfo stateInfo) {
        this.checkState();
        ParamCheck.notNull(stateInfo, "stateInfo");
        if (this.stateInfo != null) {
            String msg = "StateInfo is already set and must not be replaced.";
            throw new IllegalStateException(msg);
        }
        this.stateInfo = stateInfo;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public ISessionStore getSessionStore() {
        if (this.sessionStore != null && !((SessionStoreImpl)this.sessionStore).isBound()) {
            this.sessionStore = null;
        }
        return this.sessionStore;
    }

    public void setSessionStore(ISessionStore sessionStore) {
        this.sessionStore = sessionStore;
    }

    public void dispose() {
        this.checkState();
        this.request = null;
        this.response = null;
        this.stateInfo = null;
        this.sessionStore = null;
        this.applicationContext = null;
        this.disposed = true;
    }

    public ApplicationContext getApplicationContext() {
        this.checkState();
        if (!this.isApplicationContextBuffered()) {
            this.getApplicationContextFromSession();
            if (!this.isApplicationContextBuffered()) {
                this.getApplicationContextFromServletContext();
                this.bufferApplicationContextInSession();
            }
        }
        return this.applicationContext;
    }

    private boolean isApplicationContextBuffered() {
        return this.applicationContext != null;
    }

    private void bufferApplicationContextInSession() {
        if (this.sessionStore != null) {
            ApplicationContextUtil.set(this.sessionStore, this.applicationContext);
        }
    }

    private void getApplicationContextFromServletContext() {
        ServletContext servletContext = this.request.getSession().getServletContext();
        this.applicationContext = ApplicationContextUtil.get(servletContext);
    }

    private void getApplicationContextFromSession() {
        ApplicationContext fromSession;
        if (this.sessionStore != null && (fromSession = ApplicationContextUtil.get(this.sessionStore)) != null && fromSession.isActivated()) {
            this.applicationContext = fromSession;
        }
    }

    private void checkState() {
        if (this.disposed) {
            throw new IllegalStateException("The context has been disposed.");
        }
    }
}

