/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.rwt.internal.application.RWTFactory;
import org.eclipse.rwt.internal.lifecycle.LifeCycleAdapterUtil;
import org.eclipse.rwt.internal.resources.ResourceUtil;
import org.eclipse.rwt.internal.theme.AppearancesUtil;
import org.eclipse.rwt.internal.theme.IThemeCssElement;
import org.eclipse.rwt.internal.theme.QxCursor;
import org.eclipse.rwt.internal.theme.QxImage;
import org.eclipse.rwt.internal.theme.QxTheme;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.Theme;
import org.eclipse.rwt.internal.theme.ThemeAdapterManager;
import org.eclipse.rwt.internal.theme.ThemeDefinitionReader;
import org.eclipse.rwt.internal.theme.ThemeManagerException;
import org.eclipse.rwt.internal.theme.ThemePropertyAdapterRegistry;
import org.eclipse.rwt.internal.theme.ThemeStoreWriter;
import org.eclipse.rwt.internal.theme.ThemeableWidget;
import org.eclipse.rwt.internal.theme.ThemeableWidgetHolder;
import org.eclipse.rwt.internal.theme.css.CssElementHolder;
import org.eclipse.rwt.internal.theme.css.CssFileReader;
import org.eclipse.rwt.internal.theme.css.StyleSheet;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.internal.util.StreamUtil;
import org.eclipse.rwt.resources.IResourceManager;
import org.eclipse.rwt.resources.ResourceLoader;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class ThemeManager {
    public static final String DEFAULT_THEME_ID = "org.eclipse.rap.rwt.theme.Default";
    private static final String DEFAULT_THEME_NAME = "RAP Default Theme";
    public static ResourceLoader STANDARD_RESOURCE_LOADER = new ResourceLoader(){
        ClassLoader classLoader = this.getClass().getClassLoader();

        public InputStream getResourceAsStream(String resourceName) throws IOException {
            return this.classLoader.getResourceAsStream(resourceName);
        }
    };
    private static final String CHARSET = "UTF-8";
    private static final String LOG_SYSTEM_PROPERTY = System.getProperty(String.valueOf(ThemeManager.class.getName()) + ".log");
    private static final boolean DEBUG = "true".equals(LOG_SYSTEM_PROPERTY);
    private static final String CLIENT_LIBRARY_VARIANT = "org.eclipse.rwt.clientLibraryVariant";
    private static final String DEBUG_CLIENT_LIBRARY_VARIANT = "DEBUG";
    private static final String WIDGET_THEME_PATH = "resource/widget/rap";
    static final String IMAGE_DEST_PATH = "themes/images";
    private static final String CURSOR_DEST_PATH = "themes/cursors";
    private static final Class[] THEMEABLE_WIDGETS = new Class[]{Widget.class, Control.class, Composite.class, Button.class, Combo.class, CoolBar.class, CTabFolder.class, Group.class, Label.class, Link.class, List.class, Menu.class, ProgressBar.class, Shell.class, Spinner.class, TabFolder.class, Table.class, Text.class, ToolBar.class, Tree.class, Scale.class, DateTime.class, ExpandBar.class, Sash.class, Slider.class, ToolTip.class, CCombo.class, CLabel.class, Browser.class, ScrolledComposite.class, ScrollBar.class};
    private final Set<String> customAppearances;
    private final Map<String, Theme> themes;
    private final Set<String> registeredThemeFiles;
    private final ThemeableWidgetHolder themeableWidgets = new ThemeableWidgetHolder();
    private final CssElementHolder registeredCssElements;
    private final ThemeAdapterManager themeAdapterManager;
    private final Map<String, String> resolvedPackageNames;
    private Theme defaultTheme;
    private boolean initialized = false;
    private boolean widgetsInitialized = false;

    public ThemeManager() {
        this.customAppearances = new HashSet<String>();
        this.registeredThemeFiles = new HashSet<String>();
        this.registeredCssElements = new CssElementHolder();
        this.themeAdapterManager = new ThemeAdapterManager();
        this.themes = new HashMap<String, Theme>();
        this.resolvedPackageNames = new HashMap<String, String>();
        this.addDefaultTheme();
    }

    public void activate() {
        this.initialize();
        this.registerResources();
    }

    public void deactivate() {
        this.resolvedPackageNames.clear();
        this.themes.clear();
        this.themeAdapterManager.reset();
        this.registeredCssElements.clear();
        this.registeredThemeFiles.clear();
        this.customAppearances.clear();
        this.themeableWidgets.reset();
        this.widgetsInitialized = false;
        this.initialized = false;
        this.addDefaultTheme();
    }

    private void initialize() {
        if (!this.initialized) {
            this.initializeThemeableWidgets();
            Collection<Theme> allThemes = this.themes.values();
            Iterator<Theme> iterator = allThemes.iterator();
            ThemeableWidget[] allThemeableWidgets = this.themeableWidgets.getAll();
            while (iterator.hasNext()) {
                Theme theme = iterator.next();
                theme.initialize(allThemeableWidgets);
            }
            this.initialized = true;
        }
    }

    private void initializeThemeableWidgets() {
        StyleSheet defaultThemeContributionsBuffer = this.defaultTheme.getStyleSheet();
        this.doInitializeThemableWidgets();
        this.defaultTheme.addStyleSheet(defaultThemeContributionsBuffer);
    }

    private void doInitializeThemableWidgets() {
        if (!this.widgetsInitialized) {
            this.addDefaultThemableWidgets();
            ThemeableWidget[] widgets = this.themeableWidgets.getAll();
            int i = 0;
            while (i < widgets.length) {
                this.processThemeableWidget(widgets[i]);
                ++i;
            }
            this.widgetsInitialized = true;
        }
    }

    private void addDefaultTheme() {
        this.defaultTheme = new Theme(DEFAULT_THEME_ID, DEFAULT_THEME_NAME, null);
        this.themes.put(DEFAULT_THEME_ID, this.defaultTheme);
    }

    public void addThemeableWidget(Class widget, ResourceLoader loader) {
        this.checkNotInitialized();
        ParamCheck.notNull(widget, "widget");
        ParamCheck.notNull(loader, "loader");
        if (!Widget.class.isAssignableFrom(widget)) {
            String message = "Themeable widget is not a subtype of Widget: " + widget.getName();
            throw new IllegalArgumentException(message);
        }
        this.themeableWidgets.add(new ThemeableWidget(widget, loader));
    }

    public ThemeAdapterManager getThemeAdapterManager() {
        return this.themeAdapterManager;
    }

    public void registerTheme(Theme theme) {
        this.checkNotInitialized();
        String id = theme.getId();
        if (this.themes.containsKey(id)) {
            String pattern = "Theme with id ''{0}'' exists already";
            Object[] arguments = new Object[]{id};
            String msg = MessageFormat.format(pattern, arguments);
            throw new IllegalArgumentException(msg);
        }
        this.themes.put(id, theme);
    }

    public boolean hasTheme(String themeId) {
        return this.themes.containsKey(themeId);
    }

    public Theme getTheme(String themeId) {
        Theme result = null;
        if (this.themes.containsKey(themeId)) {
            result = this.themes.get(themeId);
        }
        return result;
    }

    public String[] getRegisteredThemeIds() {
        String[] result = new String[this.themes.size()];
        return this.themes.keySet().toArray(result);
    }

    public void registerResources() {
        this.checkInitialized();
        Iterator<String> iterator = this.themes.keySet().iterator();
        this.registerThemeFiles(this.defaultTheme);
        while (iterator.hasNext()) {
            String key = iterator.next();
            Theme theme = this.themes.get(key);
            if (theme == this.defaultTheme) continue;
            this.registerThemeFiles(theme);
        }
    }

    public ThemeableWidget getThemeableWidget(Class widget) {
        return this.themeableWidgets.get(widget);
    }

    ThemeableWidget[] getAllThemeableWidget() {
        return this.themeableWidgets.getAll();
    }

    private void checkNotInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("ThemeManager is already initialized");
        }
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("ThemeManager not initialized");
        }
    }

    private void addDefaultThemableWidgets() {
        int i = 0;
        while (i < THEMEABLE_WIDGETS.length) {
            this.addThemeableWidget(THEMEABLE_WIDGETS[i], STANDARD_RESOURCE_LOADER);
            ++i;
        }
    }

    private void processThemeableWidget(ThemeableWidget themeWidget) {
        String className = LifeCycleAdapterUtil.getSimpleClassName(themeWidget.widget);
        String[] variants = LifeCycleAdapterUtil.getKitPackageVariants(themeWidget.widget);
        boolean found = false;
        try {
            int i = 0;
            while (i < variants.length && !found) {
                found |= this.loadThemeDef(themeWidget, variants[i], className);
                found |= this.loadAppearanceJs(themeWidget, variants[i], className);
                found |= this.loadDefaultCss(themeWidget, variants[i], className);
                ++i;
            }
            if (themeWidget.elements == null) {
                ThemeManager.log("WARNING: No elements defined for themeable widget: " + themeWidget.widget.getName());
            }
            if (themeWidget.defaultStyleSheet != null) {
                this.defaultTheme.addStyleSheet(themeWidget.defaultStyleSheet);
            }
        }
        catch (IOException e) {
            String msg = "Failed to initialize themeable widget: " + themeWidget.widget.getName();
            throw new ThemeManagerException(msg, e);
        }
    }

    private boolean loadThemeDef(ThemeableWidget themeWidget, String pkgName, String className) throws IOException {
        boolean result = false;
        String resPkgName = this.resolvePackageName(pkgName);
        String fileName = String.valueOf(resPkgName) + "/" + className + ".theme.xml";
        InputStream inStream = themeWidget.loader.getResourceAsStream(fileName);
        if (inStream != null) {
            ThemeManager.log("Found theme definition file: " + fileName);
            result = true;
            try {
                try {
                    ThemeDefinitionReader reader = new ThemeDefinitionReader(inStream, fileName);
                    reader.read();
                    themeWidget.elements = reader.getThemeCssElements();
                    int i = 0;
                    while (i < themeWidget.elements.length) {
                        this.registeredCssElements.addElement(themeWidget.elements[i]);
                        ++i;
                    }
                }
                catch (Exception e) {
                    String message = "Failed to parse theme definition file " + fileName;
                    throw new ThemeManagerException(message, e);
                }
            }
            finally {
                inStream.close();
            }
        }
        return result;
    }

    private String resolvePackageName(String packageName) {
        String result = this.resolvedPackageNames.get(packageName);
        if (result == null) {
            result = packageName.replace('.', '/');
            this.resolvedPackageNames.put(packageName, result);
        }
        return result;
    }

    private boolean loadAppearanceJs(ThemeableWidget themeWidget, String pkgName, String className) throws IOException {
        boolean result = false;
        String resPkgName = this.resolvePackageName(pkgName);
        String fileName = String.valueOf(resPkgName) + "/" + className + ".appearances.js";
        InputStream inStream = themeWidget.loader.getResourceAsStream(fileName);
        if (inStream != null) {
            ThemeManager.log("Found appearance js file: " + fileName);
            try {
                String content = AppearancesUtil.readAppearanceFile(inStream);
                this.customAppearances.add(content);
                result = true;
            }
            finally {
                inStream.close();
            }
        }
        return result;
    }

    private boolean loadDefaultCss(ThemeableWidget themeWidget, String pkgName, String className) throws IOException {
        boolean result = false;
        ResourceLoader resLoader = themeWidget.loader;
        String resPkgName = this.resolvePackageName(pkgName);
        String fileName = String.valueOf(resPkgName) + "/" + className + ".default.css";
        InputStream inStream = resLoader.getResourceAsStream(fileName);
        if (inStream != null) {
            ThemeManager.log("Found default css file: " + fileName);
            try {
                themeWidget.defaultStyleSheet = CssFileReader.readStyleSheet(inStream, fileName, resLoader);
                result = true;
            }
            finally {
                inStream.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerThemeFiles(Theme theme) {
        boolean compress = !ThemeManager.isDebugVariant();
        Set<String> set = this.registeredThemeFiles;
        synchronized (set) {
            String themeId = theme.getId();
            if (!this.registeredThemeFiles.contains(themeId)) {
                String jsId = theme.getJsId();
                this.registerThemeableWidgetImages(theme);
                this.registerThemeableWidgetCursors(theme);
                StringBuffer sb = new StringBuffer();
                sb.append(this.createQxThemes(theme));
                IThemeCssElement[] elements = this.registeredCssElements.getAllElements();
                ThemeStoreWriter storeWriter = new ThemeStoreWriter(elements);
                storeWriter.addTheme(theme, theme == this.defaultTheme);
                sb.append(storeWriter.createJs());
                String themeCode = sb.toString();
                ThemeManager.log("-- REGISTERED THEME CODE FOR " + themeId + " ( " + themeCode.length() + " )--");
                ThemeManager.log(themeCode);
                ThemeManager.log("-- END REGISTERED THEME CODE --");
                String name = String.valueOf(this.resolvePackageName(jsId)) + ".js";
                ThemeManager.registerJsLibrary(name, themeCode, compress);
                this.registeredThemeFiles.add(themeId);
            }
        }
    }

    private void registerThemeableWidgetImages(Theme theme) {
        QxType[] values = theme.getValuesMap().getAllValues();
        int i = 0;
        while (i < values.length) {
            QxType value = values[i];
            if (value instanceof QxImage) {
                QxImage image = (QxImage)value;
                if (!image.none) {
                    InputStream inputStream;
                    try {
                        inputStream = image.loader.getResourceAsStream(image.path);
                    }
                    catch (IOException e) {
                        String message = "Failed to load resource " + image.path;
                        throw new ThemeManagerException(message, e);
                    }
                    if (inputStream == null) {
                        String pattern = "Resource ''{0}'' not found for theme ''{1}''";
                        Object[] arguments = new Object[]{image.path, theme.getName()};
                        String mesg = MessageFormat.format(pattern, arguments);
                        throw new IllegalArgumentException(mesg);
                    }
                    try {
                        ThemePropertyAdapterRegistry registry = ThemePropertyAdapterRegistry.getInstance();
                        ThemePropertyAdapterRegistry.ThemePropertyAdapter adapter = registry.getPropertyAdapter(value.getClass());
                        String key = adapter.getKey(value);
                        String registerPath = "themes/images/" + key;
                        ThemeManager.getResourceManager().register(registerPath, inputStream);
                    }
                    finally {
                        StreamUtil.close(inputStream);
                    }
                }
            }
            ++i;
        }
    }

    private void registerThemeableWidgetCursors(Theme theme) {
        QxType[] values = theme.getValuesMap().getAllValues();
        int i = 0;
        while (i < values.length) {
            QxCursor cursor;
            QxType value = values[i];
            if (value instanceof QxCursor && (cursor = (QxCursor)value).isCustomCursor()) {
                InputStream inputStream;
                ThemePropertyAdapterRegistry registry = ThemePropertyAdapterRegistry.getInstance();
                ThemePropertyAdapterRegistry.ThemePropertyAdapter adapter = registry.getPropertyAdapter(value.getClass());
                String key = adapter.getKey(value);
                String path = cursor.value;
                ThemeManager.log(" register theme cursor " + key + ", path=" + path);
                try {
                    inputStream = cursor.loader.getResourceAsStream(path);
                }
                catch (IOException e) {
                    String message = "Failed to load resource " + path;
                    throw new ThemeManagerException(message, e);
                }
                if (inputStream == null) {
                    String pattern = "Resource ''{0}'' not found for theme ''{1}''";
                    Object[] arguments = new Object[]{path, theme.getName()};
                    String mesg = MessageFormat.format(pattern, arguments);
                    throw new IllegalArgumentException(mesg);
                }
                try {
                    String widgetDestPath = CURSOR_DEST_PATH;
                    String registerPath = String.valueOf(widgetDestPath) + "/" + key;
                    ThemeManager.getResourceManager().register(registerPath, inputStream);
                    String location = ThemeManager.getResourceManager().getLocation(registerPath);
                    ThemeManager.log(" theme cursor registered @ " + location);
                }
                finally {
                    StreamUtil.close(inputStream);
                }
            }
            ++i;
        }
    }

    private static void registerJsLibrary(String name, String code, boolean compress) {
        IResourceManager.RegisterOptions option;
        IResourceManager resourceManager = ThemeManager.getResourceManager();
        IResourceManager.RegisterOptions registerOptions = option = compress ? IResourceManager.RegisterOptions.VERSION_AND_COMPRESS : IResourceManager.RegisterOptions.VERSION;
        if (code != null) {
            byte[] buffer;
            try {
                buffer = code.getBytes(CHARSET);
            }
            catch (UnsupportedEncodingException shouldNotHappen) {
                throw new RuntimeException(shouldNotHappen);
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer);
            resourceManager.register(name, inputStream, CHARSET, option);
        } else {
            resourceManager.register(name, CHARSET, option);
        }
        ResourceUtil.useJsLibrary(name);
    }

    private static IResourceManager getResourceManager() {
        return RWTFactory.getResourceManager();
    }

    private String createQxThemes(Theme theme) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.createQxTheme(theme, 2));
        buffer.append(this.createQxTheme(theme, 3));
        buffer.append(this.createQxTheme(theme, 4));
        buffer.append(this.createQxTheme(theme, 1));
        return buffer.toString();
    }

    private String createQxTheme(Theme theme, int type) {
        String jsId = theme.getJsId();
        String base = null;
        if (type == 4) {
            base = "org.eclipse.swt.theme.AppearancesBase";
        }
        QxTheme qxTheme = new QxTheme(jsId, theme.getName(), type, base);
        if (type == 3 || type == 2) {
            String uri = "rwt-resources/resource/widget/rap";
            qxTheme.appendUri(uri);
        } else if (type == 4) {
            for (String appearance : this.customAppearances) {
                qxTheme.appendValues(appearance);
            }
        } else if (type == 1) {
            qxTheme.appendTheme("icon", String.valueOf(jsId) + "Icons");
            qxTheme.appendTheme("widget", String.valueOf(jsId) + "Widgets");
            qxTheme.appendTheme("appearance", String.valueOf(jsId) + "Appearances");
        }
        return qxTheme.getJsCode();
    }

    private static boolean isDebugVariant() {
        String libraryVariant = System.getProperty(CLIENT_LIBRARY_VARIANT);
        return DEBUG_CLIENT_LIBRARY_VARIANT.equals(libraryVariant);
    }

    private static void log(String mesg) {
        if (DEBUG) {
            System.out.println(mesg);
        }
    }
}

