/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.uicallback;

import java.io.IOException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rwt.internal.lifecycle.JavaScriptResponseWriter;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.uicallback.UICallBackManager;
import org.eclipse.rwt.service.IServiceHandler;
import org.eclipse.rwt.service.ISessionStore;

public class UICallBackServiceHandler
implements IServiceHandler {
    public static final String HANDLER_ID = UICallBackServiceHandler.class.getName();
    private static final String JS_SEND_UI_REQUEST = "org.eclipse.swt.Request.getInstance()._sendImmediate( true );";
    private static final String ATTR_NEEDS_UICALLBACK = String.valueOf(UICallBackServiceHandler.class.getName()) + ".needsUICallback";

    public void service() throws IOException {
        HttpServletResponse response = ContextProvider.getResponse();
        ISessionStore sessionStore = ContextProvider.getSession();
        boolean success = UICallBackManager.getInstance().processRequest(response);
        if (success && sessionStore.isBound()) {
            JavaScriptResponseWriter writer = new JavaScriptResponseWriter((ServletResponse)response);
            UICallBackServiceHandler.writeUICallBackDeactivation(writer);
            UICallBackServiceHandler.writeUIRequestNeeded(writer);
        }
    }

    public static void writeUICallBackActivation(JavaScriptResponseWriter writer) {
        boolean actual = UICallBackManager.getInstance().needsActivation();
        boolean preserved = UICallBackServiceHandler.getPreservedUICallBackActivation();
        if (preserved != actual && actual) {
            UICallBackServiceHandler.writeUICallBackActivation(writer, actual);
            ISessionStore sessionStore = ContextProvider.getSession();
            sessionStore.setAttribute(ATTR_NEEDS_UICALLBACK, actual);
        }
    }

    public static void writeUICallBackDeactivation(JavaScriptResponseWriter writer) {
        boolean actual = UICallBackManager.getInstance().needsActivation();
        boolean preserved = UICallBackServiceHandler.getPreservedUICallBackActivation();
        if (preserved != actual && !actual) {
            UICallBackServiceHandler.writeUICallBackActivation(writer, actual);
            ISessionStore sessionStore = ContextProvider.getSession();
            sessionStore.setAttribute(ATTR_NEEDS_UICALLBACK, actual);
        }
    }

    private static void writeUICallBackActivation(JavaScriptResponseWriter writer, boolean value) {
        writer.write("org.eclipse.swt.Request.getInstance().setUiCallBackActive( " + Boolean.toString(value) + " );");
    }

    private static boolean getPreservedUICallBackActivation() {
        boolean result = false;
        ISessionStore sessionStore = ContextProvider.getSession();
        Boolean preserved = (Boolean)sessionStore.getAttribute(ATTR_NEEDS_UICALLBACK);
        if (preserved != null) {
            result = preserved;
        }
        return result;
    }

    static void writeUIRequestNeeded(JavaScriptResponseWriter writer) {
        if (UICallBackManager.getInstance().hasRunnables()) {
            writer.write(JS_SEND_UI_REQUEST);
        }
    }
}

