/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.widgets;

import org.eclipse.rwt.internal.application.RWTFactory;
import org.eclipse.rwt.internal.lifecycle.JavaScriptResponseWriter;
import org.eclipse.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.lifecycle.PhaseEvent;
import org.eclipse.rwt.lifecycle.PhaseId;
import org.eclipse.rwt.lifecycle.PhaseListener;
import org.eclipse.swt.widgets.Display;

public final class JSExecutor {
    private static final String JS_EXECUTOR = String.valueOf(JSExecutor.class.getName()) + "#instance";

    public static void executeJS(String code) {
        JSExecutorPhaseListener jsExecutor = JSExecutor.getJSExecutor();
        if (jsExecutor == null) {
            jsExecutor = new JSExecutorPhaseListener();
            RWTFactory.getLifeCycleFactory().getLifeCycle().addPhaseListener(jsExecutor);
            JSExecutor.setJSExecutor(jsExecutor);
        }
        jsExecutor.append(code);
    }

    private JSExecutor() {
    }

    private static JSExecutorPhaseListener getJSExecutor() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        return (JSExecutorPhaseListener)stateInfo.getAttribute(JS_EXECUTOR);
    }

    private static void setJSExecutor(JSExecutorPhaseListener jsExecutor) {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        stateInfo.setAttribute(JS_EXECUTOR, jsExecutor);
    }

    private static class JSExecutorPhaseListener
    implements PhaseListener {
        private final StringBuffer code;
        private final Display display = Display.getCurrent();

        JSExecutorPhaseListener() {
            this.code = new StringBuffer();
        }

        void append(String command) {
            this.code.append(command);
        }

        public void beforePhase(PhaseEvent event) {
        }

        public void afterPhase(PhaseEvent event) {
            if (this.display == LifeCycleUtil.getSessionDisplay()) {
                IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
                JavaScriptResponseWriter writer = stateInfo.getResponseWriter();
                try {
                    writer.write(this.code.toString());
                }
                finally {
                    RWTFactory.getLifeCycleFactory().getLifeCycle().removePhaseListener(this);
                }
            }
        }

        public PhaseId getPhaseId() {
            return PhaseId.RENDER;
        }
    }
}

