/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.widgets.fileuploadkit;

import java.io.IOException;
import org.eclipse.rwt.internal.widgets.IFileUploadAdapter;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.rwt.widgets.FileUpload;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.ImageFactory;
import org.eclipse.swt.widgets.Widget;

public final class FileUploadLCA
extends AbstractWidgetLCA {
    public static final String PROP_FILENAME = "fileName";

    public void readData(Widget widget) {
        FileUpload fileUpload = (FileUpload)widget;
        this.readFileName(fileUpload);
    }

    public void preserveValues(Widget widget) {
        FileUpload fileUpload = (FileUpload)widget;
        ControlLCAUtil.preserveValues(fileUpload);
        IWidgetAdapter adapter = WidgetUtil.getAdapter(fileUpload);
        adapter.preserve("text", fileUpload.getText());
        adapter.preserve("image", fileUpload.getImage());
        adapter.preserve(PROP_FILENAME, fileUpload.getFileName());
    }

    public void renderInitialization(Widget widget) throws IOException {
        FileUpload fileUpload = (FileUpload)widget;
        JSWriter writer = JSWriter.getWriterFor(fileUpload);
        writer.newWidget("org.eclipse.rwt.widgets.FileUpload");
        ControlLCAUtil.writeStyleFlags(fileUpload);
    }

    public void renderChanges(Widget widget) throws IOException {
        FileUpload fileUpload = (FileUpload)widget;
        ControlLCAUtil.writeChanges(fileUpload);
        FileUploadLCA.writeText(fileUpload);
        FileUploadLCA.writeImage(fileUpload);
        FileUploadLCA.writeSubmit(fileUpload);
    }

    public void renderDispose(Widget widget) throws IOException {
        FileUpload fileUpload = (FileUpload)widget;
        JSWriter writer = JSWriter.getWriterFor(fileUpload);
        writer.dispose();
    }

    private void readFileName(FileUpload fileUpload) {
        IFileUploadAdapter adapter = fileUpload.getAdapter(IFileUploadAdapter.class);
        String fileName = WidgetLCAUtil.readPropertyValue(fileUpload, PROP_FILENAME);
        if (fileName != null) {
            adapter.setFileName(fileName == "" ? null : fileName);
            SelectionEvent event = new SelectionEvent(fileUpload, null, 13);
            event.processEvent();
        }
    }

    static void writeText(FileUpload fileUpload) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(fileUpload);
        String text = fileUpload.getText();
        if (WidgetLCAUtil.hasChanged(fileUpload, "text", text, null)) {
            writer.set("text", (text = WidgetLCAUtil.escapeText(text, true)).equals("") ? null : text);
        }
    }

    static void writeImage(FileUpload fileUpload) throws IOException {
        Image image = fileUpload.getImage();
        if (WidgetLCAUtil.hasChanged(fileUpload, "image", image, null)) {
            String imagePath = ImageFactory.getImagePath(image);
            JSWriter writer = JSWriter.getWriterFor(fileUpload);
            Rectangle bounds = image != null ? image.getBounds() : null;
            Object[] args = new Object[]{imagePath, new Integer(bounds != null ? bounds.width : 0), new Integer(bounds != null ? bounds.height : 0)};
            writer.set("image", args);
        }
    }

    static void writeSubmit(FileUpload fileUpload) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(fileUpload);
        IFileUploadAdapter adapter = fileUpload.getAdapter(IFileUploadAdapter.class);
        String url = adapter.getAndResetUrl();
        if (url != null) {
            writer.call("submit", new Object[]{url});
        }
    }
}

