/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.events;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.lifecycle.PhaseId;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DragDetectEvent;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.internal.events.ActivateEvent;
import org.eclipse.swt.internal.events.DeselectionEvent;
import org.eclipse.swt.internal.events.SetDataEvent;
import org.eclipse.swt.internal.events.ShowEvent;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedEvent
extends org.eclipse.rwt.internal.events.Event {
    private static final long serialVersionUID = 1L;
    private static final String ATTR_SCHEDULED_EVENT_LIST = String.valueOf(TypedEvent.class.getName()) + "#scheduledEventList";
    private static final Class[] EVENT_ORDER = new Class[]{ControlEvent.class, ActivateEvent.class, ShowEvent.class, DisposeEvent.class, SetDataEvent.class, FocusEvent.class, MenuDetectEvent.class, MouseEvent.class, VerifyEvent.class, ModifyEvent.class, TreeEvent.class, CTabFolderEvent.class, ExpandEvent.class, DeselectionEvent.class, SelectionEvent.class, LocationEvent.class, ProgressEvent.class, ShellEvent.class, MenuEvent.class, KeyEvent.class, DragDetectEvent.class, DragSourceEvent.class, DropTargetEvent.class, HelpEvent.class, ArmEvent.class, PaintEvent.class};
    public Display display;
    public Widget widget;
    public Object data;

    public TypedEvent(Event e) {
        super(e.widget, e.type);
        this.display = e.display;
        this.widget = e.widget;
        this.data = e.data;
    }

    public TypedEvent(Object source) {
        this(source, 0);
    }

    public TypedEvent(Object source, int id) {
        super(source, id);
        this.widget = (Widget)source;
        this.display = this.widget.getDisplay();
    }

    @Override
    public Object getSource() {
        return super.getSource();
    }

    @Override
    public final void processEvent() {
        PhaseId currentPhase = CurrentPhase.get();
        if (currentPhase != null) {
            if (PhaseId.PREPARE_UI_ROOT.equals(currentPhase) || PhaseId.PROCESS_ACTION.equals(currentPhase)) {
                if (!TypedEvent.isFiltered(this.processFilters())) {
                    super.processEvent();
                }
            } else {
                TypedEvent.addToScheduledEvents(this);
            }
        }
    }

    public static boolean executeNext() {
        boolean result = false;
        TypedEvent[] events = TypedEvent.getScheduledEvents();
        while (!result && events.length > 0) {
            TypedEvent event = events[0];
            TypedEvent.getScheduledEventList().remove(event);
            if (event.allowProcessing()) {
                event.processEvent();
                result = true;
            }
            events = TypedEvent.getScheduledEvents();
        }
        return result;
    }

    private Event processFilters() {
        IDisplayAdapter.IFilterEntry[] filters = this.getFilterEntries();
        Event result = new Event();
        result.widget = this.widget;
        result.type = this.getID();
        int i = 0;
        while (!TypedEvent.isFiltered(result) && i < filters.length) {
            if (filters[i].getType() == result.type) {
                filters[i].getListener().handleEvent(result);
            }
            ++i;
        }
        return result;
    }

    private static boolean isFiltered(Event event) {
        return event.type == 0;
    }

    private IDisplayAdapter.IFilterEntry[] getFilterEntries() {
        Display display = this.widget.getDisplay();
        IDisplayAdapter adapter = display.getAdapter(IDisplayAdapter.class);
        return adapter.getFilters();
    }

    private static void addToScheduledEvents(TypedEvent event) {
        TypedEvent.getScheduledEventList().add(event);
    }

    private static TypedEvent[] getScheduledEvents() {
        List<TypedEvent> list = TypedEvent.getScheduledEventList();
        ArrayList<TypedEvent> sortedEvents = new ArrayList<TypedEvent>();
        int i = 0;
        while (i < EVENT_ORDER.length) {
            int k = 0;
            while (k < list.size()) {
                TypedEvent event = list.get(k);
                if (EVENT_ORDER[i].equals(event.getClass())) {
                    sortedEvents.add(event);
                }
                ++k;
            }
            ++i;
        }
        TypedEvent[] result = new TypedEvent[sortedEvents.size()];
        sortedEvents.toArray(result);
        return result;
    }

    private static List<TypedEvent> getScheduledEventList() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        ArrayList result = (ArrayList)stateInfo.getAttribute(ATTR_SCHEDULED_EVENT_LIST);
        if (result == null) {
            result = new ArrayList();
            stateInfo.setAttribute(ATTR_SCHEDULED_EVENT_LIST, result);
        }
        return result;
    }

    protected boolean allowProcessing() {
        String msg = "Derived classes must override allowProcessing.";
        throw new UnsupportedOperationException(msg);
    }

    @Override
    protected void dispatchToObserver(Object listener) {
        String msg = "Derived classes must override dispatchToObserver.";
        throw new UnsupportedOperationException(msg);
    }

    @Override
    protected Class getListenerType() {
        String msg = "Derived classes must override getListenerType.";
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getName()) + "{" + this.widget + " data=" + this.data + "}";
    }

    private String getName() {
        String result = this.getClass().getName();
        int index = result.lastIndexOf(46);
        if (index != -1) {
            result = result.substring(index + 1, result.length());
        }
        return result;
    }
}

