/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCDelegate;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.FontUtil;
import org.eclipse.swt.internal.graphics.GCAdapter;
import org.eclipse.swt.internal.graphics.GCOperation;
import org.eclipse.swt.internal.graphics.IGCAdapter;
import org.eclipse.swt.widgets.Control;

class ControlGC
extends GCDelegate {
    private final Control control;
    private Color background;
    private Color foreground;
    private Font font;
    private int alpha;
    private int lineWidth;
    private int lineCap;
    private int lineJoin;

    ControlGC(Control control) {
        this.control = control;
        this.background = control.getBackground();
        this.foreground = control.getForeground();
        this.font = control.getFont();
        this.alpha = 255;
        this.lineWidth = 0;
        this.lineCap = 1;
        this.lineJoin = 1;
    }

    void setBackground(Color color) {
        this.background = color;
        GCOperation.SetProperty operation = new GCOperation.SetProperty(1, color.getRGB());
        this.addGCOperation(operation);
    }

    Color getBackground() {
        return this.background;
    }

    void setForeground(Color color) {
        this.foreground = color;
        GCOperation.SetProperty operation = new GCOperation.SetProperty(0, color.getRGB());
        this.addGCOperation(operation);
    }

    Color getForeground() {
        return this.foreground;
    }

    void setFont(Font font) {
        this.font = font;
        GCOperation.SetProperty operation = new GCOperation.SetProperty(ControlGC.cloneFontData(FontUtil.getData(font)));
        this.addGCOperation(operation);
    }

    Font getFont() {
        return this.font;
    }

    Font getDefaultFont() {
        return this.control.getDisplay().getSystemFont();
    }

    void setAlpha(int alpha) {
        this.alpha = alpha;
        GCOperation.SetProperty operation = new GCOperation.SetProperty(2, alpha);
        this.addGCOperation(operation);
    }

    int getAlpha() {
        return this.alpha;
    }

    void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
        GCOperation.SetProperty operation = new GCOperation.SetProperty(3, lineWidth);
        this.addGCOperation(operation);
    }

    int getLineWidth() {
        return this.lineWidth;
    }

    void setLineCap(int lineCap) {
        this.lineCap = lineCap;
        GCOperation.SetProperty operation = new GCOperation.SetProperty(4, lineCap);
        this.addGCOperation(operation);
    }

    int getLineCap() {
        return this.lineCap;
    }

    void setLineJoin(int lineJoin) {
        this.lineJoin = lineJoin;
        GCOperation.SetProperty operation = new GCOperation.SetProperty(5, lineJoin);
        this.addGCOperation(operation);
    }

    int getLineJoin() {
        return this.lineJoin;
    }

    Rectangle getClipping() {
        return this.control.getBounds();
    }

    Point stringExtent(String string) {
        return Graphics.stringExtent(this.font, string);
    }

    Point textExtent(String string, int wrapWidth) {
        return Graphics.textExtent(this.font, string, wrapWidth);
    }

    void drawPoint(int x, int y) {
        GCOperation.DrawPoint operation = new GCOperation.DrawPoint(x, y);
        this.addGCOperation(operation);
    }

    void drawLine(int x1, int y1, int x2, int y2) {
        GCOperation.DrawLine operation = new GCOperation.DrawLine(x1, y1, x2, y2);
        this.addGCOperation(operation);
    }

    void drawPolyline(int[] pointArray, boolean close, boolean fill) {
        GCOperation.DrawPolyline operation = new GCOperation.DrawPolyline(pointArray, close, fill);
        this.addGCOperation(operation);
    }

    void drawRectangle(Rectangle bounds, boolean fill) {
        GCOperation.DrawRectangle operation = new GCOperation.DrawRectangle(bounds, fill);
        this.addGCOperation(operation);
    }

    void drawRoundRectangle(Rectangle bounds, int arcWidth, int arcHeight, boolean fill) {
        GCOperation.DrawRoundRectangle operation = new GCOperation.DrawRoundRectangle(bounds, arcWidth, arcHeight, fill);
        this.addGCOperation(operation);
    }

    void fillGradientRectangle(Rectangle bounds, boolean vertical) {
        GCOperation.FillGradientRectangle operation = new GCOperation.FillGradientRectangle(bounds, vertical);
        this.addGCOperation(operation);
    }

    void drawArc(Rectangle bounds, int startAngle, int arcAngle, boolean fill) {
        GCOperation.DrawArc operation = new GCOperation.DrawArc(bounds, startAngle, arcAngle, fill);
        this.addGCOperation(operation);
    }

    void drawImage(Image image, Rectangle src, Rectangle dest, boolean simple) {
        GCOperation.DrawImage operation = new GCOperation.DrawImage(image, src, dest, simple);
        this.addGCOperation(operation);
    }

    void drawText(String string, int x, int y, int flags) {
        GCOperation.DrawText operation = new GCOperation.DrawText(string, x, y, flags);
        this.addGCOperation(operation);
    }

    GCAdapter getGCAdapter() {
        return (GCAdapter)this.control.getAdapter(IGCAdapter.class);
    }

    private void addGCOperation(GCOperation operation) {
        GCAdapter adapter = this.getGCAdapter();
        if (adapter != null) {
            adapter.addGCOperation(operation);
        }
    }

    private static FontData cloneFontData(FontData fontData) {
        FontData result = new FontData(fontData.getName(), fontData.getHeight(), fontData.getStyle());
        result.setLocale(fontData.getLocale());
        return result;
    }
}

