/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.custom.ctabfolderkit;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.custom.ICTabFolderAdapter;
import org.eclipse.swt.internal.graphics.ImageFactory;
import org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter;
import org.eclipse.swt.widgets.Widget;

public final class CTabFolderLCA
extends AbstractWidgetLCA {
    public static final String PARAM_SELECTED_ITEM_ID = "selectedItemId";
    public static final String PARAM_MAXIMIZED = "maximized";
    public static final String PARAM_MINIMIZED = "minimized";
    public static final String EVENT_FOLDER_MINIMIZED = "org.eclipse.swt.events.ctabFolderMinimized";
    public static final String EVENT_FOLDER_MAXIMIZED = "org.eclipse.swt.events.ctabFolderMaximized";
    public static final String EVENT_FOLDER_RESTORED = "org.eclipse.swt.events.ctabFolderRestored";
    public static final String EVENT_SHOW_LIST = "org.eclipse.swt.events.ctabFolderShowList";
    public static final String PROP_SELECTION_INDEX = "selectionIndex";
    public static final String PROP_MAXIMIZED = "maximized";
    public static final String PROP_MINIMIZED = "minimized";
    public static final String PROP_MINIMIZE_VISIBLE = "minimizeVisible";
    public static final String PROP_MAXIMIZE_VISIBLE = "maximizeVisible";
    public static final String PROP_MINIMIZE_RECT = "minimizeRect";
    public static final String PROP_MAXIMIZE_RECT = "maximizeRect";
    public static final String PROP_FOLDER_LISTENERS = "folderListeners";
    public static final String PROP_TAB_HEIGHT = "tabHeight";
    public static final String PROP_WIDTH = "width";
    public static final String PROP_CHEVRON_VISIBLE = "chevronVisible";
    public static final String PROP_CHEVRON_RECT = "chevronRect";
    public static final String PROP_SELECTION_FG = "selectionFg";
    public static final String PROP_SELECTION_BG = "selectionBg";
    public static final String PROP_SELECTION_BG_IMAGE = "selectionBgImage";
    public static final String PROP_SELECTION_BG_GRADIENT_COLORS = "selectionBgGradientColors";
    public static final String PROP_SELECTION_BG_GRADIENT_PERCENTS = "selectionBgGradientPercents";
    public static final String PROP_SELECTION_BG_GRADIENT_VERTICAL = "selectionBgGradientVertical";
    public static final String PROP_TAB_POSITION = "tabPosition";
    private static final String PROP_BORDER_VISIBLE = "borderVisible";
    private static final Integer DEFAULT_TAB_HEIGHT = new Integer(20);
    private static final Integer DEFAULT_TAB_POSITION = new Integer(128);
    private static final Rectangle ZERO_RECTANGLE = new Rectangle(0, 0, 0, 0);

    public void preserveValues(Widget widget) {
        CTabFolder tabFolder = (CTabFolder)widget;
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        ICTabFolderAdapter tabFolderAdapter = CTabFolderLCA.getCTabFolderAdapter(tabFolder);
        ControlLCAUtil.preserveValues(tabFolder);
        boolean hasListeners = SelectionEvent.hasListener(tabFolder);
        adapter.preserve("selectionListeners", hasListeners);
        hasListeners = CTabFolderEvent.hasListener(tabFolder);
        adapter.preserve(PROP_FOLDER_LISTENERS, hasListeners);
        adapter.preserve(PROP_SELECTION_INDEX, new Integer(tabFolder.getSelectionIndex()));
        adapter.preserve(PROP_WIDTH, new Integer(tabFolder.getBounds().width));
        adapter.preserve(PROP_MINIMIZE_VISIBLE, tabFolder.getMinimizeVisible());
        adapter.preserve(PROP_MAXIMIZE_VISIBLE, tabFolder.getMaximizeVisible());
        adapter.preserve(PROP_MINIMIZE_RECT, tabFolderAdapter.getMinimizeRect());
        adapter.preserve(PROP_MAXIMIZE_RECT, tabFolderAdapter.getMaximizeRect());
        adapter.preserve("minimized", tabFolder.getMinimized());
        adapter.preserve("maximized", tabFolder.getMaximized());
        adapter.preserve(PROP_TAB_HEIGHT, new Integer(tabFolder.getTabHeight()));
        adapter.preserve(PROP_TAB_POSITION, new Integer(tabFolder.getTabPosition()));
        adapter.preserve(PROP_SELECTION_BG, tabFolderAdapter.getUserSelectionBackground());
        adapter.preserve(PROP_SELECTION_BG_IMAGE, tabFolderAdapter.getUserSelectionBackgroundImage());
        CTabFolderLCA.preserveSelectionBgGradient(tabFolder);
        adapter.preserve(PROP_SELECTION_FG, tabFolderAdapter.getUserSelectionForeground());
        adapter.preserve(PROP_CHEVRON_VISIBLE, tabFolderAdapter.getChevronVisible());
        adapter.preserve(PROP_CHEVRON_RECT, tabFolderAdapter.getChevronRect());
        adapter.preserve(PROP_BORDER_VISIBLE, tabFolder.getBorderVisible());
        WidgetLCAUtil.preserveCustomVariant(tabFolder);
    }

    public void readData(Widget widget) {
        String selectedItemId;
        CTabFolderEvent event;
        final CTabFolder tabFolder = (CTabFolder)widget;
        String value = WidgetLCAUtil.readPropertyValue(tabFolder, "minimized");
        if (value != null) {
            tabFolder.setMinimized(Boolean.valueOf(value));
        }
        if ((value = WidgetLCAUtil.readPropertyValue(tabFolder, "maximized")) != null) {
            tabFolder.setMaximized(Boolean.valueOf(value));
        }
        if (WidgetLCAUtil.wasEventSent(tabFolder, EVENT_FOLDER_MINIMIZED)) {
            event = CTabFolderLCA.minimize(tabFolder);
            event.processEvent();
        }
        if (WidgetLCAUtil.wasEventSent(tabFolder, EVENT_FOLDER_MAXIMIZED)) {
            event = CTabFolderLCA.maximize(tabFolder);
            event.processEvent();
        }
        if (WidgetLCAUtil.wasEventSent(tabFolder, EVENT_FOLDER_RESTORED)) {
            event = CTabFolderLCA.restore(tabFolder);
            event.processEvent();
        }
        if ((selectedItemId = WidgetLCAUtil.readPropertyValue(tabFolder, PARAM_SELECTED_ITEM_ID)) != null) {
            final CTabItem tabItem = (CTabItem)WidgetUtil.find(tabFolder, selectedItemId);
            CTabFolderLCA.setInternalSelectedItem(tabFolder, tabItem);
            ProcessActionRunner.add(new Runnable(){

                public void run() {
                    tabFolder.setSelection(tabItem);
                    ControlLCAUtil.processSelection(tabFolder, tabItem, false);
                }
            });
        }
        if (WidgetLCAUtil.wasEventSent(tabFolder, EVENT_SHOW_LIST)) {
            ProcessActionRunner.add(new Runnable(){

                public void run() {
                    CTabFolderEvent event = CTabFolderLCA.showList(tabFolder);
                    event.processEvent();
                    if (event.doit) {
                        ICTabFolderAdapter adapter = CTabFolderLCA.getCTabFolderAdapter(tabFolder);
                        adapter.showListMenu();
                    }
                }
            });
        }
        ControlLCAUtil.processMouseEvents(tabFolder);
        ControlLCAUtil.processKeyEvents(tabFolder);
        ControlLCAUtil.processMenuDetect(tabFolder);
        WidgetLCAUtil.processHelp(tabFolder);
    }

    public void renderInitialization(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.newWidget("org.eclipse.swt.custom.CTabFolder");
        CTabFolder tabFolder = (CTabFolder)widget;
        ControlLCAUtil.writeStyleFlags(tabFolder);
        WidgetLCAUtil.writeStyleFlag(tabFolder, 0x800000, "FLAT");
        Object[] args = new String[]{SWT.getMessage("SWT_Minimize"), SWT.getMessage("SWT_Maximize"), SWT.getMessage("SWT_Restore"), SWT.getMessage("SWT_ShowList"), SWT.getMessage("SWT_Close")};
        writer.callStatic("org.eclipse.swt.custom.CTabFolder.setToolTipTexts", args);
    }

    public void renderChanges(Widget widget) throws IOException {
        CTabFolder tabFolder = (CTabFolder)widget;
        ControlLCAUtil.writeChanges(tabFolder);
        CTabFolderLCA.writeTabPosition(tabFolder);
        CTabFolderLCA.writeTabHeight(tabFolder);
        CTabFolderLCA.writeMinMaxVisible(tabFolder);
        CTabFolderLCA.writeMinMaxState(tabFolder);
        CTabFolderLCA.writeListener(tabFolder);
        CTabFolderLCA.writeChevron(tabFolder);
        CTabFolderLCA.writeSelectionColors(tabFolder);
        CTabFolderLCA.writeSelectionBgImage(tabFolder);
        CTabFolderLCA.writeSelectionBgGradient(tabFolder);
        CTabFolderLCA.writeBorderVisible(tabFolder);
        WidgetLCAUtil.writeCustomVariant(tabFolder);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    public Rectangle adjustCoordinates(Widget widget, Rectangle bounds) {
        Rectangle result = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        if (widget instanceof CTabItem) {
            ++result.height;
            CTabItem item = (CTabItem)widget;
            CTabFolder parent = item.getParent();
            if (parent.getTabPosition() == 1024) {
                --result.y;
            }
        }
        return result;
    }

    private static void preserveSelectionBgGradient(CTabFolder tabFolder) {
        ICTabFolderAdapter adapter = CTabFolderLCA.getCTabFolderAdapter(tabFolder);
        IWidgetGraphicsAdapter gfxAdapter = adapter.getUserSelectionBackgroundGradient();
        Color[] bgGradientColors = gfxAdapter.getBackgroundGradientColors();
        int[] bgGradientPercents = gfxAdapter.getBackgroundGradientPercents();
        Boolean bgGradientVertical = new Boolean(gfxAdapter.isBackgroundGradientVertical());
        IWidgetAdapter widgetAdapter = WidgetUtil.getAdapter(tabFolder);
        widgetAdapter.preserve(PROP_SELECTION_BG_GRADIENT_COLORS, bgGradientColors);
        widgetAdapter.preserve(PROP_SELECTION_BG_GRADIENT_PERCENTS, bgGradientPercents);
        widgetAdapter.preserve(PROP_SELECTION_BG_GRADIENT_VERTICAL, bgGradientVertical);
    }

    private static void writeTabPosition(CTabFolder tabFolder) throws IOException {
        Integer defValue;
        String prop = PROP_TAB_POSITION;
        Integer newValue = new Integer(tabFolder.getTabPosition());
        if (WidgetLCAUtil.hasChanged(tabFolder, prop, newValue, defValue = DEFAULT_TAB_POSITION)) {
            JSWriter writer = JSWriter.getWriterFor(tabFolder);
            String tabPosition = newValue == 128 ? "top" : "bottom";
            writer.set(PROP_TAB_POSITION, tabPosition);
        }
    }

    private static void writeTabHeight(CTabFolder tabFolder) throws IOException {
        Integer tabHeight = new Integer(tabFolder.getTabHeight());
        JSWriter writer = JSWriter.getWriterFor(tabFolder);
        writer.set(PROP_TAB_HEIGHT, PROP_TAB_HEIGHT, tabHeight, DEFAULT_TAB_HEIGHT);
    }

    private static void writeMinMaxVisible(CTabFolder tabFolder) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(tabFolder);
        boolean minChanged = CTabFolderLCA.hasMinChanged(tabFolder);
        boolean maxChanged = CTabFolderLCA.hasMaxChanged(tabFolder);
        if (minChanged || maxChanged) {
            Object[] args;
            ICTabFolderAdapter tabFolderAdapter = CTabFolderLCA.getCTabFolderAdapter(tabFolder);
            if (tabFolder.getMaximizeVisible()) {
                Rectangle maximizeRect = tabFolderAdapter.getMaximizeRect();
                args = new Object[]{new Integer(maximizeRect.x), new Integer(maximizeRect.y), new Integer(maximizeRect.width), new Integer(maximizeRect.height)};
                writer.call("showMaxButton", args);
            } else {
                writer.call("hideMaxButton", null);
            }
            if (tabFolder.getMinimizeVisible()) {
                Rectangle minimizeRect = tabFolderAdapter.getMinimizeRect();
                args = new Object[]{new Integer(minimizeRect.x), new Integer(minimizeRect.y), new Integer(minimizeRect.width), new Integer(minimizeRect.height)};
                writer.call("showMinButton", args);
            } else {
                writer.call("hideMinButton", null);
            }
        }
    }

    private static boolean hasMinChanged(CTabFolder tabFolder) {
        ICTabFolderAdapter tabFolderAdapter = CTabFolderLCA.getCTabFolderAdapter(tabFolder);
        Boolean minVisible = tabFolder.getMinimizeVisible();
        boolean visibilityChanged = WidgetLCAUtil.hasChanged(tabFolder, PROP_MINIMIZE_VISIBLE, minVisible, Boolean.FALSE);
        boolean boundsChanged = false;
        if (!visibilityChanged) {
            Rectangle newBounds = tabFolderAdapter.getMinimizeRect();
            boundsChanged = WidgetLCAUtil.hasChanged(tabFolder, PROP_MINIMIZE_RECT, newBounds, ZERO_RECTANGLE);
        }
        return visibilityChanged || boundsChanged;
    }

    private static boolean hasMaxChanged(CTabFolder tabFolder) {
        ICTabFolderAdapter tabFolderAdapter = CTabFolderLCA.getCTabFolderAdapter(tabFolder);
        Boolean maxVisible = tabFolder.getMaximizeVisible();
        boolean visibilityChanged = WidgetLCAUtil.hasChanged(tabFolder, PROP_MAXIMIZE_VISIBLE, maxVisible, Boolean.FALSE);
        boolean boundsChanged = false;
        if (!visibilityChanged) {
            Rectangle newBounds = tabFolderAdapter.getMaximizeRect();
            boundsChanged = WidgetLCAUtil.hasChanged(tabFolder, PROP_MAXIMIZE_RECT, newBounds, ZERO_RECTANGLE);
        }
        return visibilityChanged || boundsChanged;
    }

    private static void writeMinMaxState(CTabFolder tabFolder) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(tabFolder);
        String minProp = "minimized";
        String maxProp = "maximized";
        Boolean minimized = tabFolder.getMinimized();
        Boolean maximized = tabFolder.getMaximized();
        Boolean defValue = Boolean.FALSE;
        if (WidgetLCAUtil.hasChanged(tabFolder, minProp, minimized, defValue) || WidgetLCAUtil.hasChanged(tabFolder, maxProp, maximized, defValue)) {
            String state = !tabFolder.getMinimized() && !tabFolder.getMaximized() ? "normal" : (tabFolder.getMinimized() ? "min" : "max");
            writer.set("minMaxState", state);
        }
    }

    private static void writeListener(CTabFolder tabFolder) throws IOException {
        String prop;
        boolean hasListener = CTabFolderEvent.hasListener(tabFolder);
        Boolean newValue = hasListener;
        if (WidgetLCAUtil.hasChanged(tabFolder, PROP_FOLDER_LISTENERS, newValue, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor(tabFolder);
            writer.set("hasFolderListener", newValue);
        }
        if (WidgetLCAUtil.hasChanged(tabFolder, prop = "selectionListeners", newValue = Boolean.valueOf(hasListener = SelectionEvent.hasListener(tabFolder)), Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor(tabFolder);
            writer.set("hasSelectionListener", newValue);
        }
    }

    private static void writeChevron(CTabFolder tabFolder) throws IOException {
        ICTabFolderAdapter tabFolderAdapter = CTabFolderLCA.getCTabFolderAdapter(tabFolder);
        Boolean visible = tabFolderAdapter.getChevronVisible();
        Boolean defValue = Boolean.FALSE;
        String prop = PROP_CHEVRON_VISIBLE;
        boolean visibilityChanged = WidgetLCAUtil.hasChanged(tabFolder, prop, visible, defValue);
        prop = PROP_CHEVRON_RECT;
        Rectangle chevronRect = tabFolderAdapter.getChevronRect();
        boolean rectangleChanged = WidgetLCAUtil.hasChanged(tabFolder, prop, chevronRect, null);
        if (visibilityChanged || rectangleChanged) {
            JSWriter writer = JSWriter.getWriterFor(tabFolder);
            if (visible.booleanValue()) {
                Object[] args = new Object[]{new Integer(chevronRect.x), new Integer(chevronRect.y), new Integer(chevronRect.width), new Integer(chevronRect.height)};
                writer.call("showChevron", args);
            } else {
                writer.call("hideChevron", null);
            }
        }
    }

    private static void writeSelectionColors(CTabFolder tabFolder) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(tabFolder);
        ICTabFolderAdapter adapter = CTabFolderLCA.getCTabFolderAdapter(tabFolder);
        Color selFg = adapter.getUserSelectionForeground();
        writer.set(PROP_SELECTION_FG, "selectionForeground", selFg, null);
        Color selBg = adapter.getUserSelectionBackground();
        writer.set(PROP_SELECTION_BG, "selectionBackground", selBg, null);
    }

    private static void writeSelectionBgImage(CTabFolder tabFolder) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(tabFolder);
        ICTabFolderAdapter adapter = CTabFolderLCA.getCTabFolderAdapter(tabFolder);
        Image selBgImage = adapter.getUserSelectionBackgroundImage();
        Object[] args = null;
        if (selBgImage != null) {
            String selBgImagePath = ImageFactory.getImagePath(selBgImage);
            Rectangle selBgImageBounds = selBgImage.getBounds();
            args = new Object[]{selBgImagePath, new Integer(selBgImageBounds.width), new Integer(selBgImageBounds.height)};
        }
        writer.set(PROP_SELECTION_BG_IMAGE, "selectionBackgroundImage", args, null);
    }

    private static void writeSelectionBgGradient(CTabFolder tabFolder) throws IOException {
        ICTabFolderAdapter adapter = CTabFolderLCA.getCTabFolderAdapter(tabFolder);
        IWidgetGraphicsAdapter gfxAdapter = adapter.getUserSelectionBackgroundGradient();
        Color[] bgGradientColors = gfxAdapter.getBackgroundGradientColors();
        int[] bgGradientPercents = gfxAdapter.getBackgroundGradientPercents();
        Boolean bgGradientVertical = new Boolean(gfxAdapter.isBackgroundGradientVertical());
        boolean changed = WidgetLCAUtil.hasChanged(tabFolder, PROP_SELECTION_BG_GRADIENT_COLORS, bgGradientColors, null);
        if (!changed) {
            changed = WidgetLCAUtil.hasChanged(tabFolder, PROP_SELECTION_BG_GRADIENT_PERCENTS, bgGradientPercents, null);
        }
        if (!changed) {
            changed = WidgetLCAUtil.hasChanged(tabFolder, PROP_SELECTION_BG_GRADIENT_VERTICAL, bgGradientVertical, Boolean.FALSE);
        }
        if (changed) {
            JSWriter writer = JSWriter.getWriterFor(tabFolder);
            Integer[] percents = null;
            if (bgGradientPercents != null) {
                percents = new Integer[bgGradientPercents.length];
                int i = 0;
                while (i < bgGradientPercents.length) {
                    percents[i] = new Integer(bgGradientPercents[i]);
                    ++i;
                }
            }
            Object[] args = new Object[]{bgGradientColors, percents, bgGradientVertical};
            writer.call("setSelectionBackgroundGradient", args);
        }
    }

    private static void writeBorderVisible(CTabFolder tabFolder) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(tabFolder);
        writer.set(PROP_BORDER_VISIBLE, PROP_BORDER_VISIBLE, tabFolder.getBorderVisible(), (tabFolder.getStyle() & 0x800) != 0);
    }

    private static ICTabFolderAdapter getCTabFolderAdapter(CTabFolder tabFolder) {
        ICTabFolderAdapter adapter = tabFolder.getAdapter(ICTabFolderAdapter.class);
        return adapter;
    }

    private static CTabFolderEvent showList(CTabFolder tabFolder) {
        ICTabFolderAdapter adapter;
        CTabFolderEvent result = new CTabFolderEvent(tabFolder, 5);
        ICTabFolderAdapter folderAdapter = adapter = tabFolder.getAdapter(ICTabFolderAdapter.class);
        Rectangle chevronRect = folderAdapter.getChevronRect();
        result.x = chevronRect.x;
        result.y = chevronRect.y;
        result.height = chevronRect.height;
        result.width = chevronRect.width;
        result.doit = true;
        return result;
    }

    private static CTabFolderEvent restore(CTabFolder tabFolder) {
        return new CTabFolderEvent(tabFolder, 4);
    }

    private static CTabFolderEvent maximize(CTabFolder tabFolder) {
        return new CTabFolderEvent(tabFolder, 3);
    }

    private static CTabFolderEvent minimize(CTabFolder tabFolder) {
        return new CTabFolderEvent(tabFolder, 2);
    }

    private static void setInternalSelectedItem(CTabFolder tabFolder, CTabItem item) {
        ICTabFolderAdapter adapter;
        ICTabFolderAdapter folderAdapter = adapter = tabFolder.getAdapter(ICTabFolderAdapter.class);
        folderAdapter.setInternalSelectedItem(item);
    }
}

