/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.custom.ctabitemkit;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.custom.ICTabFolderAdapter;
import org.eclipse.swt.internal.widgets.IWidgetFontAdapter;
import org.eclipse.swt.widgets.Widget;

public final class CTabItemLCA
extends AbstractWidgetLCA {
    public static final String EVENT_ITEM_CLOSED = "org.eclipse.swt.events.ctabItemClosed";
    private static final String PROP_TEXT = "text";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_BOUNDS = "bounds";
    private static final String PROP_SELECTED = "selected";
    private static final String PROP_SHOWING = "showing";
    private static final String PROP_SHOW_CLOSE = "showClose";
    private static final String PROP_UNSELECTED_CLOSE_VISIBLE = "unselectedCloseVisible";
    private static final String PROP_FIRST_ITEM = "firstItem";

    public void preserveValues(Widget widget) {
        CTabItem item = (CTabItem)widget;
        CTabFolder parent = item.getParent();
        IWidgetAdapter adapter = WidgetUtil.getAdapter(item);
        adapter.preserve(PROP_TEXT, CTabItemLCA.getShortenedText(item));
        adapter.preserve(PROP_IMAGE, CTabItemLCA.getImage(item));
        WidgetLCAUtil.preserveToolTipText(item, item.getToolTipText());
        adapter.preserve(PROP_BOUNDS, item.getBounds());
        adapter.preserve(PROP_SELECTED, CTabItemLCA.isItemSelected(item));
        boolean closeVisible = parent.getUnselectedCloseVisible();
        adapter.preserve(PROP_UNSELECTED_CLOSE_VISIBLE, closeVisible);
        adapter.preserve(PROP_SHOWING, item.isShowing());
        adapter.preserve(PROP_SHOW_CLOSE, item.getShowClose());
        adapter.preserve(PROP_FIRST_ITEM, item == item.getParent().getItem(0));
        CTabItemLCA.preserveFont(item);
        WidgetLCAUtil.preserveCustomVariant(item);
    }

    public void readData(Widget widget) {
        final CTabItem item = (CTabItem)widget;
        if (WidgetLCAUtil.wasEventSent(item, EVENT_ITEM_CLOSED)) {
            ProcessActionRunner.add(new Runnable(){

                public void run() {
                    CTabFolderEvent event = CTabItemLCA.createCloseEvent(item);
                    event.processEvent();
                    if (event.doit) {
                        item.dispose();
                    }
                }
            });
        }
    }

    public void renderInitialization(Widget widget) throws IOException {
        CTabItem item = (CTabItem)widget;
        CTabFolder parent = item.getParent();
        JSWriter writer = JSWriter.getWriterFor(item);
        Object[] args = new Object[]{parent, CTabItemLCA.showClose(item)};
        writer.newWidget("org.eclipse.swt.custom.CTabItem", args);
        writer.call(parent, "add", new Object[]{item});
    }

    public void renderChanges(Widget widget) throws IOException {
        CTabItem item = (CTabItem)widget;
        WidgetLCAUtil.writeBounds(item, item.getParent(), item.getBounds());
        CTabItemLCA.writeText(item);
        CTabItemLCA.writeImage(item);
        CTabItemLCA.writeFont(item);
        WidgetLCAUtil.writeToolTip(item, item.getToolTipText());
        CTabItemLCA.writeShowing(item);
        CTabItemLCA.writeShowClose(item);
        CTabItemLCA.writeUnselectedCloseVisible(item);
        CTabItemLCA.writeSelection(item);
        CTabItemLCA.writeFirstItem(item);
        WidgetLCAUtil.writeCustomVariant(item);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    private static void writeText(CTabItem item) throws IOException {
        String text = CTabItemLCA.getShortenedText(item);
        if (WidgetLCAUtil.hasChanged(item, PROP_TEXT, text)) {
            text = WidgetLCAUtil.escapeText(text, true);
            JSWriter writer = JSWriter.getWriterFor(item);
            writer.set("label", text);
        }
    }

    private static void writeImage(CTabItem item) throws IOException {
        Image newValue = CTabItemLCA.getImage(item);
        if (WidgetLCAUtil.hasChanged(item, PROP_IMAGE, newValue, null)) {
            WidgetLCAUtil.writeImage(item, "icon", newValue);
        }
    }

    private static void writeFont(CTabItem item) throws IOException {
        IWidgetFontAdapter adapter;
        IWidgetFontAdapter fontAdapter = adapter = item.getAdapter(IWidgetFontAdapter.class);
        Font font = fontAdapter.getUserFont();
        WidgetLCAUtil.writeFont(item, font);
    }

    private static void writeSelection(CTabItem item) throws IOException {
        Boolean defValue;
        JSWriter writer = JSWriter.getWriterFor(item);
        Boolean newValue = CTabItemLCA.isItemSelected(item);
        if (WidgetLCAUtil.hasChanged(item, PROP_SELECTED, newValue, defValue = Boolean.FALSE)) {
            writer.set(PROP_SELECTED, newValue);
        }
    }

    private static void writeFirstItem(CTabItem item) throws IOException {
        Boolean defValue;
        JSWriter writer = JSWriter.getWriterFor(item);
        boolean isFirst = item == item.getParent().getItem(0);
        Boolean newValue = isFirst;
        if (WidgetLCAUtil.hasChanged(item, PROP_FIRST_ITEM, newValue, defValue = Boolean.FALSE)) {
            if (isFirst) {
                writer.call("addState", new Object[]{PROP_FIRST_ITEM});
            } else {
                writer.call("removeState", new Object[]{PROP_FIRST_ITEM});
            }
        }
    }

    private static void writeShowing(CTabItem item) throws IOException {
        Boolean newValue = item.isShowing();
        if (WidgetLCAUtil.hasChanged(item, PROP_SHOWING, newValue, Boolean.TRUE)) {
            JSWriter writer = JSWriter.getWriterFor(item);
            writer.set("visibility", newValue);
        }
    }

    private static void writeShowClose(CTabItem item) throws IOException {
        String prop = PROP_SHOW_CLOSE;
        Boolean newValue = item.getShowClose();
        if (WidgetLCAUtil.hasChanged(item, prop, newValue, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor(item);
            writer.set(PROP_SHOW_CLOSE, newValue);
        }
    }

    private static void writeUnselectedCloseVisible(CTabItem item) throws IOException {
        String prop = PROP_UNSELECTED_CLOSE_VISIBLE;
        CTabFolder parent = item.getParent();
        Boolean newValue = parent.getUnselectedCloseVisible();
        if (WidgetLCAUtil.hasChanged(item, prop, newValue, Boolean.TRUE)) {
            JSWriter writer = JSWriter.getWriterFor(item);
            writer.set(PROP_UNSELECTED_CLOSE_VISIBLE, newValue);
        }
    }

    private static Image getImage(CTabItem item) {
        ICTabFolderAdapter adapter;
        ICTabFolderAdapter folderAdapter;
        Image result = item.getImage();
        if (result != null && !(folderAdapter = (adapter = item.getParent().getAdapter(ICTabFolderAdapter.class))).showItemImage(item)) {
            result = null;
        }
        return result;
    }

    private static String getShortenedText(CTabItem item) {
        ICTabFolderAdapter adapter;
        CTabFolder folder = item.getParent();
        ICTabFolderAdapter folderAdapter = adapter = folder.getAdapter(ICTabFolderAdapter.class);
        return folderAdapter.getShortenedItemText(item);
    }

    private static boolean showClose(CTabItem item) {
        CTabFolder parent = item.getParent();
        ICTabFolderAdapter adapter = parent.getAdapter(ICTabFolderAdapter.class);
        return adapter.showItemClose(item);
    }

    private static CTabFolderEvent createCloseEvent(CTabItem item) {
        CTabFolderEvent result = new CTabFolderEvent(item.getParent(), 1);
        result.item = item;
        result.doit = true;
        return result;
    }

    private static void preserveFont(CTabItem item) {
        IWidgetFontAdapter adapter;
        IWidgetFontAdapter fontAdapter = adapter = item.getAdapter(IWidgetFontAdapter.class);
        Font font = fontAdapter.getUserFont();
        WidgetLCAUtil.preserveFont(item, font);
    }

    private static Boolean isItemSelected(CTabItem item) {
        CTabFolder folder = item.getParent();
        ICTabFolderAdapter adapter = folder.getAdapter(ICTabFolderAdapter.class);
        ICTabFolderAdapter folderAdapter = adapter;
        CTabItem selectedItem = folderAdapter.getInternalSelectedItem();
        return item == selectedItem;
    }
}

