/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.custom.scrolledcompositekit;

import java.io.IOException;
import org.eclipse.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rwt.internal.protocol.IClientObject;
import org.eclipse.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;

public final class ScrolledCompositeLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.ScrolledComposite";
    private static final String PARAM_H_BAR_SELECTION = "horizontalBar.selection";
    private static final String PARAM_V_BAR_SELECTION = "verticalBar.selection";
    private static final String PROP_ORIGIN = "origin";
    private static final String PROP_CONTENT = "content";
    private static final String PROP_SHOW_FOCUSED_CONTROL = "showFocusedControl";
    private static final String PROP_SCROLLBARS_VISIBLE = "scrollBarsVisible";
    private static final String PROP_SCROLLBARS_SELECTION_LISTENER = "scrollBarsSelection";
    private static final Point DEFAULT_ORIGIN = new Point(0, 0);
    private static final boolean[] DEFAULT_SCROLLBARS_VISIBLE = new boolean[]{true, true};

    public void preserveValues(Widget widget) {
        ScrolledComposite composite = (ScrolledComposite)widget;
        ControlLCAUtil.preserveValues(composite);
        WidgetLCAUtil.preserveCustomVariant(composite);
        WidgetLCAUtil.preserveProperty((Widget)composite, PROP_ORIGIN, composite.getOrigin());
        WidgetLCAUtil.preserveProperty((Widget)composite, PROP_CONTENT, composite.getContent());
        WidgetLCAUtil.preserveProperty((Widget)composite, PROP_SHOW_FOCUSED_CONTROL, composite.getShowFocusedControl());
        WidgetLCAUtil.preserveProperty((Widget)composite, PROP_SCROLLBARS_VISIBLE, ScrolledCompositeLCA.getScrollBarsVisible(composite));
        WidgetLCAUtil.preserveListener(composite, PROP_SCROLLBARS_SELECTION_LISTENER, ScrolledCompositeLCA.hasScrollBarsSelectionListener(composite));
    }

    public void readData(Widget widget) {
        ScrolledComposite composite = (ScrolledComposite)widget;
        Point origin = composite.getOrigin();
        String value = WidgetLCAUtil.readPropertyValue(widget, PARAM_H_BAR_SELECTION);
        ScrollBar hScroll = composite.getHorizontalBar();
        if (value != null && hScroll != null) {
            origin.x = NumberFormatUtil.parseInt(value);
            ScrolledCompositeLCA.processSelection(hScroll);
        }
        value = WidgetLCAUtil.readPropertyValue(widget, PARAM_V_BAR_SELECTION);
        ScrollBar vScroll = composite.getVerticalBar();
        if (value != null && vScroll != null) {
            origin.y = NumberFormatUtil.parseInt(value);
            ScrolledCompositeLCA.processSelection(vScroll);
        }
        composite.setOrigin(origin);
        ControlLCAUtil.processMouseEvents(composite);
        ControlLCAUtil.processKeyEvents(composite);
        ControlLCAUtil.processMenuDetect(composite);
        WidgetLCAUtil.processHelp(composite);
    }

    public void renderInitialization(Widget widget) throws IOException {
        ScrolledComposite scrolledComposite = (ScrolledComposite)widget;
        IClientObject clientObject = ClientObjectFactory.getForWidget(scrolledComposite);
        clientObject.create(TYPE);
        clientObject.setProperty("parent", WidgetUtil.getId(scrolledComposite.getParent()));
        clientObject.setProperty("style", WidgetLCAUtil.getStyles(scrolledComposite));
    }

    public void renderChanges(Widget widget) throws IOException {
        ScrolledComposite composite = (ScrolledComposite)widget;
        ControlLCAUtil.renderChanges(composite);
        WidgetLCAUtil.renderCustomVariant(composite);
        WidgetLCAUtil.renderProperty((Widget)composite, PROP_CONTENT, composite.getContent(), null);
        WidgetLCAUtil.renderProperty((Widget)composite, PROP_ORIGIN, composite.getOrigin(), DEFAULT_ORIGIN);
        WidgetLCAUtil.renderProperty((Widget)composite, PROP_SHOW_FOCUSED_CONTROL, composite.getShowFocusedControl(), false);
        WidgetLCAUtil.renderProperty((Widget)composite, PROP_SCROLLBARS_VISIBLE, ScrolledCompositeLCA.getScrollBarsVisible(composite), DEFAULT_SCROLLBARS_VISIBLE);
        WidgetLCAUtil.renderListener(composite, PROP_SCROLLBARS_SELECTION_LISTENER, ScrolledCompositeLCA.hasScrollBarsSelectionListener(composite), false);
    }

    public void renderDispose(Widget widget) throws IOException {
        ClientObjectFactory.getForWidget(widget).destroy();
    }

    private static boolean[] getScrollBarsVisible(ScrolledComposite composite) {
        return new boolean[]{ScrolledCompositeLCA.hasHScrollBar(composite), ScrolledCompositeLCA.hasVScrollBar(composite)};
    }

    private static boolean hasHScrollBar(ScrolledComposite composite) {
        ScrollBar horizontalBar = composite.getHorizontalBar();
        return horizontalBar != null && horizontalBar.getVisible();
    }

    private static boolean hasVScrollBar(ScrolledComposite composite) {
        ScrollBar verticalBar = composite.getVerticalBar();
        return verticalBar != null && verticalBar.getVisible();
    }

    private static boolean hasScrollBarsSelectionListener(ScrolledComposite composite) {
        ScrollBar verticalBar;
        boolean result = false;
        ScrollBar horizontalBar = composite.getHorizontalBar();
        if (horizontalBar != null) {
            boolean bl = result = result || SelectionEvent.hasListener(horizontalBar);
        }
        if ((verticalBar = composite.getVerticalBar()) != null) {
            result = result || SelectionEvent.hasListener(verticalBar);
        }
        return result;
    }

    private static void processSelection(ScrollBar scrollBar) {
        SelectionEvent evt = new SelectionEvent(scrollBar, null, 13);
        evt.stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
        evt.processEvent();
    }
}

