/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import java.io.InputStream;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.application.RWTFactory;
import org.eclipse.rwt.internal.util.ClassUtil;
import org.eclipse.rwt.internal.util.SharedInstanceBuffer;
import org.eclipse.rwt.internal.util.StreamUtil;
import org.eclipse.rwt.resources.IResourceManager;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.graphics.InternalImage;
import org.eclipse.swt.internal.graphics.InternalImageFactory;

public class ImageFactory {
    private final SharedInstanceBuffer<String, Image> cache = new SharedInstanceBuffer();

    public static String getImagePath(Image image) {
        String result = null;
        if (image != null) {
            String resourceName = image.internalImage.getResourceName();
            result = RWT.getResourceManager().getLocation(resourceName);
        }
        return result;
    }

    public Image findImage(String path) {
        return this.findImage(path, RWT.getResourceManager().getContextLoader());
    }

    public Image findImage(final String path, final ClassLoader imageLoader) {
        return this.cache.get(path, new SharedInstanceBuffer.IInstanceCreator<Image>(){

            @Override
            public Image createInstance() {
                return ImageFactory.this.createImage(path, imageLoader);
            }
        });
    }

    public Image findImage(final String path, final InputStream inputStream) {
        return this.cache.get(path, new SharedInstanceBuffer.IInstanceCreator<Image>(){

            @Override
            public Image createInstance() {
                return ImageFactory.this.createImage(null, path, inputStream);
            }
        });
    }

    public Image createImage(Device device, String key, InputStream inputStream) {
        InternalImageFactory internalImageFactory = RWTFactory.getInternalImageFactory();
        InternalImage internalImage = internalImageFactory.findInternalImage(key, inputStream);
        return ImageFactory.createImageInstance(device, internalImage);
    }

    private Image createImage(String path, ClassLoader imageLoader) {
        InputStream inputStream = ImageFactory.getInputStream(path, imageLoader);
        Image result = this.createImage(null, path, inputStream);
        StreamUtil.close(inputStream);
        return result;
    }

    private static Image createImageInstance(Device device, InternalImage internalImage) {
        Class[] paramTypes = new Class[]{Device.class, InternalImage.class};
        Object[] paramValues = new Object[]{device, internalImage};
        return (Image)ClassUtil.newInstance(Image.class, paramTypes, paramValues);
    }

    private static InputStream getInputStream(String path, ClassLoader imageLoader) {
        InputStream result;
        IResourceManager manager = RWT.getResourceManager();
        ClassLoader bufferedContextLoader = manager.getContextLoader();
        if (imageLoader != null) {
            manager.setContextLoader(imageLoader);
        }
        try {
            result = manager.getResourceAsStream(path);
        }
        finally {
            manager.setContextLoader(bufferedContextLoader);
        }
        return result;
    }
}

