/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class ItemLCAUtil {
    private static final String PROP_TEXT = "text";
    private static final String PROP_IMAGE = "image";

    private ItemLCAUtil() {
    }

    public static void preserve(Item item) {
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_TEXT, item.getText());
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_IMAGE, item.getImage());
    }

    public static void renderChanges(Item item) {
        WidgetLCAUtil.renderProperty((Widget)item, PROP_TEXT, item.getText(), "");
        WidgetLCAUtil.renderProperty((Widget)item, PROP_IMAGE, item.getImage(), null);
    }

    public static void writeText(Item item, boolean escapeMnemonics, boolean replaceNewLines) throws IOException {
        String text = item.getText();
        if (WidgetLCAUtil.hasChanged(item, PROP_TEXT, text)) {
            JSWriter writer = JSWriter.getWriterFor(item);
            text = WidgetLCAUtil.escapeText(text, escapeMnemonics);
            if (replaceNewLines) {
                text = WidgetLCAUtil.replaceNewLines(text, "<br/>");
            }
            writer.set("label", text);
        }
    }

    public static void writeImage(Item item) throws IOException {
        WidgetLCAUtil.writeImage(item, PROP_IMAGE, "icon", item.getImage());
    }

    public static void writeChanges(Item item) throws IOException {
        ItemLCAUtil.writeText(item, false, false);
        ItemLCAUtil.writeImage(item);
    }
}

