/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.swt.internal.widgets.IRichTextParserCallback;
import org.eclipse.swt.internal.widgets.RichTextParserException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class RichTextParser {
    private static final SAXParserFactory SAX_PARSER_FACTORY = SAXParserFactory.newInstance();
    private final IRichTextParserCallback callback;
    private final SAXParser saxParser;

    public static boolean isRichText(String text) {
        return text.startsWith("<html>");
    }

    public RichTextParser(IRichTextParserCallback callback) {
        this.callback = callback;
        this.saxParser = RichTextParser.createSaxParser();
    }

    public void parse(String richText) {
        InputSource inputSource = new InputSource(new StringReader(richText));
        try {
            this.saxParser.parse(inputSource, (DefaultHandler)new RichTextHandler(this.callback));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RichTextParserException("Failed to parse rich text.", e);
        }
    }

    private static SAXParser createSaxParser() {
        try {
            return SAX_PARSER_FACTORY.newSAXParser();
        }
        catch (Exception e) {
            throw new RichTextParserException("Failed to create SAX parser.", e);
        }
    }

    private static class RichTextHandler
    extends DefaultHandler {
        private static final String ELEM_HTML = "html";
        private static final String ELEM_LINE_BREAK = "br";
        private static final String ELEM_FONT = "font";
        private static final String ATTR_FONT_NAME = "name";
        private static final String ATTR_FONT_HEIGHT = "height";
        private static final String ATTR_IMAGE_SRC = "src";
        private static final String ELEM_IMAGE = "img";
        private final IRichTextParserCallback callback;

        RichTextHandler(IRichTextParserCallback callback) {
            this.callback = callback;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (ELEM_HTML.equals(qName)) {
                this.callback.beginHtml();
            } else if (ELEM_FONT.equals(qName)) {
                String fontName = RichTextHandler.getFontName(attributes);
                int fontHeight = RichTextHandler.getFontHeight(attributes);
                this.callback.beginFont(fontName, fontHeight);
            } else if (ELEM_IMAGE.equals(qName)) {
                this.callback.image(RichTextHandler.getImageSrc(attributes));
            } else if (!ELEM_LINE_BREAK.equals(qName)) {
                throw new RichTextParserException("Unsupported element: " + qName);
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (ELEM_HTML.equals(qName)) {
                this.callback.endHtml();
            } else if (ELEM_LINE_BREAK.equals(qName)) {
                this.callback.lineBreak();
            } else if (ELEM_FONT.equals(qName)) {
                this.callback.endFont();
            }
        }

        public void characters(char[] ch, int start, int length) {
            this.callback.text(new String(ch, start, length));
        }

        private static String getImageSrc(Attributes attributes) {
            return attributes.getValue(ATTR_IMAGE_SRC);
        }

        private static String getFontName(Attributes attributes) {
            return attributes.getValue(ATTR_FONT_NAME);
        }

        private static int getFontHeight(Attributes attributes) {
            String value = attributes.getValue(ATTR_FONT_HEIGHT);
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                throw new RichTextParserException("Invalid font height: " + value, nfe);
            }
        }
    }
}

