/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.menuitemkit;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.internal.widgets.menuitemkit.MenuItemDelegateLCA;
import org.eclipse.swt.internal.widgets.menuitemkit.MenuItemLCAUtil;
import org.eclipse.swt.widgets.MenuItem;

final class BarMenuItemLCA
extends MenuItemDelegateLCA {
    private static final String ITEM_TYPE_BAR = "bar";

    BarMenuItemLCA() {
    }

    void preserveValues(MenuItem menuItem) {
        ItemLCAUtil.preserve(menuItem);
        MenuItemLCAUtil.preserveEnabled(menuItem);
        WidgetLCAUtil.preserveCustomVariant(menuItem);
        WidgetLCAUtil.preserveHelpListener(menuItem);
    }

    void readData(MenuItem menuItem) {
        WidgetLCAUtil.processHelp(menuItem);
    }

    void renderInitialization(MenuItem menuItem) throws IOException {
        MenuItemLCAUtil.newItem(menuItem, "org.eclipse.rwt.widgets.MenuItem", ITEM_TYPE_BAR);
    }

    void renderChanges(MenuItem menuItem) throws IOException {
        BarMenuItemLCA.writeText(menuItem);
        MenuItemLCAUtil.writeEnabled(menuItem);
        WidgetLCAUtil.writeCustomVariant(menuItem);
        WidgetLCAUtil.writeHelpListener(menuItem);
    }

    private static void writeText(MenuItem menuItem) throws IOException {
        String text = menuItem.getText();
        if (WidgetLCAUtil.hasChanged(menuItem, "text", text)) {
            JSWriter writer = JSWriter.getWriterFor(menuItem);
            text = WidgetLCAUtil.escapeText(text, true);
            writer.set("text", text);
        }
    }
}

