/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tablekit;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.theme.JsonArray;
import org.eclipse.rwt.internal.theme.JsonObject;
import org.eclipse.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSVar;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.CellToolTipUtil;
import org.eclipse.swt.internal.widgets.ICellToolTipAdapter;
import org.eclipse.swt.internal.widgets.ICellToolTipProvider;
import org.eclipse.swt.internal.widgets.ITableAdapter;
import org.eclipse.swt.internal.widgets.tablekit.TableLCAUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public final class TableLCA
extends AbstractWidgetLCA {
    static final String PROP_HEADER_HEIGHT = "headerHeight";
    static final String PROP_HEADER_VISIBLE = "headerVisible";
    static final String PROP_LINES_VISIBLE = "linesVisible";
    static final String PROP_FIXED_COLUMNS = "fixedColumns";
    static final String PROP_ITEM_HEIGHT = "itemHeight";
    static final String PROP_COLUMN_COUNT = "columnCount";
    static final String PROP_TOP_ITEM_INDEX = "topIndex";
    static final String PROP_SELECTION_LISTENERS = "selectionListeners";
    static final String PROP_DEFAULT_COLUMN_WIDTH = "defaultColumnWidth";
    static final String PROP_ITEM_COUNT = "itemCount";
    static final String PROP_ALWAYS_HIDE_SELECTION = "alwaysHideSelection";
    static final String PROP_HAS_H_SCROLL_BAR = "hasHScrollBar";
    static final String PROP_HAS_V_SCROLL_BAR = "hasVScrollBar";
    static final String PROP_LEFT_OFFSET = "leftOffset";
    static final String PROP_SCROLLBARS_SELECTION_LISTENER = "scrollBarsSelectionListeners";
    static final String PROP_ENABLE_CELL_TOOLTIP = "enableCellToolTip";
    private static final Integer DEFAULT_TOP_INDEX = new Integer(0);
    private static final Integer DEFAULT_ITEM_COUNT = new Integer(0);
    private static final Integer DEFAUT_ITEM_HEIGHT = new Integer(0);
    private static final Integer DEFAULT_LEFT_OFFSET = new Integer(0);
    private static final Integer DEFAULT_COLUMN_COUNT = new Integer(0);

    public void preserveValues(Widget widget) {
        Table table = (Table)widget;
        ControlLCAUtil.preserveValues(table);
        IWidgetAdapter adapter = WidgetUtil.getAdapter(table);
        adapter.preserve(PROP_HEADER_HEIGHT, new Integer(table.getHeaderHeight()));
        adapter.preserve(PROP_HEADER_VISIBLE, table.getHeaderVisible());
        adapter.preserve(PROP_LINES_VISIBLE, table.getLinesVisible());
        adapter.preserve(PROP_ITEM_HEIGHT, new Integer(table.getItemHeight()));
        adapter.preserve(PROP_FIXED_COLUMNS, widget.getData(PROP_FIXED_COLUMNS));
        adapter.preserve(PROP_COLUMN_COUNT, new Integer(table.getColumnCount()));
        TableLCAUtil.preserveItemMetrics(table);
        adapter.preserve(PROP_ITEM_COUNT, new Integer(table.getItemCount()));
        adapter.preserve(PROP_TOP_ITEM_INDEX, new Integer(table.getTopIndex()));
        adapter.preserve(PROP_SELECTION_LISTENERS, SelectionEvent.hasListener(table));
        TableLCAUtil.preserveFocusIndex(table);
        WidgetLCAUtil.preserveCustomVariant(table);
        adapter.preserve(PROP_ALWAYS_HIDE_SELECTION, TableLCA.hasAlwaysHideSelection(table));
        adapter.preserve(PROP_HAS_H_SCROLL_BAR, TableLCA.hasHScrollBar(table));
        adapter.preserve(PROP_HAS_V_SCROLL_BAR, TableLCA.hasVScrollBar(table));
        adapter.preserve(PROP_LEFT_OFFSET, TableLCA.getLeftOffset(table));
        adapter.preserve(PROP_SCROLLBARS_SELECTION_LISTENER, TableLCA.hasScrollBarsSelectionListener(table));
        adapter.preserve(PROP_ENABLE_CELL_TOOLTIP, new Boolean(CellToolTipUtil.isEnabledFor(table)));
    }

    public void readData(Widget widget) {
        Table table = (Table)widget;
        TableLCA.readTopItemIndex(table);
        TableLCA.readScrollLeft(table);
        TableLCA.readSelection(table);
        TableLCA.readFocusIndex(table);
        TableLCA.readWidgetSelected(table);
        TableLCA.readWidgetDefaultSelected(table);
        TableLCA.readCellToolTipTextRequested(table);
        ControlLCAUtil.processMouseEvents(table);
        ControlLCAUtil.processKeyEvents(table);
        ControlLCAUtil.processMenuDetect(table);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Table table = (Table)widget;
        ITableAdapter adapter = table.getAdapter(ITableAdapter.class);
        JSWriter writer = JSWriter.getWriterFor(table);
        JsonObject argsMap = new JsonObject();
        argsMap.append("appearance", "table");
        argsMap.append("fullSelection", true);
        if ((table.getStyle() & 0x10) != 0) {
            argsMap.append("noScroll", true);
        }
        if ((table.getStyle() & 2) != 0) {
            argsMap.append("multiSelection", true);
        }
        if ((table.getStyle() & 0x8000) != 0) {
            argsMap.append("hideSelection", true);
        }
        if ((table.getStyle() & 0x10000000) != 0) {
            argsMap.append("virtual", true);
        }
        if ((table.getStyle() & 0x20) != 0) {
            int[] checkMetrics = new int[]{adapter.getCheckLeft(), adapter.getCheckWidth()};
            argsMap.append("check", true);
            argsMap.append("checkBoxMetrics", JsonArray.valueOf(checkMetrics));
        }
        argsMap.append("indentionWidth", 0);
        Integer fixedColumns = (Integer)widget.getData(PROP_FIXED_COLUMNS);
        if (fixedColumns != null) {
            argsMap.append("splitContainer", true);
        }
        Object[] args = new Object[]{new JSVar(argsMap.toString())};
        writer.newWidget("org.eclipse.rwt.widgets.Tree", args);
        ControlLCAUtil.writeStyleFlags(table);
        writer.set("treeColumn", -1);
    }

    public void renderChanges(Widget widget) throws IOException {
        Table table = (Table)widget;
        TableLCA.writeItemCount(table);
        ControlLCAUtil.writeChanges(table);
        TableLCA.writeItemHeight(table);
        TableLCAUtil.writeItemMetrics(table);
        TableLCA.writeColumnCount(table);
        TableLCA.writeLinesVisible(table);
        TableLCA.writeFixedColumns(table);
        TableLCA.writeTopIndex(table);
        TableLCA.writeScrollBarsVisible(table);
        this.writeAlwaysHideSelection(table);
        TableLCA.writeSelectionListener(table);
        TableLCA.writeScrollBarsSelectionListener(table);
        TableLCA.writeHeaderHeight(table);
        TableLCA.writeHeaderVisible(table);
        TableLCA.writeFocusItem(table);
        TableLCA.writeLeftOffset(table);
        TableLCA.writeEnableCellToolTip(table);
        TableLCA.writeCellToolTipText(table);
        WidgetLCAUtil.writeCustomVariant(table);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    public void doRedrawFake(Control control) {
        ITableAdapter adapter;
        Table table = (Table)control;
        ITableAdapter tableAdapter = adapter = table.getAdapter(ITableAdapter.class);
        tableAdapter.checkData();
    }

    private static void readSelection(Table table) {
        String value = WidgetLCAUtil.readPropertyValue(table, "selection");
        if (value != null) {
            int[] newSelection;
            if ("".equals(value)) {
                newSelection = new int[]{};
            } else {
                String[] selectedItems = value.split(",");
                newSelection = new int[selectedItems.length];
                int i = 0;
                while (i < selectedItems.length) {
                    TableItem item = null;
                    String itemId = selectedItems[i];
                    item = TableLCA.getItem(table, itemId);
                    newSelection[i] = table.indexOf(item);
                    ++i;
                }
            }
            table.deselectAll();
            table.select(newSelection);
        }
    }

    private static void readTopItemIndex(Table table) {
        String value = WidgetLCAUtil.readPropertyValue(table, "topItemIndex");
        if (value != null) {
            int topIndex = NumberFormatUtil.parseInt(value);
            int topOffset = topIndex * table.getItemHeight();
            table.setTopIndex(topIndex);
            TableLCA.processScrollBarSelection(table.getVerticalBar(), topOffset);
        }
    }

    private static void readFocusIndex(Table table) {
        String value = WidgetLCAUtil.readPropertyValue(table, "focusItem");
        if (value != null) {
            TableItem item = TableLCA.getItem(table, value);
            ITableAdapter adapter = table.getAdapter(ITableAdapter.class);
            adapter.setFocusIndex(table.indexOf(item));
        }
    }

    private static void readScrollLeft(Table table) {
        String value = WidgetLCAUtil.readPropertyValue(table, "scrollLeft");
        if (value != null) {
            ITableAdapter adapter;
            int leftOffset = NumberFormatUtil.parseInt(value);
            ITableAdapter tableAdapter = adapter = table.getAdapter(ITableAdapter.class);
            tableAdapter.setLeftOffset(leftOffset);
            TableLCA.processScrollBarSelection(table.getHorizontalBar(), leftOffset);
        }
    }

    private static void readWidgetSelected(Table table) {
        HttpServletRequest request;
        String selectionId;
        TableItem item;
        if (WidgetLCAUtil.wasEventSent(table, "org.eclipse.swt.events.widgetSelected") && (item = TableLCA.getItem(table, selectionId = (request = ContextProvider.getRequest()).getParameter("org.eclipse.swt.events.widgetSelected.item"))) != null) {
            int detail = TableLCA.getWidgetSelectedDetail();
            int id = 13;
            Rectangle bounds = new Rectangle(0, 0, 0, 0);
            int stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
            SelectionEvent event = new SelectionEvent(table, item, id, bounds, stateMask, "", true, detail);
            event.processEvent();
        }
    }

    private static void readWidgetDefaultSelected(Table table) {
        String defaultSelectedParam = "org.eclipse.swt.events.widgetDefaultSelected";
        if (WidgetLCAUtil.wasEventSent(table, defaultSelectedParam)) {
            TableItem item = TableLCA.getFocusedItem(table);
            HttpServletRequest request = ContextProvider.getRequest();
            String selectionId = request.getParameter(String.valueOf(defaultSelectedParam) + ".item");
            TableItem selectedItem = TableLCA.getItem(table, selectionId);
            if (selectedItem != null) {
                item = selectedItem;
            }
            int id = 14;
            SelectionEvent event = new SelectionEvent(table, item, id);
            event.stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
            event.processEvent();
        }
    }

    private static int getWidgetSelectedDetail() {
        HttpServletRequest request = ContextProvider.getRequest();
        String value = request.getParameter("org.eclipse.swt.events.widgetSelected.detail");
        return "check".equals(value) ? 32 : 0;
    }

    private static TableItem getFocusedItem(Table table) {
        TableItem result = null;
        ITableAdapter tableAdapter = table.getAdapter(ITableAdapter.class);
        int focusIndex = tableAdapter.getFocusIndex();
        if (focusIndex != -1) {
            result = table.getItem(focusIndex);
        }
        return result;
    }

    private static void writeHeaderHeight(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(table);
        Integer newValue = new Integer(table.getHeaderHeight());
        writer.set(PROP_HEADER_HEIGHT, PROP_HEADER_HEIGHT, newValue, null);
    }

    private static void writeHeaderVisible(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(table);
        Boolean newValue = table.getHeaderVisible();
        writer.set(PROP_HEADER_VISIBLE, PROP_HEADER_VISIBLE, newValue, Boolean.FALSE);
    }

    private static void writeItemHeight(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(table);
        Integer newValue = new Integer(table.getItemHeight());
        writer.set(PROP_ITEM_HEIGHT, PROP_ITEM_HEIGHT, newValue, DEFAUT_ITEM_HEIGHT);
    }

    private static void writeColumnCount(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(table);
        Integer newValue = new Integer(table.getColumnCount());
        if (WidgetLCAUtil.hasChanged(table, PROP_COLUMN_COUNT, newValue)) {
            writer.set(PROP_COLUMN_COUNT, PROP_COLUMN_COUNT, newValue, DEFAULT_COLUMN_COUNT);
        }
    }

    private static void writeItemCount(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(table);
        Integer newValue = new Integer(table.getItemCount());
        writer.set(PROP_ITEM_COUNT, PROP_ITEM_COUNT, newValue, DEFAULT_ITEM_COUNT);
    }

    private static void writeTopIndex(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(table);
        Integer newValue = new Integer(table.getTopIndex());
        writer.set(PROP_TOP_ITEM_INDEX, "topItemIndex", newValue, DEFAULT_TOP_INDEX);
    }

    private static void writeFocusItem(Table table) throws IOException {
        ITableAdapter adapter;
        if (TableLCAUtil.hasFocusIndexChanged(table) && (adapter = table.getAdapter(ITableAdapter.class)).getFocusIndex() == -1) {
            JSWriter writer = JSWriter.getWriterFor(table);
            writer.set("focusItem", new Object[1]);
        }
    }

    private static void writeLinesVisible(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(table);
        Boolean newValue = table.getLinesVisible();
        writer.set(PROP_LINES_VISIBLE, PROP_LINES_VISIBLE, newValue, Boolean.FALSE);
    }

    private static void writeFixedColumns(Table table) throws IOException {
        Integer newValue = (Integer)table.getData(PROP_FIXED_COLUMNS);
        if (WidgetLCAUtil.hasChanged(table, PROP_FIXED_COLUMNS, newValue, null)) {
            JSWriter writer = JSWriter.getWriterFor(table);
            Object[] args = new Object[]{table, newValue};
            writer.callStatic("org.eclipse.rwt.TreeUtil.setFixedColumns", args);
        }
    }

    private void writeAlwaysHideSelection(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(table);
        Boolean newValue = TableLCA.hasAlwaysHideSelection(table);
        writer.set(PROP_ALWAYS_HIDE_SELECTION, PROP_ALWAYS_HIDE_SELECTION, newValue, Boolean.FALSE);
    }

    private static void writeSelectionListener(Table table) throws IOException {
        String prop = PROP_SELECTION_LISTENERS;
        Boolean newValue = SelectionEvent.hasListener(table);
        if (WidgetLCAUtil.hasChanged(table, prop, newValue, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor(table);
            writer.set("hasSelectionListener", newValue);
        }
    }

    private static void writeScrollBarsSelectionListener(Table table) throws IOException {
        String prop = PROP_SCROLLBARS_SELECTION_LISTENER;
        Boolean newValue = TableLCA.hasScrollBarsSelectionListener(table);
        if (WidgetLCAUtil.hasChanged(table, prop, newValue, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor(table);
            writer.set("hasScrollBarsSelectionListener", newValue);
        }
    }

    private static void writeScrollBarsVisible(Table table) throws IOException {
        boolean hasHChanged = WidgetLCAUtil.hasChanged(table, PROP_HAS_H_SCROLL_BAR, TableLCA.hasHScrollBar(table), Boolean.FALSE);
        boolean hasVChanged = WidgetLCAUtil.hasChanged(table, PROP_HAS_V_SCROLL_BAR, TableLCA.hasVScrollBar(table), Boolean.FALSE);
        if (hasHChanged || hasVChanged) {
            JSWriter writer = JSWriter.getWriterFor(table);
            Object[] args = new Object[]{TableLCA.hasHScrollBar(table), TableLCA.hasVScrollBar(table)};
            writer.set("scrollBarsVisible", args);
        }
    }

    private static void writeLeftOffset(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(table);
        Integer newValue = TableLCA.getLeftOffset(table);
        writer.set(PROP_LEFT_OFFSET, "scrollLeft", newValue, DEFAULT_LEFT_OFFSET);
    }

    private static void writeEnableCellToolTip(Table table) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(table);
        Boolean newValue = new Boolean(CellToolTipUtil.isEnabledFor(table));
        writer.set(PROP_ENABLE_CELL_TOOLTIP, PROP_ENABLE_CELL_TOOLTIP, newValue, Boolean.FALSE);
    }

    private static void readCellToolTipTextRequested(Table table) {
        ICellToolTipProvider provider;
        ICellToolTipAdapter adapter = CellToolTipUtil.getAdapter(table);
        adapter.setCellToolTipText(null);
        if (WidgetLCAUtil.wasEventSent(table, "org.eclipse.swt.events.cellToolTipTextRequested") && (provider = adapter.getCellToolTipProvider()) != null) {
            HttpServletRequest request = ContextProvider.getRequest();
            String cell = request.getParameter("org.eclipse.swt.events.cellToolTipTextRequested.cell");
            String[] details = cell.split(",");
            String itemId = details[0];
            int columnIndex = NumberFormatUtil.parseInt(details[1]);
            TableItem item = TableLCA.getItem(table, itemId);
            if (item != null && (columnIndex == 0 || columnIndex < table.getColumnCount())) {
                provider.getToolTipText(item, columnIndex);
            }
        }
    }

    private static void writeCellToolTipText(Table table) throws IOException {
        ICellToolTipAdapter adapter = CellToolTipUtil.getAdapter(table);
        String text = adapter.getCellToolTipText();
        if (text != null) {
            JSWriter writer = JSWriter.getWriterFor(table);
            text = WidgetLCAUtil.escapeText(text, false);
            text = WidgetLCAUtil.replaceNewLines(text, "<br/>");
            writer.call("setCellToolTipText", new String[]{text});
        }
    }

    private static TableItem getItem(Table table, String itemId) {
        TableItem item;
        String[] idParts = itemId.split("#");
        if (idParts.length == 2) {
            int index = Integer.parseInt(idParts[1]);
            item = table.getItem(index);
        } else {
            item = (TableItem)WidgetUtil.find(table, itemId);
        }
        return item;
    }

    private static Boolean hasHScrollBar(Table table) {
        ITableAdapter adapter;
        ITableAdapter tableAdapter = adapter = table.getAdapter(ITableAdapter.class);
        return tableAdapter.hasHScrollBar();
    }

    private static Boolean hasVScrollBar(Table table) {
        ITableAdapter adapter;
        ITableAdapter tableAdapter = adapter = table.getAdapter(ITableAdapter.class);
        return tableAdapter.hasVScrollBar();
    }

    private static Integer getLeftOffset(Table table) {
        ITableAdapter adapter;
        ITableAdapter tableAdapter = adapter = table.getAdapter(ITableAdapter.class);
        return new Integer(tableAdapter.getLeftOffset());
    }

    private static Boolean hasScrollBarsSelectionListener(Table table) {
        ScrollBar verticalBar;
        boolean result = false;
        ScrollBar horizontalBar = table.getHorizontalBar();
        if (horizontalBar != null) {
            boolean bl = result = result || SelectionEvent.hasListener(horizontalBar);
        }
        if ((verticalBar = table.getVerticalBar()) != null) {
            result = result || SelectionEvent.hasListener(verticalBar);
        }
        return result;
    }

    private static void processScrollBarSelection(ScrollBar scrollBar, int selection) {
        if (scrollBar != null) {
            scrollBar.setSelection(selection);
            if (SelectionEvent.hasListener(scrollBar)) {
                SelectionEvent evt = new SelectionEvent(scrollBar, null, 13);
                evt.stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
                evt.processEvent();
            }
        }
    }

    static Boolean hasAlwaysHideSelection(Table table) {
        Boolean result = Boolean.FALSE;
        Object data = table.getData(Table.ALWAYS_HIDE_SELECTION);
        if (Boolean.TRUE.equals(data)) {
            result = Boolean.TRUE;
        }
        return result;
    }
}

