/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.textkit;

import java.io.IOException;
import org.eclipse.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rwt.internal.protocol.IClientObject;
import org.eclipse.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.widgets.ITextAdapter;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

final class TextLCAUtil {
    private static final String TYPE = "rwt.widgets.Text";
    static final String PROP_TEXT = "text";
    static final String PROP_TEXT_LIMIT = "textLimit";
    static final String PROP_SELECTION = "selection";
    static final String PROP_EDITABLE = "editable";
    static final String PROP_ECHO_CHAR = "echoChar";
    static final String PROP_MESSAGE = "message";
    static final String PROP_MODIFY_LISTENER = "modify";
    static final String PROP_VERIFY_LISTENER = "verify";
    static final String PROP_SELECTION_LISTENER = "selection";
    private static final Point DEFAULT_SELECTION = new Point(0, 0);

    private TextLCAUtil() {
    }

    static void preserveValues(Text text) {
        ControlLCAUtil.preserveValues(text);
        WidgetLCAUtil.preserveCustomVariant(text);
        WidgetLCAUtil.preserveProperty((Widget)text, PROP_TEXT, text.getText());
        WidgetLCAUtil.preserveProperty((Widget)text, "selection", text.getSelection());
        WidgetLCAUtil.preserveProperty((Widget)text, PROP_TEXT_LIMIT, TextLCAUtil.getTextLimit(text));
        WidgetLCAUtil.preserveProperty((Widget)text, PROP_EDITABLE, text.getEditable());
        WidgetLCAUtil.preserveProperty((Widget)text, PROP_ECHO_CHAR, TextLCAUtil.getEchoChar(text));
        WidgetLCAUtil.preserveProperty((Widget)text, PROP_MESSAGE, text.getMessage());
        WidgetLCAUtil.preserveListener(text, PROP_MODIFY_LISTENER, ModifyEvent.hasListener(text));
        WidgetLCAUtil.preserveListener(text, PROP_VERIFY_LISTENER, VerifyEvent.hasListener(text));
        WidgetLCAUtil.preserveListener(text, "selection", SelectionEvent.hasListener(text));
    }

    static void renderInitialization(Text text) {
        IClientObject clientObject = ClientObjectFactory.getForWidget(text);
        clientObject.create(TYPE);
        clientObject.setProperty("parent", WidgetUtil.getId(text.getParent()));
        clientObject.setProperty("style", WidgetLCAUtil.getStyles(text));
    }

    static void renderChanges(Text text) throws IOException {
        ControlLCAUtil.renderChanges(text);
        WidgetLCAUtil.renderCustomVariant(text);
        WidgetLCAUtil.renderProperty((Widget)text, PROP_TEXT, text.getText(), "");
        WidgetLCAUtil.renderProperty((Widget)text, PROP_EDITABLE, text.getEditable(), true);
        WidgetLCAUtil.renderProperty((Widget)text, "selection", text.getSelection(), DEFAULT_SELECTION);
        WidgetLCAUtil.renderProperty((Widget)text, PROP_TEXT_LIMIT, TextLCAUtil.getTextLimit(text), null);
        WidgetLCAUtil.renderProperty((Widget)text, PROP_ECHO_CHAR, TextLCAUtil.getEchoChar(text), null);
        WidgetLCAUtil.renderProperty((Widget)text, PROP_MESSAGE, text.getMessage(), "");
        WidgetLCAUtil.renderListener(text, PROP_MODIFY_LISTENER, ModifyEvent.hasListener(text), false);
        WidgetLCAUtil.renderListener(text, PROP_VERIFY_LISTENER, VerifyEvent.hasListener(text), false);
        WidgetLCAUtil.renderListener(text, "selection", SelectionEvent.hasListener(text), false);
    }

    static void readTextAndSelection(final Text text) {
        final Point selection = TextLCAUtil.readSelection(text);
        final String txt = WidgetLCAUtil.readPropertyValue(text, PROP_TEXT);
        if (txt != null) {
            if (VerifyEvent.hasListener(text)) {
                ProcessActionRunner.add(new Runnable(){

                    public void run() {
                        ITextAdapter textAdapter = text.getAdapter(ITextAdapter.class);
                        textAdapter.setText(txt, selection);
                        IWidgetAdapter adapter = WidgetUtil.getAdapter(text);
                        adapter.preserve(TextLCAUtil.PROP_TEXT, txt);
                        if (selection != null) {
                            adapter.preserve("selection", selection);
                        }
                    }
                });
            } else {
                text.setText(txt);
                if (selection != null) {
                    text.setSelection(selection);
                }
            }
        } else if (selection != null) {
            text.setSelection(selection);
        }
    }

    private static Point readSelection(Text text) {
        Point result = null;
        String selStart = WidgetLCAUtil.readPropertyValue(text, "selectionStart");
        String selLength = WidgetLCAUtil.readPropertyValue(text, "selectionLength");
        if (selStart != null || selLength != null) {
            result = new Point(0, 0);
            if (selStart != null) {
                result.x = NumberFormatUtil.parseInt(selStart);
            }
            if (selLength != null) {
                result.y = result.x + NumberFormatUtil.parseInt(selLength);
            }
        }
        return result;
    }

    private static Integer getTextLimit(Text text) {
        Integer result = null;
        int textLimit = text.getTextLimit();
        if (textLimit > 0 && textLimit != Integer.MAX_VALUE) {
            result = new Integer(textLimit);
        }
        return result;
    }

    private static String getEchoChar(Text text) {
        return text.getEchoChar() == '\u0000' ? null : String.valueOf(text.getEchoChar());
    }
}

