/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.internal.theme.IThemeAdapter;
import org.eclipse.rwt.theme.IControlThemeAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.DragDetectEvent;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TouchListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.ShowEvent;
import org.eclipse.swt.internal.widgets.IControlAdapter;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ControlHolder;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Control
extends Widget
implements Drawable {
    private transient IControlAdapter controlAdapter;
    final Composite parent;
    private int tabIndex;
    Rectangle bounds;
    private Object layoutData;
    private String toolTipText;
    private Menu menu;
    private DisposeListener menuDisposeListener;
    private Color foreground;
    private Color background;
    private Image backgroundImage;
    private boolean backgroundTransparency;
    private Font font;
    private Cursor cursor;
    private Rectangle bufferedPadding;
    private transient Accessible accessible;
    private boolean packed;

    Control(Composite parent) {
        this.parent = parent;
        this.bounds = new Rectangle(0, 0, 0, 0);
        this.tabIndex = -1;
    }

    public Control(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.controlAdapter = new ControlAdapter();
        this.bounds = new Rectangle(0, 0, 0, 0);
        this.tabIndex = -1;
        ControlHolder.addControl(parent, this);
        this.createWidget();
    }

    void createWidget() {
        this.initState();
        this.checkOrientation(this.parent);
        this.checkBackground();
        this.updateBackground();
    }

    void initState() {
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.internalGetShell();
    }

    Shell internalGetShell() {
        return this.parent.internalGetShell();
    }

    public Monitor getMonitor() {
        this.checkWidget();
        return this.display.getPrimaryMonitor();
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if ((this.state & 0x10) != 0 != !visible) {
            if (visible) {
                ShowEvent event = new ShowEvent(this, 22);
                event.processEvent();
            }
            Control control = null;
            boolean fixFocus = false;
            if (!visible) {
                control = this.display.getFocusControl();
                fixFocus = this.isFocusAncestor(control);
            }
            int n = this.state = visible ? this.state & 0xFFFFFFEF : this.state | 0x10;
            if (!visible) {
                ShowEvent event = new ShowEvent(this, 23);
                event.processEvent();
            }
            if (fixFocus) {
                this.fixFocus(control);
            }
        }
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x10) == 0;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.state = enabled ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        this.background = color;
        this.updateBackground();
    }

    public Color getBackground() {
        Color result;
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        if ((result = control.background) == null) {
            IControlThemeAdapter themeAdapter = (IControlThemeAdapter)control.getAdapter(IThemeAdapter.class);
            result = themeAdapter.getBackground(control);
        }
        Shell shell = control.getShell();
        control = control.parent;
        while (result == null && control != null) {
            result = control.getBackground();
            Control control2 = control = control == shell ? null : control.parent;
        }
        if (result == null) {
            throw new IllegalStateException("Transparent shell background color");
        }
        return result;
    }

    public void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (this.backgroundImage != image) {
            this.backgroundImage = image;
        }
    }

    public Image getBackgroundImage() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.backgroundImage;
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        this.foreground = color;
    }

    public Color getForeground() {
        this.checkWidget();
        Color result = this.foreground;
        if (result == null) {
            IControlThemeAdapter themeAdapter = (IControlThemeAdapter)this.getAdapter(IThemeAdapter.class);
            result = themeAdapter.getForeground(this);
        }
        if (result == null) {
            throw new IllegalStateException("Transparent foreground color");
        }
        return result;
    }

    void updateBackgroundMode() {
        int oldState = this.state & 0x400;
        this.checkBackground();
        if (oldState != (this.state & 0x400)) {
            this.updateBackground();
        }
    }

    void checkBackground() {
        Shell shell = this.getShell();
        if (this == shell) {
            return;
        }
        this.state &= 0xFFFFFBFF;
        Composite composite = this.parent;
        while (true) {
            int mode;
            if ((mode = composite.backgroundMode) != 0) {
                if (mode == 1) {
                    Control control = this;
                    do {
                        if ((control.state & 0x100) != 0) continue;
                        return;
                    } while ((control = control.parent) != composite);
                }
                this.state |= 0x400;
                return;
            }
            if (composite == shell) break;
            composite = composite.parent;
        }
    }

    private void updateBackground() {
        this.backgroundTransparency = this.background == null && this.backgroundImage == null && (this.state & 0x400) != 0;
    }

    Control findBackgroundControl() {
        Control result = null;
        if (this.background != null || this.backgroundImage != null) {
            result = this;
        } else if ((this.state & 0x400) != 0) {
            result = this.parent.findBackgroundControl();
        }
        return result;
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        this.font = font;
    }

    public Font getFont() {
        this.checkWidget();
        Font result = this.font;
        if (result == null) {
            IControlThemeAdapter themeAdapter = (IControlThemeAdapter)this.getAdapter(IThemeAdapter.class);
            result = themeAdapter.getFont(this);
        }
        return result;
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            this.error(5);
        }
        this.cursor = cursor;
    }

    public Cursor getCursor() {
        this.checkWidget();
        return this.cursor;
    }

    public boolean setFocus() {
        this.checkWidget();
        boolean result = false;
        if ((this.style & 0x80000) == 0) {
            result = this.forceFocus();
        }
        return result;
    }

    public boolean forceFocus() {
        this.checkWidget();
        Shell shell = this.getShell();
        shell.setSavedFocus(this);
        if (!(this.isEnabled() && this.isVisible() && this.isActive())) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        shell.setSavedFocus(null);
        this.setFocusControl(this);
        if (this.isDisposed()) {
            return false;
        }
        shell.setSavedFocus(this);
        return this.isFocusControl();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        return this == this.getDisplay().getFocusControl();
    }

    boolean setSavedFocus() {
        return this.forceFocus();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return new Rectangle(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
    }

    public void setBounds(Rectangle bounds) {
        this.checkWidget();
        if (bounds == null) {
            SWT.error(4);
        }
        this.setBounds(bounds, true);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.setBounds(new Rectangle(x, y, width, height));
    }

    public void setLocation(Point location) {
        if (location == null) {
            SWT.error(4);
        }
        Rectangle newBounds = new Rectangle(location.x, location.y, this.bounds.width, this.bounds.height);
        this.setBounds(newBounds);
    }

    public void setLocation(int x, int y) {
        this.setLocation(new Point(x, y));
    }

    public Point getLocation() {
        this.checkWidget();
        return new Point(this.bounds.x, this.bounds.y);
    }

    public void setSize(Point size) {
        if (size == null) {
            SWT.error(4);
        }
        this.setBounds(new Rectangle(this.bounds.x, this.bounds.y, size.x, size.y));
    }

    public void setSize(int width, int height) {
        this.setSize(new Point(width, height));
    }

    public Point getSize() {
        this.checkWidget();
        return new Point(this.bounds.width, this.bounds.height);
    }

    public Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 64;
        int height = 64;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    public void pack() {
        this.checkWidget();
        this.pack(true);
    }

    public void pack(boolean changed) {
        this.checkWidget();
        this.setSize(this.computeSize(-1, -1, changed));
        this.packed = true;
    }

    public int getBorderWidth() {
        this.checkWidget();
        IControlThemeAdapter themeAdapter = (IControlThemeAdapter)this.getAdapter(IThemeAdapter.class);
        return themeAdapter.getBorderWidth(this);
    }

    Rectangle getPadding() {
        if (this.bufferedPadding == null) {
            IControlThemeAdapter themeAdapter = (IControlThemeAdapter)this.getAdapter(IThemeAdapter.class);
            this.bufferedPadding = themeAdapter.getPadding(this);
        }
        return this.bufferedPadding;
    }

    public Point toControl(int x, int y) {
        this.checkWidget();
        return this.getDisplay().map(null, this, x, y);
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int x, int y) {
        this.checkWidget();
        return this.getDisplay().map(this, null, x, y);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public void setLayoutData(Object layoutData) {
        this.checkWidget();
        this.layoutData = layoutData;
    }

    void markLayout(boolean changed, boolean all) {
    }

    void updateLayout(boolean resize, boolean all) {
    }

    public void setToolTipText(String toolTipText) {
        this.checkWidget();
        this.toolTipText = toolTipText;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (this.menu != menu) {
            if (menu != null) {
                if (menu.isDisposed()) {
                    SWT.error(5);
                }
                if ((menu.getStyle() & 8) == 0) {
                    SWT.error(37);
                }
                if (menu.getParent() != this.getShell()) {
                    SWT.error(32);
                }
            }
            this.removeMenuDisposeListener();
            this.menu = menu;
            this.addMenuDisposeListener();
        }
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control == null || control.parent == this.parent && control != this) {
            ControlHolder.removeControl(this.getParent(), this);
            int index = 0;
            if (control != null) {
                index = ControlHolder.indexOf(this.getParent(), control);
            }
            ControlHolder.addControl(this.getParent(), this, index);
        }
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control == null || control.parent == this.parent && control != this) {
            ControlHolder.removeControl(this.getParent(), this);
            int index = ControlHolder.size(this.getParent());
            if (control != null) {
                index = ControlHolder.indexOf(this.getParent(), control) + 1;
            }
            ControlHolder.addControl(this.getParent(), this, index);
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        IControlAdapter result = null;
        if (adapter == IControlAdapter.class) {
            if (this.controlAdapter == null) {
                this.controlAdapter = new ControlAdapter();
            }
            result = this.controlAdapter;
        } else {
            result = (IControlAdapter)super.getAdapter(adapter);
        }
        return (T)result;
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        ControlEvent.addListener(this, listener);
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        ControlEvent.removeListener(this, listener);
    }

    public void addMouseListener(MouseListener listener) {
        this.checkWidget();
        MouseEvent.addListener(this, listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.checkWidget();
        MouseEvent.removeListener(this, listener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        KeyEvent.addListener(this, listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        KeyEvent.removeListener(this, listener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.checkWidget();
        TraverseEvent.addListener((Adaptable)this, listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.checkWidget();
        TraverseEvent.removeListener((Adaptable)this, listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.checkWidget();
        FocusEvent.addListener(this, listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.checkWidget();
        FocusEvent.removeListener(this, listener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        HelpEvent.addListener(this, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        HelpEvent.removeListener(this, listener);
    }

    public void addDragDetectListener(DragDetectListener listener) {
        this.checkWidget();
        DragDetectEvent.addListener((Adaptable)this, listener);
    }

    public void removeDragDetectListener(DragDetectListener listener) {
        this.checkWidget();
        DragDetectEvent.removeListener((Adaptable)this, listener);
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        MenuDetectEvent.addListener(this, listener);
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        MenuDetectEvent.removeListener(this, listener);
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        this.internalSetRedraw(redraw);
    }

    public void redraw() {
        this.checkWidget();
        this.internalSetRedraw(true);
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        if (width > 0 && height > 0) {
            this.internalSetRedraw(true);
        }
    }

    void internalSetRedraw(boolean redraw) {
        this.display.redrawControl(this, redraw);
    }

    public void update() {
        this.checkWidget();
    }

    public boolean setParent(Composite parent) {
        this.checkWidget();
        return false;
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x2000000;
    }

    public Accessible getAccessible() {
        this.checkWidget();
        if (this.accessible == null) {
            this.accessible = Accessible.internal_new_Accessible(this);
        }
        return this.accessible;
    }

    public void addGestureListener(GestureListener listener) {
        this.checkWidget();
    }

    public void removeGestureListener(GestureListener listener) {
        this.checkWidget();
    }

    public void addTouchListener(TouchListener listener) {
        this.checkWidget();
    }

    public void removeTouchListener(TouchListener listener) {
        this.checkWidget();
    }

    public void setTouchEnabled(boolean enabled) {
        this.checkWidget();
    }

    public boolean getTouchEnabled() {
        this.checkWidget();
        return false;
    }

    @Override
    void releaseParent() {
        if (this.parent != null) {
            this.parent.removeControl(this);
        }
    }

    @Override
    void releaseWidget() {
        Shell shell;
        if (this.menu != null) {
            this.removeMenuDisposeListener();
            this.menu.dispose();
            this.menu = null;
        }
        if (this.display.getFocusControl() == this) {
            Composite focusControl = null;
            Composite parent = this.parent;
            while (focusControl == null && parent != null) {
                if (!parent.isDisposed()) {
                    focusControl = parent;
                    continue;
                }
                parent = parent.getParent();
            }
            this.setFocusControl(focusControl);
        }
        if ((shell = this.internalGetShell()).getSavedFocus() == this) {
            shell.setSavedFocus(null);
        }
        this.internalSetRedraw(false);
        if (this.accessible != null) {
            this.accessible.internal_dispose_Accessible();
        }
        this.accessible = null;
        super.releaseWidget();
    }

    boolean isTabGroup() {
        boolean result = false;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    result = true;
                }
                ++i;
            }
        }
        return result;
    }

    void setBounds(Rectangle bounds, boolean updateMode) {
        Point oldLocation = this.getLocation();
        Point oldSize = this.getSize();
        this.bounds = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        this.bounds.width = Math.max(0, this.bounds.width);
        this.bounds.height = Math.max(0, this.bounds.height);
        if (updateMode) {
            this.updateMode();
        }
        this.clearPacked(oldSize);
        this.notifyMove(oldLocation);
        this.notifyResize(oldSize);
    }

    void updateMode() {
    }

    private void clearPacked(Point oldSize) {
        if (!oldSize.equals(this.getSize())) {
            this.packed = false;
        }
    }

    void notifyResize(Point oldSize) {
        if (!oldSize.equals(this.getSize())) {
            new ControlEvent(this, 11).processEvent();
        }
    }

    void notifyMove(Point oldLocation) {
        if (!oldLocation.equals(this.getLocation())) {
            new ControlEvent(this, 10).processEvent();
        }
    }

    private void setFocusControl(Control control) {
        if (control != null) {
            this.display.setActiveShell(control.getShell());
        }
        IDisplayAdapter displayAdapter = this.display.getAdapter(IDisplayAdapter.class);
        displayAdapter.setFocusControl(control);
        if (control != null) {
            Shell shell = control.getShell();
            shell.setActiveControl(control);
        }
    }

    Control[] getPath() {
        int count = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++count;
            control = control.parent;
        }
        control = this;
        Control[] result = new Control[count];
        while (control != shell) {
            result[--count] = control;
            control = control.parent;
        }
        return result;
    }

    boolean isFocusAncestor(Control control) {
        while (control != null && control != this && !(control instanceof Shell)) {
            control = control.parent;
        }
        return control == this;
    }

    void fixFocus(Control focusControl) {
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell && (control = control.parent) != null) {
            if (!control.setFixedFocus()) continue;
            return;
        }
        shell.setSavedFocus(focusControl);
        IDisplayAdapter displayAdapter = this.display.getAdapter(IDisplayAdapter.class);
        displayAdapter.setFocusControl(null);
    }

    boolean setFixedFocus() {
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    boolean isActive() {
        Shell shell = this.getShell();
        boolean result = shell.getEnabled();
        Shell[] allShells = this.getDisplay().getShells();
        int bits = 229376;
        int shellIndex = allShells.length;
        int i = 0;
        while (i < allShells.length && result) {
            if (allShells[i] == shell) {
                shellIndex = i;
            }
            if ((allShells[i].style & bits) != 0 && shellIndex < i) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    private void addMenuDisposeListener() {
        if (this.menu != null) {
            if (this.menuDisposeListener == null) {
                this.menuDisposeListener = new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event) {
                        Control.this.menu = null;
                    }
                };
            }
            this.menu.addDisposeListener(this.menuDisposeListener);
        }
    }

    private void removeMenuDisposeListener() {
        if (this.menu != null) {
            this.menu.removeDisposeListener(this.menuDisposeListener);
        }
    }

    private final class ControlAdapter
    implements IControlAdapter {
        private ControlAdapter() {
        }

        public int getZIndex() {
            Composite parent = Control.this.getParent();
            int result = 0;
            if (parent != null) {
                result = ControlHolder.indexOf(parent, Control.this);
            }
            return result;
        }

        public Shell getShell() {
            return Control.this.internalGetShell();
        }

        public int getTabIndex() {
            return Control.this.tabIndex;
        }

        public void setTabIndex(int index) {
            Control.this.tabIndex = index;
        }

        public Font getUserFont() {
            return Control.this.font;
        }

        public Color getUserForeground() {
            Color result = null;
            if (Control.this.isEnabled()) {
                result = Control.this.foreground;
            }
            return result;
        }

        public Color getUserBackground() {
            return Control.this.background;
        }

        public Image getUserBackgroundImage() {
            return Control.this.backgroundImage;
        }

        public boolean getBackgroundTransparency() {
            return Control.this.backgroundTransparency;
        }

        public boolean isPacked() {
            return Control.this.packed;
        }
    }
}

