/*******************************************************************************
 * Copyright (c) 2002, 2011 Innoopract Informationssysteme GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Innoopract Informationssysteme GmbH - initial API and implementation
 *    EclipseSource - ongoing implementation
 *    Frank Appel - replaced singletons and static fields (Bug 337787)
 ******************************************************************************/
package org.eclipse.rwt.internal.service;

import java.io.IOException;

import javax.servlet.ServletException;

import org.eclipse.rwt.service.IServiceHandler;
import org.eclipse.rwt.service.IServiceManager;


public class ServiceManager implements IServiceManager {
  private final ServiceHandlerRegistry customHandlers;
  private final IServiceHandler handlerDispatcher;
  private final IServiceHandler lifeCycleRequestHandler;
  
  private class HandlerDispatcher implements IServiceHandler {
    public void service() throws ServletException, IOException {
      if( isCustomHandler() ) {
        IServiceHandler customHandler = getCustomHandler();
        customHandler.service();
      } else {
        getLifeCycleRequestHandler().service();
      }
    }
  }
  
  public ServiceManager( IServiceHandler lifeCycleRequestHandler ) {
    this.lifeCycleRequestHandler = lifeCycleRequestHandler;
    this.customHandlers = new ServiceHandlerRegistry();
    this.handlerDispatcher = new HandlerDispatcher();
  }
  
  public void registerServiceHandler( String id, IServiceHandler handler ) {
    customHandlers.put( id, handler );
  }

  public void unregisterServiceHandler( String id ) {
    customHandlers.remove( id );
  }
  
  public IServiceHandler getHandler() {
    return handlerDispatcher;
  }

  public void clear() {
    customHandlers.clear();
  }
  
  public IServiceHandler getCustomHandler( String customHandlerId ) {
    return customHandlers.get( customHandlerId );
  }
  
  //////////////////
  // helping methods
  
  private static String getCustomHandlerId() {
    return ContextProvider.getRequest().getParameter( IServiceHandler.REQUEST_PARAM );
  }
  
  private IServiceHandler getLifeCycleRequestHandler() {
    return lifeCycleRequestHandler;
  }

  private boolean isCustomHandler() {
    return customHandlers.isCustomHandler( getCustomHandlerId() );
  }
  
  private IServiceHandler getCustomHandler() {
    return getCustomHandler( getCustomHandlerId() );
  }
}