/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.branding;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.branding.Header;
import org.eclipse.rwt.internal.application.RWTFactory;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.util.URLHelper;

public final class BrandingUtil {
    private static final String ATTR_BRANDING_ID = String.valueOf(BrandingUtil.class.getName()) + "#brandingId";

    public static String headerMarkup(AbstractBranding branding) {
        Header[] headers = branding.getHeaders();
        StringBuilder buffer = new StringBuilder();
        BrandingUtil.appendFavIconMarkup(buffer, branding);
        if (headers != null) {
            int i = 0;
            while (i < headers.length) {
                Header header = headers[i];
                BrandingUtil.appendHeaderMarkup(buffer, header);
                buffer.append("\n");
                ++i;
            }
        }
        return buffer.toString();
    }

    public static AbstractBranding determineBranding() {
        HttpServletRequest request = ContextProvider.getRequest();
        String servletName = URLHelper.getServletName();
        String entryPoint = request.getParameter("startup");
        AbstractBranding result = RWTFactory.getBrandingManager().find(servletName, entryPoint);
        RWT.getSessionStore().setAttribute(ATTR_BRANDING_ID, result.getId());
        return result;
    }

    public static String getCurrentBrandingId() {
        return (String)RWT.getSessionStore().getAttribute(ATTR_BRANDING_ID);
    }

    private static void appendFavIconMarkup(StringBuilder buffer, AbstractBranding branding) {
        String favIcon = branding.getFavIcon();
        if (favIcon != null && !"".equals(favIcon)) {
            String[] names = new String[]{"rel", "type", "href"};
            String favIconUrl = RWT.getResourceManager().getLocation(favIcon);
            String[] values = new String[]{"shortcut icon", "image/x-icon", favIconUrl};
            Header header = new Header("link", names, values);
            BrandingUtil.appendHeaderMarkup(buffer, header);
            buffer.append("\n");
        }
    }

    private static String appendHeaderMarkup(StringBuilder buffer, Header header) {
        buffer.append("<");
        buffer.append(header.getTagName());
        buffer.append(" ");
        String[] names = header.getNames();
        String[] values = header.getValues();
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            String value = values[i];
            if (name != null && value != null) {
                buffer.append(name);
                buffer.append("=\"");
                buffer.append(value);
                buffer.append("\" ");
            }
            ++i;
        }
        buffer.append("/>");
        return buffer.toString();
    }

    private BrandingUtil() {
    }
}

