/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.internal.branding.BrandingUtil;
import org.eclipse.rwt.internal.resources.ResourceRegistry;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.StartupPageConfigurer;
import org.eclipse.rwt.internal.service.StartupPageTemplateHolder;
import org.eclipse.rwt.internal.theme.QxImage;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.SimpleSelector;
import org.eclipse.rwt.internal.theme.ThemeUtil;

public final class StartupPage {
    private final IStartupPageConfigurer configurer;

    public StartupPage(ResourceRegistry resourceRegistry) {
        this.configurer = new StartupPageConfigurer(resourceRegistry);
    }

    public IStartupPageConfigurer getConfigurer() {
        return this.configurer;
    }

    void send() throws IOException {
        if (this.configurer.isModifiedSince()) {
            this.render();
        } else {
            AbstractBranding branding = BrandingUtil.determineBranding();
            if (branding.getThemeId() != null) {
                ThemeUtil.setCurrentThemeId(branding.getThemeId());
            }
        }
    }

    private void render() throws IOException {
        HttpServletResponse response = ContextProvider.getResponse();
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        StartupPageTemplateHolder template = this.configurer.getTemplate();
        template.replace(StartupPageTemplateHolder.VAR_BACKGROUND_IMAGE, StartupPage.getBgImage());
        String[] tokens = template.getTokens();
        PrintWriter writer = response.getWriter();
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i] != null) {
                writer.write(tokens[i]);
            }
            ++i;
        }
    }

    private static String getBgImage() {
        QxImage image;
        String resourceName;
        String result = "";
        QxType value = ThemeUtil.getCssValue("Display", "background-image", SimpleSelector.DEFAULT);
        if (value instanceof QxImage && (resourceName = (image = (QxImage)value).getResourcePath()) != null) {
            result = RWT.getResourceManager().getLocation(resourceName);
        }
        return result;
    }

    public static interface IStartupPageConfigurer {
        public StartupPageTemplateHolder getTemplate() throws IOException;

        public boolean isModifiedSince();

        public void addJsLibrary(String var1);
    }
}

