/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.uicallback;

import java.io.IOException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.uicallback.UICallBackManager;
import org.eclipse.rwt.service.IServiceHandler;
import org.eclipse.rwt.service.ISessionStore;

public class UICallBackServiceHandler
implements IServiceHandler {
    private static final String UI_CALLBACK_ID = "uicb";
    private static final String PROP_ACTIVE = "active";
    private static final String METHOD_SEND_UI_REQUEST = "sendUIRequest";
    public static final String HANDLER_ID = UICallBackServiceHandler.class.getName();
    private static final String ATTR_NEEDS_UICALLBACK = String.valueOf(UICallBackServiceHandler.class.getName()) + ".needsUICallback";

    public void service() throws IOException {
        HttpServletResponse response = ContextProvider.getResponse();
        UICallBackServiceHandler.configureResponseHeaders((ServletResponse)response);
        ISessionStore sessionStore = ContextProvider.getSessionStore();
        ProtocolMessageWriter writer = new ProtocolMessageWriter();
        boolean success = UICallBackManager.getInstance().processRequest(response);
        if (success && sessionStore.isBound()) {
            UICallBackServiceHandler.writeUICallBackDeactivation(writer);
            UICallBackServiceHandler.writeUIRequestNeeded(writer);
        }
        String message = writer.createMessage();
        response.getWriter().write(message);
    }

    public static void writeUICallBackActivation(ProtocolMessageWriter writer) {
        boolean actual = UICallBackManager.getInstance().needsActivation();
        boolean preserved = UICallBackServiceHandler.getPreservedUICallBackActivation();
        if (preserved != actual && actual) {
            UICallBackServiceHandler.writeUICallBackActivation(writer, actual);
            ISessionStore sessionStore = ContextProvider.getSessionStore();
            sessionStore.setAttribute(ATTR_NEEDS_UICALLBACK, actual);
        }
    }

    public static void writeUICallBackDeactivation(ProtocolMessageWriter writer) {
        boolean actual = UICallBackManager.getInstance().needsActivation();
        boolean preserved = UICallBackServiceHandler.getPreservedUICallBackActivation();
        if (preserved != actual && !actual) {
            UICallBackServiceHandler.writeUICallBackActivation(writer, actual);
            ISessionStore sessionStore = ContextProvider.getSessionStore();
            sessionStore.setAttribute(ATTR_NEEDS_UICALLBACK, actual);
        }
    }

    private static void writeUICallBackActivation(ProtocolMessageWriter writer, boolean value) {
        writer.appendSet(UI_CALLBACK_ID, PROP_ACTIVE, value);
    }

    private static boolean getPreservedUICallBackActivation() {
        boolean result = false;
        ISessionStore sessionStore = ContextProvider.getSessionStore();
        Boolean preserved = (Boolean)sessionStore.getAttribute(ATTR_NEEDS_UICALLBACK);
        if (preserved != null) {
            result = preserved;
        }
        return result;
    }

    private static void configureResponseHeaders(ServletResponse response) {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
    }

    static void writeUIRequestNeeded(ProtocolMessageWriter writer) {
        if (UICallBackManager.getInstance().hasRunnables()) {
            writer.appendCall(UI_CALLBACK_ID, METHOD_SEND_UI_REQUEST, null);
        }
    }
}

