/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.lifecycle;

import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rwt.internal.protocol.IClientObject;
import org.eclipse.rwt.internal.protocol.StylesUtil;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.util.EncodingUtil;
import org.eclipse.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rwt.internal.util.SharedInstanceBuffer;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.FontUtil;
import org.eclipse.swt.internal.graphics.ImageFactory;
import org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public final class WidgetLCAUtil {
    private static final String JS_PROP_HEIGHT = "height";
    private static final String JS_PROP_WIDTH = "width";
    private static final String JS_PROP_SPACE = "space";
    private static final String JS_FUNC_SET_TOOL_TIP = "setToolTip";
    private static final String JS_FUNC_SET_ROUNDED_BORDER = "setRoundedBorder";
    private static final String JS_FUNC_SET_HAS_LISTENER = "setHasListener";
    private static final String JS_EVENT_TYPE_HELP = "help";
    private static final String PARAM_X = "bounds.x";
    private static final String PARAM_Y = "bounds.y";
    private static final String PARAM_WIDTH = "bounds.width";
    private static final String PARAM_HEIGHT = "bounds.height";
    private static final String PROP_TOOL_TIP = "toolTip";
    private static final String PROP_FONT = "font";
    private static final String PROP_FOREGROUND = "foreground";
    private static final String PROP_BACKGROUND = "background";
    private static final String PROP_BACKGROUND_TRANSPARENCY = "backgroundTrans";
    private static final String PROP_BACKGROUND_GRADIENT_COLORS = "backgroundGradientColors";
    private static final String PROP_BACKGROUND_GRADIENT_PERCENTS = "backgroundGradientPercents";
    private static final String PROP_BACKGROUND_GRADIENT_VERTICAL = "backgroundGradientVertical";
    private static final String PROP_ROUNDED_BORDER_WIDTH = "roundedBorderWidth";
    private static final String PROP_ROUNDED_BORDER_COLOR = "roundedBorderColor";
    private static final String PROP_ROUNDED_BORDER_RADIUS = "roundedBorderRadius";
    private static final String PROP_ENABLED = "enabled";
    private static final String PROP_VARIANT = "variant";
    private static final String PROP_HELP_LISTENER = "help";
    static final String LISTENER_PREFIX = "listener_";
    private static final Pattern FONT_NAME_FILTER_PATTERN = Pattern.compile("\"|\\\\");
    private static final Rectangle DEF_ROUNDED_BORDER_RADIUS = new Rectangle(0, 0, 0, 0);
    private static final SharedInstanceBuffer<String, String[]> parsedFonts = new SharedInstanceBuffer();

    private WidgetLCAUtil() {
    }

    public static Rectangle readBounds(Widget widget, Rectangle defaultValue) {
        return WidgetLCAUtil.readBounds(WidgetUtil.getId(widget), defaultValue);
    }

    public static Rectangle readBounds(String widgetId, Rectangle defaultValue) {
        int x = WidgetLCAUtil.readBoundsX(widgetId, defaultValue.x);
        int y = WidgetLCAUtil.readBoundsY(widgetId, defaultValue.y);
        int width = WidgetLCAUtil.readBoundsWidth(widgetId, defaultValue.width);
        int height = WidgetLCAUtil.readBoundsHeight(widgetId, defaultValue.height);
        return new Rectangle(x, y, width, height);
    }

    private static int readBoundsY(String widgetId, int defaultValue) {
        String value = WidgetLCAUtil.readPropertyValue(widgetId, PARAM_Y);
        return WidgetLCAUtil.readBoundsValue(value, defaultValue);
    }

    private static int readBoundsX(String widgetId, int defaultValue) {
        String value = WidgetLCAUtil.readPropertyValue(widgetId, PARAM_X);
        return WidgetLCAUtil.readBoundsValue(value, defaultValue);
    }

    private static int readBoundsWidth(String widgetId, int defaultValue) {
        String value = WidgetLCAUtil.readPropertyValue(widgetId, PARAM_WIDTH);
        return WidgetLCAUtil.readBoundsValue(value, defaultValue);
    }

    private static int readBoundsHeight(String widgetId, int defaultValue) {
        String value = WidgetLCAUtil.readPropertyValue(widgetId, PARAM_HEIGHT);
        return WidgetLCAUtil.readBoundsValue(value, defaultValue);
    }

    private static int readBoundsValue(String value, int current) {
        int result = value != null && !"null".equals(value) ? NumberFormatUtil.parseInt(value) : current;
        return result;
    }

    public static void processHelp(Widget widget) {
        if (WidgetLCAUtil.wasEventSent(widget, "org.eclipse.swt.events.help")) {
            HelpEvent event = new HelpEvent(widget);
            event.processEvent();
        }
    }

    public static void preserveBounds(Widget widget, Rectangle bounds) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve("bounds", bounds);
    }

    public static void preserveEnabled(Widget widget, boolean enabled) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(PROP_ENABLED, enabled);
    }

    public static void preserveToolTipText(Widget widget, String toolTip) {
        String text = toolTip == null ? "" : toolTip;
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(PROP_TOOL_TIP, text);
    }

    public static void preserveFont(Widget widget, Font font) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(PROP_FONT, font);
    }

    public static void preserveForeground(Widget widget, Color foreground) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(PROP_FOREGROUND, foreground);
    }

    public static void preserveBackground(Widget widget, Color background) {
        WidgetLCAUtil.preserveBackground(widget, background, false);
    }

    public static void preserveBackground(Widget widget, Color background, boolean transparency) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(PROP_BACKGROUND, background);
        adapter.preserve(PROP_BACKGROUND_TRANSPARENCY, transparency);
    }

    public static void preserveBackgroundGradient(Widget widget) {
        IWidgetGraphicsAdapter adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
        if (adapter != null) {
            IWidgetGraphicsAdapter gfxAdapter = adapter;
            Color[] bgGradientColors = gfxAdapter.getBackgroundGradientColors();
            int[] bgGradientPercents = gfxAdapter.getBackgroundGradientPercents();
            boolean bgGradientVertical = gfxAdapter.isBackgroundGradientVertical();
            IWidgetAdapter widgetAdapter = WidgetUtil.getAdapter(widget);
            widgetAdapter.preserve(PROP_BACKGROUND_GRADIENT_COLORS, bgGradientColors);
            widgetAdapter.preserve(PROP_BACKGROUND_GRADIENT_PERCENTS, bgGradientPercents);
            widgetAdapter.preserve(PROP_BACKGROUND_GRADIENT_VERTICAL, bgGradientVertical);
        }
    }

    public static void preserveRoundedBorder(Widget widget) {
        IWidgetGraphicsAdapter adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
        if (adapter != null) {
            IWidgetGraphicsAdapter gfxAdapter = adapter;
            int width = gfxAdapter.getRoundedBorderWidth();
            Color color = gfxAdapter.getRoundedBorderColor();
            Rectangle radius = gfxAdapter.getRoundedBorderRadius();
            IWidgetAdapter widgetAdapter = WidgetUtil.getAdapter(widget);
            widgetAdapter.preserve(PROP_ROUNDED_BORDER_WIDTH, width);
            widgetAdapter.preserve(PROP_ROUNDED_BORDER_COLOR, color);
            widgetAdapter.preserve(PROP_ROUNDED_BORDER_RADIUS, radius);
        }
    }

    public static void preserveCustomVariant(Widget widget) {
        String variant = WidgetUtil.getVariant(widget);
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(PROP_VARIANT, variant);
    }

    public static void preserveHelpListener(Widget widget) {
        WidgetLCAUtil.preserveListener(widget, "help", HelpEvent.hasListener(widget));
    }

    public static void renderBounds(Widget widget, Rectangle bounds) {
        WidgetLCAUtil.renderProperty(widget, "bounds", bounds, null);
    }

    public static void renderEnabled(Widget widget, boolean enabled) {
        WidgetLCAUtil.renderProperty(widget, PROP_ENABLED, enabled, true);
    }

    public static void renderCustomVariant(Widget widget) {
        String newValue = WidgetUtil.getVariant(widget);
        if (WidgetLCAUtil.hasChanged(widget, PROP_VARIANT, newValue, null)) {
            String value = null;
            if (newValue != null) {
                value = "variant_" + newValue;
            }
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.set("customVariant", value);
        }
    }

    public static void renderListenHelp(Widget widget) {
        WidgetLCAUtil.renderListener(widget, "help", HelpEvent.hasListener(widget), false);
    }

    public static void renderMenu(Widget widget, Menu menu) {
        WidgetLCAUtil.renderProperty(widget, "menu", menu, null);
    }

    public static void renderToolTip(Widget widget, String toolTip) {
        String text = toolTip == null ? "" : toolTip;
        WidgetLCAUtil.renderProperty(widget, PROP_TOOL_TIP, text, "");
    }

    public static void renderFont(Widget widget, Font font) {
        if (WidgetLCAUtil.hasChanged(widget, PROP_FONT, font, null)) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.set(PROP_FONT, WidgetLCAUtil.getFontAsArray(font));
        }
    }

    private static Object[] getFontAsArray(Font font) {
        Object[] result = null;
        if (font != null) {
            FontData fontData = FontUtil.getData(font);
            result = new Object[]{WidgetLCAUtil.parseFontName(fontData.getName()), fontData.getHeight(), (fontData.getStyle() & 1) != 0, (fontData.getStyle() & 2) != 0};
        }
        return result;
    }

    public static String[] parseFontName(final String name) {
        return parsedFonts.get(name, new SharedInstanceBuffer.IInstanceCreator<String[]>(){

            @Override
            public String[] createInstance() {
                return WidgetLCAUtil.parseFontNameInternal(name);
            }
        });
    }

    private static String[] parseFontNameInternal(String name) {
        String[] result = name.split(",");
        int i = 0;
        while (i < result.length) {
            result[i] = result[i].trim();
            Matcher matcher = FONT_NAME_FILTER_PATTERN.matcher(result[i]);
            result[i] = matcher.replaceAll("");
            ++i;
        }
        return result;
    }

    public static void renderForeground(Widget widget, Color newColor) {
        if (WidgetLCAUtil.hasChanged(widget, PROP_FOREGROUND, newColor, null)) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.set(PROP_FOREGROUND, WidgetLCAUtil.getColorValueAsArray(newColor, false));
        }
    }

    private static int[] getColorValueAsArray(Color color, boolean transparent) {
        int[] result = null;
        if (color != null) {
            RGB rgb = color.getRGB();
            result = new int[]{rgb.red, rgb.green, rgb.blue, transparent ? 0 : 255};
        } else if (transparent) {
            result = new int[4];
        }
        return result;
    }

    public static void renderBackground(Widget widget, Color newColor) {
        WidgetLCAUtil.renderBackground(widget, newColor, false);
    }

    public static void renderBackground(Widget widget, Color background, boolean transparency) {
        boolean transparencyChanged = WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND_TRANSPARENCY, transparency, Boolean.FALSE);
        boolean colorChanged = WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND, background, null);
        if (transparencyChanged || colorChanged) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            int[] color = null;
            if (transparency || background != null) {
                color = WidgetLCAUtil.getColorValueAsArray(background, transparency);
            }
            clientObject.set(PROP_BACKGROUND, color);
        }
    }

    public static void renderBackgroundGradient(Widget widget) {
        if (WidgetLCAUtil.hasBackgroundGradientChanged(widget)) {
            IWidgetGraphicsAdapter adapter;
            IWidgetGraphicsAdapter graphicsAdapter = adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
            Color[] bgGradientColors = graphicsAdapter.getBackgroundGradientColors();
            Object[] args = null;
            if (bgGradientColors != null) {
                Object[] colors = new Object[bgGradientColors.length];
                int[] bgGradientPercents = graphicsAdapter.getBackgroundGradientPercents();
                Integer[] percents = new Integer[bgGradientPercents.length];
                int i = 0;
                while (i < colors.length) {
                    colors[i] = WidgetLCAUtil.getColorValueAsArray(bgGradientColors[i], false);
                    ++i;
                }
                i = 0;
                while (i < bgGradientPercents.length) {
                    percents[i] = new Integer(bgGradientPercents[i]);
                    ++i;
                }
                boolean bgGradientVertical = graphicsAdapter.isBackgroundGradientVertical();
                args = new Object[]{colors, percents, new Boolean(bgGradientVertical)};
            }
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.set("backgroundGradient", args);
        }
    }

    private static boolean hasBackgroundGradientChanged(Widget widget) {
        IWidgetGraphicsAdapter graphicsAdapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
        Color[] bgGradientColors = graphicsAdapter.getBackgroundGradientColors();
        int[] bgGradientPercents = graphicsAdapter.getBackgroundGradientPercents();
        boolean bgGradientVertical = graphicsAdapter.isBackgroundGradientVertical();
        return WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND_GRADIENT_COLORS, bgGradientColors, null) || WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND_GRADIENT_PERCENTS, bgGradientPercents, null) || WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND_GRADIENT_VERTICAL, bgGradientVertical, Boolean.FALSE);
    }

    public static void renderRoundedBorder(Widget widget) {
        if (WidgetLCAUtil.hasRoundedBorderChanged(widget)) {
            IWidgetGraphicsAdapter adapter;
            IWidgetGraphicsAdapter graphicAdapter = adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
            Object[] args = null;
            int width = graphicAdapter.getRoundedBorderWidth();
            Color color = graphicAdapter.getRoundedBorderColor();
            if (width > 0 && color != null) {
                Rectangle radius = graphicAdapter.getRoundedBorderRadius();
                args = new Object[]{new Integer(width), WidgetLCAUtil.getColorValueAsArray(color, false), new Integer(radius.x), new Integer(radius.y), new Integer(radius.width), new Integer(radius.height)};
            }
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.set("roundedBorder", args);
        }
    }

    private static boolean hasRoundedBorderChanged(Widget widget) {
        IWidgetGraphicsAdapter adapter;
        IWidgetGraphicsAdapter graphicsAdapter = adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
        int width = graphicsAdapter.getRoundedBorderWidth();
        Color color = graphicsAdapter.getRoundedBorderColor();
        Rectangle radius = graphicsAdapter.getRoundedBorderRadius();
        return WidgetLCAUtil.hasChanged(widget, PROP_ROUNDED_BORDER_WIDTH, new Integer(width), new Integer(0)) || WidgetLCAUtil.hasChanged(widget, PROP_ROUNDED_BORDER_COLOR, color, null) || WidgetLCAUtil.hasChanged(widget, PROP_ROUNDED_BORDER_RADIUS, radius, DEF_ROUNDED_BORDER_RADIUS);
    }

    public static String readPropertyValue(Widget widget, String property) {
        String widgetId = WidgetUtil.getId(widget);
        return WidgetLCAUtil.readPropertyValue(widgetId, property);
    }

    private static String readPropertyValue(String widgetId, String propertyName) {
        HttpServletRequest request = ContextProvider.getRequest();
        StringBuilder key = new StringBuilder();
        key.append(widgetId);
        key.append(".");
        key.append(propertyName);
        return request.getParameter(key.toString());
    }

    public static boolean wasEventSent(Widget widget, String eventName) {
        HttpServletRequest request = ContextProvider.getRequest();
        String widgetId = request.getParameter(eventName);
        return WidgetUtil.getId(widget).equals(widgetId);
    }

    public static void preserveProperty(Widget widget, String property, Object value) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(property, value);
    }

    public static void preserveProperty(Widget widget, String property, int value) {
        WidgetLCAUtil.preserveProperty(widget, property, (Object)value);
    }

    public static void preserveProperty(Widget widget, String property, boolean value) {
        WidgetLCAUtil.preserveProperty(widget, property, (Object)value);
    }

    public static void preserveListener(Widget widget, String listener, boolean value) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(LISTENER_PREFIX + listener, new Boolean(value));
    }

    public static void renderProperty(Widget widget, String property, Object newValue, Object defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.set(property, newValue);
        }
    }

    public static void renderProperty(Widget widget, String property, int newValue, int defaultValue) {
        Integer newValueObject = newValue;
        Integer defaultValueObject = defaultValue;
        WidgetLCAUtil.renderProperty(widget, property, newValueObject, defaultValueObject);
    }

    public static void renderProperty(Widget widget, String property, boolean newValue, boolean defaultValue) {
        Boolean newValueObject = newValue;
        Boolean defaultValueObject = defaultValue;
        WidgetLCAUtil.renderProperty(widget, property, newValueObject, defaultValueObject);
    }

    public static void renderProperty(Widget widget, String property, Image newValue, Image defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.set(property, WidgetLCAUtil.getImageAsArray(newValue));
        }
    }

    public static void renderProperty(Widget widget, String property, Image[] newValue, Image[] defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            Object[] images = new Object[newValue.length];
            int i = 0;
            while (i < images.length) {
                images[i] = WidgetLCAUtil.getImageAsArray(newValue[i]);
                ++i;
            }
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.set(property, images);
        }
    }

    public static void renderProperty(Widget widget, String property, Color newValue, Color defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.set(property, WidgetLCAUtil.getColorValueAsArray(newValue, false));
        }
    }

    public static void renderProperty(Widget widget, String property, Color[] newValue, Color[] defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            Object[] colors = new Object[newValue.length];
            int i = 0;
            while (i < colors.length) {
                int[] colorProperties = null;
                if (newValue[i] != null) {
                    colorProperties = WidgetLCAUtil.getColorValueAsArray(newValue[i], false);
                }
                colors[i] = colorProperties;
                ++i;
            }
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.set(property, colors);
        }
    }

    public static void renderProperty(Widget widget, String property, Font[] newValue, Font[] defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            Object[] fonts = new Object[newValue.length];
            int i = 0;
            while (i < fonts.length) {
                fonts[i] = WidgetLCAUtil.getFontAsArray(newValue[i]);
                ++i;
            }
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.set(property, fonts);
        }
    }

    public static void renderProperty(Widget widget, String property, Point newValue, Point defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            int[] args = null;
            if (newValue != null) {
                args = new int[]{newValue.x, newValue.y};
            }
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.set(property, args);
        }
    }

    public static void renderProperty(Widget widget, String property, Rectangle newValue, Rectangle defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            int[] args = null;
            if (newValue != null) {
                args = new int[]{newValue.x, newValue.y, newValue.width, newValue.height};
            }
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.set(property, args);
        }
    }

    public static void renderProperty(Widget widget, String property, Widget newValue, Widget defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            String widgetId = newValue == null ? null : WidgetUtil.getId(newValue);
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.set(property, widgetId);
        }
    }

    public static void renderListener(Widget widget, String listener, boolean newValue, boolean defaultValue) {
        Boolean defaultValueObject;
        Boolean newValueObject;
        String property = LISTENER_PREFIX + listener;
        if (WidgetLCAUtil.hasChanged(widget, property, newValueObject = new Boolean(newValue), defaultValueObject = new Boolean(defaultValue))) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(widget);
            clientObject.listen(listener, newValue);
        }
    }

    public static boolean hasChanged(Widget widget, String property, Object newValue) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        Object oldValue = adapter.getPreserved(property);
        return !WidgetLCAUtil.equals(oldValue, newValue);
    }

    public static boolean hasChanged(Widget widget, String property, Object newValue, Object defaultValue) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        boolean result = adapter.isInitialized() ? WidgetLCAUtil.hasChanged(widget, property, newValue) : !WidgetLCAUtil.equals(newValue, defaultValue);
        return result;
    }

    public static String replaceNewLines(String input, String replacement) {
        return EncodingUtil.replaceNewLines(input, replacement);
    }

    public static String[] getStyles(Widget widget, String[] styles) {
        return StylesUtil.filterStyles(widget, styles);
    }

    static boolean equals(Object object1, Object object2) {
        boolean result = object1 == object2 ? true : (object1 == null ? false : (object1 instanceof boolean[] && object2 instanceof boolean[] ? Arrays.equals((boolean[])object1, (boolean[])object2) : (object1 instanceof int[] && object2 instanceof int[] ? Arrays.equals((int[])object1, (int[])object2) : (object1 instanceof long[] && object2 instanceof long[] ? Arrays.equals((long[])object1, (long[])object2) : (object1 instanceof float[] && object2 instanceof float[] ? Arrays.equals((float[])object1, (float[])object2) : (object1 instanceof double[] && object2 instanceof double[] ? Arrays.equals((double[])object1, (double[])object2) : (object1 instanceof Object[] && object2 instanceof Object[] ? Arrays.equals((Object[])object1, (Object[])object2) : object1.equals(object2))))))));
        return result;
    }

    private static Object[] getImageAsArray(Image image) {
        Object[] result = null;
        if (image != null) {
            String imagePath = ImageFactory.getImagePath(image);
            Rectangle bounds = image.getBounds();
            result = new Object[]{imagePath, bounds.width, bounds.height};
        }
        return result;
    }

    @Deprecated
    public static void writeBounds(Widget widget, Control parent, Rectangle bounds) throws IOException {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        Rectangle oldBounds = (Rectangle)adapter.getPreserved("bounds");
        Rectangle newBounds = bounds;
        if (!adapter.isInitialized() || !newBounds.equals(oldBounds)) {
            if (parent != null) {
                AbstractWidgetLCA parentLCA = WidgetUtil.getLCA(parent);
                newBounds = parentLCA.adjustCoordinates(widget, newBounds);
            }
            JSWriter writer = JSWriter.getWriterFor(widget);
            if (parent instanceof ScrolledComposite) {
                writer.set(JS_PROP_WIDTH, newBounds.width);
                writer.set(JS_PROP_HEIGHT, newBounds.height);
            } else {
                Object[] args = new Integer[]{new Integer(newBounds.x), new Integer(newBounds.width), new Integer(newBounds.y), new Integer(newBounds.height)};
                writer.set(JS_PROP_SPACE, args);
            }
        }
    }

    @Deprecated
    public static void writeMenu(Widget widget, Menu menu) throws IOException {
        if (WidgetLCAUtil.hasChanged(widget, "menu", menu, null)) {
            JSWriter writer = JSWriter.getWriterFor(widget);
            writer.call(JSWriter.WIDGET_MANAGER_REF, "setContextMenu", new Object[]{widget, menu});
        }
    }

    @Deprecated
    public static void writeToolTip(Widget widget, String toolTip) throws IOException {
        String text;
        String string = text = toolTip == null ? "" : toolTip;
        if (WidgetLCAUtil.hasChanged(widget, PROP_TOOL_TIP, text, "")) {
            JSWriter writer = JSWriter.getWriterFor(widget);
            text = WidgetLCAUtil.escapeText(text, false);
            text = WidgetLCAUtil.replaceNewLines(text, "<br/>");
            Object[] args = new Object[]{widget, text};
            writer.call(JSWriter.WIDGET_MANAGER_REF, JS_FUNC_SET_TOOL_TIP, args);
        }
    }

    @Deprecated
    public static void writeImage(Widget widget, Image image) throws IOException {
        WidgetLCAUtil.writeImage(widget, "image", "icon", image);
    }

    @Deprecated
    public static void writeImage(Widget widget, String javaProperty, String jsProperty, Image image) throws IOException {
        if (WidgetLCAUtil.hasChanged(widget, javaProperty, image, null)) {
            WidgetLCAUtil.writeImage(widget, jsProperty, image);
        }
    }

    @Deprecated
    public static void writeImage(Widget widget, String jsProperty, Image image) throws IOException {
        String path = image == null ? null : ImageFactory.getImagePath(image);
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.set(jsProperty, path);
    }

    @Deprecated
    public static void writeFont(Widget widget, Font font) throws IOException {
        if (WidgetLCAUtil.hasChanged(widget, PROP_FONT, font, null)) {
            JSWriter writer = JSWriter.getWriterFor(widget);
            if (font != null) {
                FontData fontData = FontUtil.getData(font);
                String[] names = WidgetLCAUtil.parseFontName(fontData.getName());
                Object[] args = new Object[]{widget, names, new Integer(fontData.getHeight()), (fontData.getStyle() & 1) != 0, (fontData.getStyle() & 2) != 0};
                writer.call(JSWriter.WIDGET_MANAGER_REF, "setFont", args);
            } else {
                writer.reset(PROP_FONT);
            }
        }
    }

    @Deprecated
    public static void writeForeground(Widget widget, Color newColor) throws IOException {
        if (WidgetLCAUtil.hasChanged(widget, PROP_FOREGROUND, newColor, null)) {
            JSWriter writer = JSWriter.getWriterFor(widget);
            if (newColor != null) {
                writer.set("textColor", newColor);
            } else {
                writer.reset("textColor");
            }
        }
    }

    @Deprecated
    public static void writeBackground(Widget widget, Color newColor) throws IOException {
        WidgetLCAUtil.writeBackground(widget, newColor, false);
    }

    @Deprecated
    public static void writeBackground(Widget widget, Color background, boolean transparency) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        boolean changed = WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND_TRANSPARENCY, transparency, Boolean.FALSE);
        if (!changed && !transparency) {
            changed = WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND, background, null);
        }
        if (changed) {
            if (transparency) {
                writer.set("backgroundGradient", (Object)null);
                writer.set("backgroundColor", (Object)null);
            } else if (background != null) {
                writer.set("backgroundGradient", (Object)null);
                writer.set("backgroundColor", background);
            } else {
                writer.reset("backgroundGradient");
                writer.reset("backgroundColor");
            }
        }
    }

    @Deprecated
    public static void writeBackgroundGradient(Widget widget) throws IOException {
        if (WidgetLCAUtil.hasBackgroundGradientChanged(widget)) {
            IWidgetGraphicsAdapter adapter;
            IWidgetGraphicsAdapter graphicsAdapter = adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
            Color[] bgGradientColors = graphicsAdapter.getBackgroundGradientColors();
            int[] bgGradientPercents = graphicsAdapter.getBackgroundGradientPercents();
            boolean bgGradientVertical = graphicsAdapter.isBackgroundGradientVertical();
            JSWriter writer = JSWriter.getWriterFor(widget);
            Integer[] percents = null;
            if (bgGradientPercents != null) {
                percents = new Integer[bgGradientPercents.length];
                int i = 0;
                while (i < bgGradientPercents.length) {
                    percents[i] = new Integer(bgGradientPercents[i]);
                    ++i;
                }
            }
            Object[] args = new Object[]{widget, bgGradientColors, percents, new Boolean(bgGradientVertical)};
            writer.call(JSWriter.WIDGET_MANAGER_REF, "setBackgroundGradient", args);
        }
    }

    @Deprecated
    public static void writeRoundedBorder(Widget widget) throws IOException {
        if (WidgetLCAUtil.hasRoundedBorderChanged(widget)) {
            IWidgetGraphicsAdapter adapter;
            IWidgetGraphicsAdapter graphicAdapter = adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
            int width = graphicAdapter.getRoundedBorderWidth();
            Rectangle radius = graphicAdapter.getRoundedBorderRadius();
            Color color = graphicAdapter.getRoundedBorderColor();
            Object[] args = new Object[]{widget, new Integer(width), color, new Integer(radius.x), new Integer(radius.y), new Integer(radius.width), new Integer(radius.height)};
            JSWriter writer = JSWriter.getWriterFor(widget);
            writer.call(JSWriter.WIDGET_MANAGER_REF, JS_FUNC_SET_ROUNDED_BORDER, args);
        }
    }

    @Deprecated
    public static void writeEnabled(Widget widget, boolean enabled) throws IOException {
        Boolean newValue = enabled;
        JSWriter writer = JSWriter.getWriterFor(widget);
        Boolean defaultValue = Boolean.TRUE;
        writer.set(PROP_ENABLED, PROP_ENABLED, newValue, defaultValue);
    }

    @Deprecated
    public static void writeCustomVariant(Widget widget) throws IOException {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        String oldValue = (String)adapter.getPreserved(PROP_VARIANT);
        String newValue = WidgetUtil.getVariant(widget);
        if (WidgetLCAUtil.hasChanged(widget, PROP_VARIANT, newValue, null)) {
            JSWriter writer = JSWriter.getWriterFor(widget);
            Object[] args = new Object[]{"variant_" + oldValue};
            if (oldValue != null) {
                writer.call("removeState", args);
            }
            if (newValue != null) {
                args = new Object[]{"variant_" + newValue};
                writer.call("addState", args);
            }
        }
    }

    @Deprecated
    public static void writeHelpListener(Widget widget) throws IOException {
        String prop = "listener_help";
        Boolean hasListener = HelpEvent.hasListener(widget);
        if (WidgetLCAUtil.hasChanged(widget, prop, hasListener, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor(widget);
            Object[] args = new Object[]{widget, "help", hasListener};
            writer.call(JSWriter.WIDGET_MANAGER_REF, JS_FUNC_SET_HAS_LISTENER, args);
        }
    }

    @Deprecated
    public static void writeStyleFlag(Widget widget, int style, String styleName) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        if ((widget.getStyle() & style) != 0) {
            writer.call("addState", new Object[]{"rwt_" + styleName});
        }
    }

    @Deprecated
    public static String escapeText(String text, boolean mnemonics) {
        boolean insertAmp = false;
        StringBuilder buffer = new StringBuilder();
        int textLength = text.length();
        int i = 0;
        while (i < textLength) {
            char ch = text.charAt(i);
            if (ch == '&') {
                if (!mnemonics || insertAmp) {
                    insertAmp = false;
                    buffer.append("&amp;");
                } else if (i + 1 < textLength && text.charAt(i + 1) == '&') {
                    insertAmp = true;
                }
            } else if (ch == '<') {
                buffer.append("&lt;");
            } else if (ch == '>') {
                buffer.append("&gt;");
            } else if (ch == '\"') {
                buffer.append("&quot;");
            } else if (EncodingUtil.isNonDisplayableChar(ch)) {
                buffer.append("&#");
                buffer.append((int)ch);
                buffer.append(";");
            } else {
                buffer.append(ch);
            }
            ++i;
        }
        return EncodingUtil.truncateAtZero(buffer.toString());
    }
}

