/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.IRichTextParserCallback;
import org.eclipse.swt.internal.widgets.RichTextParser;

public final class RichTextUtil {
    public static int getTextWidth(String text, Font font, IImageSizeProvider imageSizeProvider) {
        int result = 0;
        if (RichTextParser.isRichText(text)) {
            TextWidthComputer textWidthComputer = new TextWidthComputer(imageSizeProvider, font);
            RichTextParser parser = new RichTextParser(textWidthComputer);
            parser.parse(text);
            result = textWidthComputer.getMaxLineWidth();
        } else if (text.length() > 0) {
            result = Graphics.stringExtent((Font)font, (String)text).x;
        }
        return result;
    }

    private RichTextUtil() {
    }

    public static interface IImageSizeProvider {
        public Rectangle getImageSize(String var1);
    }

    private static class TextWidthComputer
    implements IRichTextParserCallback {
        private final IImageSizeProvider imageSizeProvider;
        private final Font defaultFont;
        private Font currentFont;
        private int currentLineWidth;
        private int maxLineWidth;

        TextWidthComputer(IImageSizeProvider imageSizeProvider, Font font) {
            this.imageSizeProvider = imageSizeProvider;
            this.defaultFont = font;
        }

        int getMaxLineWidth() {
            return this.maxLineWidth;
        }

        public void beginHtml() {
            this.currentFont = this.defaultFont;
        }

        public void endHtml() {
            this.updateMaxLineWidth();
        }

        public void beginFont(String name, int height) {
            this.currentFont = new Font(this.defaultFont.getDevice(), name, height, 0);
        }

        public void endFont() {
            this.currentFont = this.defaultFont;
        }

        public void text(String text) {
            this.currentLineWidth += Graphics.stringExtent((Font)this.currentFont, (String)text).x;
        }

        public void lineBreak() {
            this.updateMaxLineWidth();
            this.currentLineWidth = 0;
        }

        public void image(String src) {
            this.currentLineWidth += this.imageSizeProvider.getImageSize((String)src).width;
        }

        private void updateMaxLineWidth() {
            if (this.currentLineWidth > this.maxLineWidth) {
                this.maxLineWidth = this.currentLineWidth;
            }
        }
    }
}

