/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.menuitemkit;

import java.io.IOException;
import org.eclipse.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.swt.internal.widgets.menuitemkit.BarMenuItemLCA;
import org.eclipse.swt.internal.widgets.menuitemkit.CheckMenuItemLCA;
import org.eclipse.swt.internal.widgets.menuitemkit.MenuItemDelegateLCA;
import org.eclipse.swt.internal.widgets.menuitemkit.PushMenuItemLCA;
import org.eclipse.swt.internal.widgets.menuitemkit.RadioMenuItemLCA;
import org.eclipse.swt.internal.widgets.menuitemkit.SeparatorMenuItemLCA;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public final class MenuItemLCA
extends AbstractWidgetLCA {
    private static final BarMenuItemLCA BAR_MENU_ITEM_LCA = new BarMenuItemLCA();
    private static final PushMenuItemLCA PUSH_MENU_ITEM_LCA = new PushMenuItemLCA();
    private static final CheckMenuItemLCA CHECK_MENU_ITEM_LCA = new CheckMenuItemLCA();
    private static final RadioMenuItemLCA RADIO_MENU_ITEM_LCA = new RadioMenuItemLCA();
    private static final SeparatorMenuItemLCA SEPARATOR_MENU_ITEM_LCA = new SeparatorMenuItemLCA();

    public void preserveValues(Widget widget) {
        MenuItem item = (MenuItem)widget;
        MenuItemLCA.getDelegateLCA(item).preserveValues(item);
    }

    public void readData(Widget widget) {
        MenuItem item = (MenuItem)widget;
        MenuItemLCA.getDelegateLCA(item).readData(item);
    }

    public void renderInitialization(Widget widget) throws IOException {
        MenuItem item = (MenuItem)widget;
        MenuItemLCA.getDelegateLCA(item).renderInitialization(item);
    }

    public void renderChanges(Widget widget) throws IOException {
        MenuItem item = (MenuItem)widget;
        MenuItemLCA.getDelegateLCA(item).renderChanges(item);
    }

    public void renderDispose(Widget widget) throws IOException {
        ClientObjectFactory.getForWidget(widget).destroy();
    }

    private static boolean isTopLevelMenuBarItem(MenuItem item) {
        return (item.getParent().getStyle() & 2) != 0;
    }

    private static MenuItemDelegateLCA getDelegateLCA(MenuItem item) {
        MenuItemDelegateLCA result;
        if (MenuItemLCA.isTopLevelMenuBarItem(item)) {
            result = BAR_MENU_ITEM_LCA;
        } else if ((item.getStyle() & 0x48) != 0) {
            result = PUSH_MENU_ITEM_LCA;
        } else if ((item.getStyle() & 0x20) != 0) {
            result = CHECK_MENU_ITEM_LCA;
        } else if ((item.getStyle() & 0x10) != 0) {
            result = RADIO_MENU_ITEM_LCA;
        } else if ((item.getStyle() & 2) != 0) {
            result = SEPARATOR_MENU_ITEM_LCA;
        } else {
            throw new IllegalStateException("Unknown menu item type.");
        }
        return result;
    }
}

