/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.spinnerkit;

import java.io.IOException;
import java.text.DecimalFormatSymbols;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rwt.internal.protocol.IClientObject;
import org.eclipse.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public final class SpinnerLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Spinner";
    private static final String[] ALLOWED_STYLES = new String[]{"READ_ONLY", "WRAP", "BORDER"};
    static final String PROP_MINIMUM = "minimum";
    static final String PROP_MAXIMUM = "maximum";
    static final String PROP_SELECTION = "selection";
    static final String PROP_DIGITS = "digits";
    static final String PROP_INCREMENT = "increment";
    static final String PROP_PAGE_INCREMENT = "pageIncrement";
    static final String PROP_TEXT_LIMIT = "textLimit";
    static final String PROP_DECIMAL_SEPARATOR = "decimalSeparator";
    static final String PROP_MODIFY_LISTENER = "modify";
    static final String PROP_SELECTION_LISTENER = "selection";
    private static final int DEFAULT_MINIMUM = 0;
    private static final int DEFAULT_MAXIMUM = 100;
    private static final int DEFAULT_SELECTION = 0;
    private static final int DEFAULT_DIGITS = 0;
    private static final int DEFAULT_INCREMENT = 1;
    private static final int DEFAULT_PAGE_INCREMENT = 10;
    private static final String DEFAULT_DECIMAL_SEPARATOR = ".";

    public void preserveValues(Widget widget) {
        Spinner spinner = (Spinner)widget;
        ControlLCAUtil.preserveValues(spinner);
        WidgetLCAUtil.preserveCustomVariant(spinner);
        WidgetLCAUtil.preserveProperty((Widget)spinner, PROP_MINIMUM, spinner.getMinimum());
        WidgetLCAUtil.preserveProperty((Widget)spinner, PROP_MAXIMUM, spinner.getMaximum());
        WidgetLCAUtil.preserveProperty((Widget)spinner, "selection", spinner.getSelection());
        WidgetLCAUtil.preserveProperty((Widget)spinner, PROP_DIGITS, spinner.getDigits());
        WidgetLCAUtil.preserveProperty((Widget)spinner, PROP_INCREMENT, spinner.getIncrement());
        WidgetLCAUtil.preserveProperty((Widget)spinner, PROP_PAGE_INCREMENT, spinner.getPageIncrement());
        WidgetLCAUtil.preserveProperty((Widget)spinner, PROP_TEXT_LIMIT, SpinnerLCA.getTextLimit(spinner));
        WidgetLCAUtil.preserveProperty((Widget)spinner, PROP_DECIMAL_SEPARATOR, SpinnerLCA.getDecimalSeparator());
        WidgetLCAUtil.preserveListener(spinner, PROP_MODIFY_LISTENER, ModifyEvent.hasListener(spinner));
        WidgetLCAUtil.preserveListener(spinner, "selection", SelectionEvent.hasListener(spinner));
    }

    public void readData(Widget widget) {
        Spinner spinner = (Spinner)widget;
        String value = WidgetLCAUtil.readPropertyValue(widget, "selection");
        if (value != null) {
            spinner.setSelection(NumberFormatUtil.parseInt(value));
        }
        ControlLCAUtil.processSelection(widget, null, false);
        ControlLCAUtil.processMouseEvents(spinner);
        ControlLCAUtil.processKeyEvents(spinner);
        ControlLCAUtil.processMenuDetect(spinner);
        WidgetLCAUtil.processHelp(spinner);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Spinner spinner = (Spinner)widget;
        IClientObject clientObject = ClientObjectFactory.getForWidget(spinner);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(spinner.getParent()));
        clientObject.set("style", WidgetLCAUtil.getStyles(spinner, ALLOWED_STYLES));
    }

    public void renderChanges(Widget widget) throws IOException {
        Spinner spinner = (Spinner)widget;
        ControlLCAUtil.renderChanges(spinner);
        WidgetLCAUtil.renderCustomVariant(spinner);
        SpinnerLCA.renderMinimum(spinner);
        SpinnerLCA.renderMaximum(spinner);
        SpinnerLCA.renderSelection(spinner);
        SpinnerLCA.renderDigits(spinner);
        SpinnerLCA.renderIncrement(spinner);
        SpinnerLCA.renderPageIncrement(spinner);
        SpinnerLCA.renderTextLimit(spinner);
        SpinnerLCA.renderDecimalSeparator(spinner);
        SpinnerLCA.renderListenModify(spinner);
        SpinnerLCA.renderListenSelection(spinner);
    }

    public void renderDispose(Widget widget) throws IOException {
        ClientObjectFactory.getForWidget(widget).destroy();
    }

    private static void renderMinimum(Spinner spinner) {
        WidgetLCAUtil.renderProperty((Widget)spinner, PROP_MINIMUM, spinner.getMinimum(), 0);
    }

    private static void renderMaximum(Spinner spinner) {
        WidgetLCAUtil.renderProperty((Widget)spinner, PROP_MAXIMUM, spinner.getMaximum(), 100);
    }

    private static void renderSelection(Spinner spinner) {
        WidgetLCAUtil.renderProperty((Widget)spinner, "selection", spinner.getSelection(), 0);
    }

    private static void renderDigits(Spinner spinner) {
        WidgetLCAUtil.renderProperty((Widget)spinner, PROP_DIGITS, spinner.getDigits(), 0);
    }

    private static void renderIncrement(Spinner spinner) {
        WidgetLCAUtil.renderProperty((Widget)spinner, PROP_INCREMENT, spinner.getIncrement(), 1);
    }

    private static void renderPageIncrement(Spinner spinner) {
        int defValue = 10;
        WidgetLCAUtil.renderProperty((Widget)spinner, PROP_PAGE_INCREMENT, spinner.getPageIncrement(), defValue);
    }

    private static void renderTextLimit(Spinner spinner) {
        WidgetLCAUtil.renderProperty((Widget)spinner, PROP_TEXT_LIMIT, SpinnerLCA.getTextLimit(spinner), null);
    }

    private static void renderDecimalSeparator(Spinner spinner) {
        String defValue = DEFAULT_DECIMAL_SEPARATOR;
        WidgetLCAUtil.renderProperty((Widget)spinner, PROP_DECIMAL_SEPARATOR, SpinnerLCA.getDecimalSeparator(), defValue);
    }

    private static void renderListenModify(Spinner spinner) {
        WidgetLCAUtil.renderListener(spinner, PROP_MODIFY_LISTENER, ModifyEvent.hasListener(spinner), false);
    }

    private static void renderListenSelection(Spinner spinner) {
        String prop = "selection";
        WidgetLCAUtil.renderListener(spinner, prop, SelectionEvent.hasListener(spinner), false);
    }

    private static Integer getTextLimit(Spinner spinner) {
        Integer result = null;
        int textLimit = spinner.getTextLimit();
        if (textLimit > 0 && textLimit != Integer.MAX_VALUE) {
            result = new Integer(textLimit);
        }
        return result;
    }

    private static String getDecimalSeparator() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(RWT.getLocale());
        return String.valueOf(symbols.getDecimalSeparator());
    }
}

