/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.rwt.internal.application.RWTFactory;
import org.eclipse.rwt.internal.widgets.IDialogAdapter;
import org.eclipse.rwt.widgets.DialogCallback;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Dialog
implements Adaptable,
SerializableCompatibility {
    private static final int HORIZONTAL_DIALOG_UNIT_PER_CHAR = 4;
    final int style;
    final Shell parent;
    protected Shell shell;
    protected int returnCode;
    String title;

    public Dialog(Shell parent) {
        this(parent, 32768);
    }

    public Dialog(Shell parent, int style) {
        this.checkParent(parent);
        this.parent = parent;
        this.style = style;
        this.title = "";
    }

    public Shell getParent() {
        return this.parent;
    }

    public int getStyle() {
        return this.style;
    }

    public String getText() {
        return this.title;
    }

    public void setText(String string) {
        if (string == null) {
            SWT.error(4);
        }
        this.title = string;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        Object result = adapter == IDialogAdapter.class ? new DialogAdapter() : RWTFactory.getAdapterManager().getAdapter(this, adapter);
        return (T)result;
    }

    protected void prepareOpen() {
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            SWT.error(43);
        }
    }

    protected void runEventLoop(Shell shell) {
        shell.open();
        Display display = shell.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    static int convertHorizontalDLUsToPixels(Control control, int dlus) {
        Font dialogFont = control.getFont();
        float charWidth = Graphics.getAvgCharWidth(dialogFont);
        float width = charWidth * (float)dlus + 2.0f;
        return (int)(width / 4.0f);
    }

    static int checkStyle(Shell parent, int style) {
        int result = style;
        int mask = 229376;
        if ((result & 0x10000000) != 0 && ((result &= 0xEFFFFFFF) & mask) == 0) {
            result |= parent == null ? 65536 : 32768;
        }
        if ((result & mask) == 0) {
            result |= 0x10000;
        }
        if ((result & 0x2000000) == 0 && parent != null && (parent.style & 0x2000000) != 0) {
            result |= 0x2000000;
        }
        return result;
    }

    private void checkParent(Shell parent) {
        if (parent == null) {
            SWT.error(4);
        }
        parent.checkWidget();
    }

    private class DialogAdapter
    implements IDialogAdapter,
    SerializableCompatibility {
        private DialogAdapter() {
        }

        public void openNonBlocking(final DialogCallback dialogCallback) {
            Dialog.this.prepareOpen();
            Dialog.this.returnCode = 256;
            Dialog.this.shell.open();
            Dialog.this.shell.addShellListener(new ShellAdapter(){

                public void shellClosed(ShellEvent event) {
                    if (dialogCallback != null) {
                        dialogCallback.dialogClosed(((DialogAdapter)DialogAdapter.this).Dialog.this.returnCode);
                    }
                }
            });
        }
    }
}

