/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rtp.httpdeployer.bundle;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rtp.httpdeployer.bundle.BundleModificationResult;
import org.eclipse.rtp.httpdeployer.internal.AbstractHttpDeployerServlet;
import org.eclipse.rtp.httpdeployer.internal.CommonConstants;
import org.eclipse.rtp.httpdeployer.internal.HttpDeployerUtils;
import org.eclipse.rtp.httpdeployer.internal.RequestResults;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;

public class BundleServlet
extends AbstractHttpDeployerServlet {
    private static final long serialVersionUID = 3749930485862030632L;
    protected static final String REQUEST_PATH_RESOLVED_BUNDLES = "/resolved";
    protected static final String REQUEST_PATH_ACTIVE_BUNDLES = "/active";
    protected static final int ALL_BUNDLES = 0;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String requestPath = request.getPathInfo();
        Document document = requestPath == null ? this.generateBundleList(0) : (requestPath.startsWith(REQUEST_PATH_ACTIVE_BUNDLES) ? this.generateBundleList(32) : (requestPath.startsWith(REQUEST_PATH_RESOLVED_BUNDLES) ? this.generateBundleList(4) : this.generateBundleList(0)));
        HttpDeployerUtils.outputDocument(response, document);
    }

    @Override
    public Document parseDeleteRequest(Document request) {
        return this.parseRequest(request, "bundle", CommonConstants.Action.UNINSTALL);
    }

    @Override
    public Document parsePostRequest(Document request) {
        return this.parseRequest(request, "bundle", CommonConstants.Action.START);
    }

    @Override
    public Document parseMultipartPostRequest(HttpServletRequest request) throws Exception {
        throw new IllegalAccessException();
    }

    @Override
    public void handleOperation(RequestResults result, Element currentElement, CommonConstants.Action action) {
        String name = currentElement.getChildText("name");
        String actionName = currentElement.getChildText("action");
        if (actionName != null && actionName.equalsIgnoreCase("stop")) {
            action = CommonConstants.Action.STOP;
        }
        Bundle bundle = this.searchBundle(name);
        this.handleOperation(result, name, bundle, action);
    }

    private Document generateBundleList(int requestType) {
        Bundle[] bundles = this.receiveBundles(requestType);
        Element root = new Element("bundles");
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            Element bundleXml = new Element("bundle");
            bundleXml.addContent((Content)new Element("name").addContent(bundle.getSymbolicName()));
            bundleXml.addContent((Content)new Element("version").addContent(bundle.getVersion().toString()));
            root.addContent((Content)bundleXml);
            ++n2;
        }
        return new Document(root);
    }

    private void handleOperation(RequestResults result, String name, Bundle bundle, CommonConstants.Action action) {
        if (bundle == null) {
            result.addResult(new BundleModificationResult(name, action, "bundle not found"));
        } else {
            try {
                switch (action) {
                    case START: {
                        bundle.start();
                        break;
                    }
                    case STOP: {
                        bundle.stop();
                        break;
                    }
                    case UNINSTALL: {
                        bundle.uninstall();
                    }
                }
                result.addResult(new BundleModificationResult(name, action));
            }
            catch (BundleException e) {
                result.addResult(new BundleModificationResult(name, action, e.getMessage()));
            }
        }
    }

    protected Bundle[] receiveBundles() {
        Bundle currentBundle = FrameworkUtil.getBundle(HttpDeployerUtils.class);
        BundleContext context = currentBundle.getBundleContext();
        Bundle[] bundles = context.getBundles();
        return bundles;
    }

    private Bundle[] receiveBundles(int requestType) {
        Bundle[] bundles = this.receiveBundles();
        ArrayList<Bundle> validBundles = new ArrayList<Bundle>();
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getState() == requestType || requestType == 0) {
                validBundles.add(bundle);
            }
            ++n2;
        }
        return validBundles.toArray(new Bundle[0]);
    }

    private Bundle searchBundle(String searchedBundle) {
        Bundle[] bundles;
        Bundle[] bundleArray = bundles = this.receiveBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getSymbolicName().equalsIgnoreCase(searchedBundle)) {
                return bundle;
            }
            ++n2;
        }
        return null;
    }
}

