/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rtp.configurator.ui;

import java.util.List;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.rtp.core.model.Source;
import org.eclipse.rtp.core.model.SourceVersion;

public class ComponentsFilter
extends ViewerFilter {
    private String searchString;

    public void setSearchText(String s) {
        this.searchString = ".*" + s + ".*";
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.searchString == null || this.searchString.length() == 0 || element instanceof SourceVersion) {
            return true;
        }
        Source source = (Source)element;
        if (source.getName().matches(this.searchString)) {
            return true;
        }
        List versions = source.getVersions();
        for (SourceVersion sourceVersion : versions) {
            if (!sourceVersion.getVersion().matches(this.searchString)) continue;
            return true;
        }
        return false;
    }
}

