/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rtp.configurator.console;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.rtp.configurator.console.CommandDelegate;
import org.eclipse.rtp.configurator.console.internal.CommandUtil;
import org.eclipse.rtp.core.RuntimeProvisioningService;
import org.eclipse.rtp.core.model.SourceVersion;

public class CommandDelegateImpl
implements CommandDelegate {
    private static RuntimeProvisioningService configurationService;
    private static CommandUtil commandUtil;
    private static final String TAB = "\t";
    private static final String NEW_LINE = "\r\n";

    public static void setUp(RuntimeProvisioningService service) {
        configurationService = service;
        commandUtil = new CommandUtil();
    }

    public static void shutDown(RuntimeProvisioningService service) {
        configurationService = null;
    }

    @Override
    public void unsupportedOperation(String operation) {
        String help = this.getHelp();
        System.out.println(help);
    }

    @Override
    public String getHelp() {
        StringBuilder help = new StringBuilder();
        this.addRTHeader(help);
        this.addHeader("Update Commands", help);
        this.addCommand("install", "Installs a feature. The name of the feature is the first entry. If the secodn entry is not an OSGI version than the latest should be installed.", help);
        this.addCommand("update", "Updates a feature. The name of the feature is the first entry. The feature is updated to its latest version.", help);
        this.addCommand("update-world", "Updates all installed feature to their latest version.", help);
        this.addCommand("remove", "the first entry is the feature which should be removed.", help);
        this.addHeader("Search Commands", help);
        this.addCommand("list", "Lists all available features in the rtp repos.", help);
        this.addCommand("show", "Shows details of a specific component e.g. dependencies, available versions, size and so on. The feature name is the first entry.", help);
        this.addCommand("search", "Lists the available components in the rtp repos which where searched. A phonetic search should is done.", help);
        return help.toString();
    }

    private void addRTHeader(StringBuilder help) {
        help.append("---RT Commands---");
        help.append(NEW_LINE);
    }

    private void addHeader(String header, StringBuilder help) {
        help.append("  -");
        help.append(header);
        help.append("-");
        help.append(NEW_LINE);
    }

    private void addCommand(String command, String description, StringBuilder help) {
        help.append(TAB);
        help.append(command);
        help.append(" - ");
        help.append(description);
        help.append(NEW_LINE);
    }

    @Override
    public void install(List<String> parameter) {
        SourceVersion sourceVersion = commandUtil.getSourceVersions(parameter);
        System.out.println("Loading repository: " + sourceVersion.getRepositoryUrl());
        System.out.println("Repository loaded: " + sourceVersion.getRepositoryUrl());
        System.out.println("Installation started");
        IStatus status = configurationService.install(sourceVersion);
        if (status.isOK()) {
            System.out.println("Feature will not be installed");
        } else {
            System.out.println("Installation successful");
        }
    }

    @Override
    public void update(List<String> anyListOf) {
        System.out.println("Searching for updates");
        System.out.println("Update started");
        configurationService.update(anyListOf);
        System.out.println("Update successful");
    }

    @Override
    public void remove(List<String> anyListOf) {
        List<SourceVersion> sourceVersionsToUninstall = commandUtil.getSourceVersionsToUninstall(anyListOf);
        configurationService.remove(sourceVersionsToUninstall);
    }

    @Override
    public void search(List<String> anyListOf) {
        List search = configurationService.search(anyListOf);
        this.printList(search);
    }

    @Override
    public void show(List<String> anyListOf) {
        List show = configurationService.show(anyListOf);
        this.printList(show);
    }

    @Override
    public void list() {
        try {
            List list = configurationService.list();
            this.printList(list);
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            System.out.println(status);
        }
    }

    private void printList(List<String> list) {
        for (String iu : list) {
            System.out.println(iu);
        }
    }

    @Override
    public void updateWorld() {
        System.out.println("Update started");
        configurationService.updateWorld();
        System.out.println("Update successful");
    }
}

