/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.branding;

import java.util.Map;
import org.eclipse.rap.rwt.internal.util.ParamCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Header {
    private static final String[] EMPTY_STRINGS = new String[0];
    private final String tagName;
    private final String[] names;
    private final String[] values;

    public Header(String tagName, Map<String, String> attributes) {
        Header.checkTagName(tagName);
        this.tagName = tagName;
        if (attributes == null) {
            this.names = EMPTY_STRINGS;
            this.values = EMPTY_STRINGS;
        } else {
            int size = attributes.size();
            this.names = new String[size];
            attributes.keySet().toArray(this.names);
            this.values = new String[size];
            attributes.values().toArray(this.values);
        }
    }

    public Header(String tagName, String[] attributeNames, String[] attributeValues) {
        Header.checkTagName(tagName);
        ParamCheck.notNull(attributeNames, "attributeNames");
        ParamCheck.notNull(attributeValues, "attributeValues");
        if (attributeNames.length != attributeValues.length) {
            String msg = "The arguments 'attributeNames' and 'attributeValues' must have the same length.";
            throw new IllegalArgumentException(msg);
        }
        this.tagName = tagName;
        this.names = new String[attributeNames.length];
        System.arraycopy(attributeNames, 0, this.names, 0, attributeNames.length);
        this.values = new String[attributeValues.length];
        System.arraycopy(attributeValues, 0, this.values, 0, attributeValues.length);
    }

    public String getTagName() {
        return this.tagName;
    }

    public String[] getNames() {
        String[] result = new String[this.names.length];
        System.arraycopy(this.names, 0, result, 0, this.names.length);
        return result;
    }

    public String[] getValues() {
        String[] result = new String[this.values.length];
        System.arraycopy(this.values, 0, result, 0, this.values.length);
        return result;
    }

    private static void checkTagName(String tagName) {
        if (!"link".equals(tagName) && !"meta".equals(tagName)) {
            String msg = "Invalid tag name. The tag name must be either 'meta' or 'link'.";
            throw new IllegalArgumentException(msg);
        }
    }
}

