/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rap.rwt.Adaptable;
import org.eclipse.rap.rwt.AdapterFactory;
import org.eclipse.rap.rwt.internal.util.ParamCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AdapterFactoryRegistry {
    private final Object lock = new Object();
    private final Map<Class, List<AdapterFactory>> registry = new HashMap<Class, List<AdapterFactory>>();

    AdapterFactoryRegistry() {
    }

    void register(Class adaptableClass, AdapterFactory adapterFactory) {
        ParamCheck.notNull(adapterFactory, "adapterFactory");
        ParamCheck.notNull(adaptableClass, "adaptableClass");
        AdapterFactoryRegistry.checkAdaptableClassImplementsAdaptable(adaptableClass);
        this.registerInternal(adaptableClass, adapterFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregisterAdapters() {
        Object object = this.lock;
        synchronized (object) {
            this.registry.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerInternal(Class adaptableClass, AdapterFactory adapterFactory) {
        Object object = this.lock;
        synchronized (object) {
            List<Object> adapterFactories;
            if (this.registry.containsKey(adaptableClass)) {
                adapterFactories = this.registry.get(adaptableClass);
            } else {
                adapterFactories = new ArrayList();
                this.registry.put(adaptableClass, adapterFactories);
            }
            if (!adapterFactories.contains(adapterFactory)) {
                adapterFactories.add(adapterFactory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class[] getAdaptableClasses() {
        Object object = this.lock;
        synchronized (object) {
            Set<Class> adaptableClasses = this.registry.keySet();
            return adaptableClasses.toArray(new Class[adaptableClasses.size()]);
        }
    }

    AdapterFactory[] getAdapterFactories(Class adaptableClass) {
        List<AdapterFactory> adapterFactories = this.getAdapterFacoriesList(adaptableClass);
        AdapterFactory[] result = new AdapterFactory[adapterFactories.size()];
        adapterFactories.toArray(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AdapterFactory> getAdapterFacoriesList(Class adaptableClass) {
        List<AdapterFactory> result;
        Object object = this.lock;
        synchronized (object) {
            result = this.registry.containsKey(adaptableClass) ? this.registry.get(adaptableClass) : Collections.emptyList();
        }
        return result;
    }

    private static void checkAdaptableClassImplementsAdaptable(Class adaptableClass) {
        if (!Adaptable.class.isAssignableFrom(adaptableClass)) {
            String text = "The adaptableClass must implement {0}.";
            String msg = MessageFormat.format(text, Adaptable.class.getName());
            throw new IllegalArgumentException(msg);
        }
    }
}

